/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.streams.impl;

import o.a.c.sidecar.client.shaded.io.vertx.core.AsyncResult;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.VertxException;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.Pipe;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.ReadStream;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.WriteStream;

public class PipeImpl<T>
implements Pipe<T> {
    private final Promise<Void> result;
    private final ReadStream<T> src;
    private boolean endOnSuccess = true;
    private boolean endOnFailure = true;
    private WriteStream<T> dst;

    public PipeImpl(ReadStream<T> src) {
        this.src = src;
        this.result = Promise.promise();
        src.endHandler(this.result::tryComplete);
        src.exceptionHandler(this.result::tryFail);
    }

    @Override
    public synchronized Pipe<T> endOnFailure(boolean end) {
        this.endOnFailure = end;
        return this;
    }

    @Override
    public synchronized Pipe<T> endOnSuccess(boolean end) {
        this.endOnSuccess = end;
        return this;
    }

    @Override
    public synchronized Pipe<T> endOnComplete(boolean end) {
        this.endOnSuccess = end;
        this.endOnFailure = end;
        return this;
    }

    private void handleWriteResult(AsyncResult<Void> ack) {
        if (ack.failed()) {
            this.result.tryFail(new WriteException(ack.cause()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void to(WriteStream<T> ws, Handler<AsyncResult<Void>> completionHandler) {
        if (ws == null) {
            throw new NullPointerException();
        }
        PipeImpl pipeImpl = this;
        synchronized (pipeImpl) {
            if (this.dst != null) {
                throw new IllegalStateException();
            }
            this.dst = ws;
            boolean endOnSuccess = this.endOnSuccess;
            boolean endOnFailure = this.endOnFailure;
        }
        Handler<Void> drainHandler = v -> this.src.resume();
        this.src.handler(item -> {
            ws.write(item, this::handleWriteResult);
            if (ws.writeQueueFull()) {
                this.src.pause();
                ws.drainHandler(drainHandler);
            }
        });
        this.src.resume();
        this.result.future().onComplete(ar -> {
            try {
                this.src.handler(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.src.exceptionHandler((Handler)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.src.endHandler(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ar.succeeded()) {
                this.handleSuccess(completionHandler);
            } else {
                Throwable err = ar.cause();
                if (err instanceof WriteException) {
                    this.src.resume();
                    err = err.getCause();
                }
                this.handleFailure(err, completionHandler);
            }
        });
    }

    private void handleSuccess(Handler<AsyncResult<Void>> completionHandler) {
        if (this.endOnSuccess) {
            this.dst.end(completionHandler);
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
    }

    private void handleFailure(Throwable cause, Handler<AsyncResult<Void>> completionHandler) {
        Future res = Future.failedFuture(cause);
        if (this.endOnFailure) {
            this.dst.end(ignore -> completionHandler.handle(res));
        } else {
            completionHandler.handle(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PipeImpl pipeImpl = this;
        synchronized (pipeImpl) {
            this.src.exceptionHandler((Handler)null);
            this.src.handler(null);
            if (this.dst != null) {
                this.dst.drainHandler(null);
                this.dst.exceptionHandler((Handler)null);
            }
        }
        VertxException err = new VertxException("Pipe closed", true);
        if (this.result.tryFail(err)) {
            this.src.resume();
        }
    }

    private static class WriteException
    extends VertxException {
        private WriteException(Throwable cause) {
            super(cause, true);
        }
    }
}

