/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.common.response;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@Beta
public class ListSnapshotFilesResponse {
    private final List<FileInfo> snapshotFilesInfo = new ArrayList<FileInfo>();

    public void addSnapshotFile(FileInfo fileInfo) {
        this.snapshotFilesInfo.add(fileInfo);
    }

    @JsonProperty(value="snapshotFilesInfo")
    public List<FileInfo> snapshotFilesInfo() {
        return this.snapshotFilesInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListSnapshotFilesResponse that = (ListSnapshotFilesResponse)o;
        return Objects.equals(this.snapshotFilesInfo, that.snapshotFilesInfo);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotFilesInfo);
    }

    public static class FileInfo {
        public final long size;
        public final String host;
        public final int port;
        public final int dataDirIndex;
        public final String snapshotName;
        public final String keySpaceName;
        public final String tableName;
        public final String fileName;
        private String componentDownloadUrl;

        public FileInfo(@JsonProperty(value="size") long size, @JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="dataDirIndex") int dataDirIndex, @JsonProperty(value="snapshotName") String snapshotName, @JsonProperty(value="keySpaceName") String keySpaceName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="fileName") String fileName) {
            this.size = size;
            this.host = host;
            this.port = port;
            this.dataDirIndex = dataDirIndex;
            this.snapshotName = snapshotName;
            this.keySpaceName = keySpaceName;
            this.tableName = tableName;
            this.fileName = fileName;
        }

        public String componentDownloadUrl() {
            if (this.componentDownloadUrl == null) {
                this.componentDownloadUrl = "/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot/components/:component".replaceAll(":keyspace", this.keySpaceName).replaceAll(":table", this.tableName).replaceAll(":snapshot", this.snapshotName).replaceAll(":component", this.fileName) + "?dataDirectoryIndex=" + this.dataDirIndex;
            }
            return this.componentDownloadUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)o;
            return this.size == fileInfo.size && this.port == fileInfo.port && this.dataDirIndex == fileInfo.dataDirIndex && Objects.equals(this.host, fileInfo.host) && Objects.equals(this.snapshotName, fileInfo.snapshotName) && Objects.equals(this.keySpaceName, fileInfo.keySpaceName) && Objects.equals(this.tableName, fileInfo.tableName) && Objects.equals(this.fileName, fileInfo.fileName);
        }

        public int hashCode() {
            return Objects.hash(this.size, this.host, this.port, this.dataDirIndex, this.snapshotName, this.keySpaceName, this.tableName, this.fileName);
        }
    }
}

