/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request.data;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.sidecar.common.request.data.Digest;
import org.jetbrains.annotations.NotNull;

public class MD5Digest
implements Digest {
    @NotNull
    private final String value;

    public MD5Digest(@NotNull String value) {
        this.value = Objects.requireNonNull(value, "value is required");
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String algorithm() {
        return "MD5";
    }

    @Override
    public Map<String, String> headers() {
        return Collections.singletonMap(HttpHeaderNames.CONTENT_MD5.toString(), this.value);
    }
}

