/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.testing.utils.tls;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class CertificateBundle {
    private final String signatureAlgorithm;
    private final X509Certificate[] chain;
    private final X509Certificate root;
    private final KeyPair keyPair;
    private final String alias;

    public CertificateBundle(String signatureAlgorithm, X509Certificate[] chain, X509Certificate root, KeyPair keyPair, String alias) {
        this.signatureAlgorithm = Objects.requireNonNull(signatureAlgorithm);
        this.chain = chain;
        this.root = root;
        this.keyPair = keyPair;
        this.alias = alias != null ? alias : "1";
    }

    public KeyStore toKeyStore(char[] keyEntryPassword) throws KeyStoreException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize PKCS#12 KeyStore.", e);
        }
        keyStore.setCertificateEntry("1", this.root);
        if (!this.isCertificateAuthority()) {
            keyStore.setKeyEntry(this.alias, this.keyPair.getPrivate(), keyEntryPassword, this.chain);
        }
        return keyStore;
    }

    public Path toTempKeyStorePath(Path baseDir, char[] pkcs12Password, char[] keyEntryPassword) throws Exception {
        KeyStore keyStore = this.toKeyStore(keyEntryPassword);
        Path tempFile = Files.createTempFile(baseDir, "ks", ".p12", new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(tempFile, StandardOpenOption.WRITE);){
            keyStore.store(out, pkcs12Password);
        }
        return tempFile;
    }

    public boolean isCertificateAuthority() {
        return this.chain[0].getBasicConstraints() != -1;
    }

    public X509Certificate certificate() {
        return this.chain[0];
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public X509Certificate[] certificatePath() {
        return (X509Certificate[])this.chain.clone();
    }

    public X509Certificate rootCertificate() {
        return this.root;
    }

    public String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }
}

