/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.testing;

import java.util.Objects;

public class QualifiedName {
    private final String keyspace;
    private final String table;
    private final String maybeQuotedKeyspace;
    private final String maybeQuotedTable;

    public QualifiedName(String keyspace, String table) {
        this(keyspace, table, false, false);
    }

    public QualifiedName(String keyspace, String table, boolean quoteKeyspace, boolean quoteTable) {
        this.keyspace = keyspace;
        this.table = table;
        this.maybeQuotedKeyspace = quoteKeyspace ? "\"" + keyspace + "\"" : keyspace;
        this.maybeQuotedTable = quoteTable ? "\"" + table + "\"" : table;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String maybeQuotedKeyspace() {
        return this.maybeQuotedKeyspace;
    }

    public String table() {
        return this.table;
    }

    public String maybeQuotedTable() {
        return this.maybeQuotedTable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)object;
        return Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.table, that.table);
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.table);
    }

    public String toString() {
        return String.format("%s.%s", this.maybeQuotedKeyspace(), this.maybeQuotedTable());
    }
}

