/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.common;

import java.util.concurrent.CompletableFuture;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.common.response.RingResponse;
import org.apache.cassandra.spark.data.ClientConfig;
import org.apache.cassandra.spark.data.DefaultSizing;
import org.apache.cassandra.spark.data.DynamicSizing;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.SidecarTableSizeProvider;
import org.apache.cassandra.spark.data.Sizing;
import org.apache.cassandra.spark.data.TableSizeProvider;
import org.apache.cassandra.spark.data.partitioner.ConsistencyLevel;

public class SizingFactory {
    private SizingFactory() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is a static utility class and shall not be instantiated");
    }

    public static Sizing create(ReplicationFactor replicationFactor, ClientConfig options, ConsistencyLevel consistencyLevel, String keyspace, String table, String datacenter, SidecarClient sidecarClient, int sidecarPort, CompletableFuture<RingResponse> ringFuture) {
        if ("dynamic".equalsIgnoreCase(options.sizing())) {
            TableSizeProvider tableSizeProvider = SizingFactory.getTableSizeProvider(sidecarClient, sidecarPort, ringFuture);
            return new DynamicSizing(tableSizeProvider, consistencyLevel, replicationFactor, keyspace, table, datacenter, options.maxPartitionSize(), options.numCores());
        }
        if (options.sizing() == null || options.sizing().isEmpty() || "default".equalsIgnoreCase(options.sizing())) {
            return new DefaultSizing(options.numCores());
        }
        throw new RuntimeException(String.format("Invalid sizing option provided '%s'", options.sizing()));
    }

    protected static TableSizeProvider getTableSizeProvider(SidecarClient sidecarClient, int sidecarPort, CompletableFuture<RingResponse> ringFuture) {
        return new SidecarTableSizeProvider(sidecarClient, sidecarPort, ringFuture);
    }
}

