/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiClusterContainer<T>
implements Serializable,
MultiClusterSupport<T> {
    private static final long serialVersionUID = 8387168256773834417L;
    private static final Object SENTINEL_KEY = Integer.MAX_VALUE;
    private final Map<Object, T> byCluster = new ConcurrentHashMap<Object, T>();

    public static <T> MultiClusterContainer<T> ofSingle(T value) {
        MultiClusterContainer<T> result = new MultiClusterContainer<T>();
        result.setValue(null, value);
        return result;
    }

    @Override
    @Nullable
    public T getValueOrNull(@Nullable String clusterId) {
        return this.byCluster.get(this.key(clusterId));
    }

    @Nullable
    public T getAnyValue() {
        T v = null;
        if (!this.byCluster.isEmpty()) {
            v = this.byCluster.values().iterator().next();
        }
        return v;
    }

    @NotNull
    public T getAnyValueOrThrow() throws NoSuchElementException {
        T v = this.getAnyValue();
        if (v == null) {
            throw new NoSuchElementException("No value is found");
        }
        return v;
    }

    @Override
    public int size() {
        return this.byCluster.size();
    }

    @Override
    public void forEach(BiConsumer<String, T> action) {
        this.byCluster.forEach((? super K key, ? super V value) -> {
            if (key == SENTINEL_KEY) {
                action.accept(null, value);
            } else {
                action.accept((String)key, value);
            }
        });
    }

    public void setValue(@Nullable String clusterId, @NotNull T value) {
        if (clusterId == null) {
            Preconditions.checkState((this.byCluster.isEmpty() || this.byCluster.containsKey(SENTINEL_KEY) ? 1 : 0) != 0, (Object)"Cannot set value for null cluster when the container is used for coordinated-write");
            this.byCluster.put(SENTINEL_KEY, value);
        } else {
            Preconditions.checkState((!this.byCluster.containsKey(SENTINEL_KEY) ? 1 : 0) != 0, (Object)"Cannot set value for non-null cluster when the container is used for non-coordinated-write");
            this.byCluster.put(clusterId, value);
        }
    }

    public void updateValue(@Nullable String clusterId, UnaryOperator<T> valueUpdater) {
        if (clusterId == null) {
            Preconditions.checkState((this.byCluster.isEmpty() || this.byCluster.containsKey(SENTINEL_KEY) ? 1 : 0) != 0, (Object)"Cannot set value for null cluster when the container is used for coordinated-write");
            this.byCluster.compute(SENTINEL_KEY, (id, value) -> valueUpdater.apply(value));
        } else {
            Preconditions.checkState((!this.byCluster.containsKey(SENTINEL_KEY) ? 1 : 0) != 0, (Object)"Cannot set value for non-null cluster when the container is used for non-coordinated-write");
            this.byCluster.compute(clusterId, (id, value) -> valueUpdater.apply(value));
        }
    }

    public void addAll(Map<String, T> clusters) {
        Preconditions.checkState((!this.byCluster.containsKey(SENTINEL_KEY) ? 1 : 0) != 0, (Object)"Cannot set value for non-null cluster when the container is used for non-coordinated-write");
        this.byCluster.putAll(clusters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiClusterContainer)) {
            return false;
        }
        MultiClusterContainer that = (MultiClusterContainer)obj;
        return Objects.equals(this.byCluster, that.byCluster);
    }

    public int hashCode() {
        return Objects.hash(this.byCluster);
    }

    private Object key(@Nullable String clusterId) {
        return clusterId == null ? SENTINEL_KEY : clusterId;
    }
}

