/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Range;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.common.request.data.CreateSliceRequestPayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobSummaryResponsePayload;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.SSTableDescriptor;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.spark.bulkwriter.BulkWriteValidator;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.StreamError;
import org.apache.cassandra.spark.bulkwriter.StreamResult;
import org.apache.cassandra.spark.bulkwriter.StreamSession;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.Bundle;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleNameGenerator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleStorageObject;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageStreamResult;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CreatedRestoreSlice;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableLister;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTablesBundler;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedCloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.common.SSTables;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.exception.ConsistencyNotSatisfiedException;
import org.apache.cassandra.spark.exception.S3ApiCallException;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStorageStreamSession
extends StreamSession<TransportContext.CloudStorageTransportContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudStorageStreamSession.class);
    private static final String WRITE_PHASE = "UploadAndPrepareToImport";
    protected final BundleNameGenerator bundleNameGenerator;
    protected final CloudStorageDataTransferApi dataTransferApi;
    protected final CassandraBridge bridge;
    private final Set<CreatedRestoreSlice> createdRestoreSlices = new HashSet<CreatedRestoreSlice>();
    private final SSTablesBundler sstablesBundler;
    private int bundleCount = 0;

    public CloudStorageStreamSession(BulkWriterContext bulkWriterContext, SortedSSTableWriter sstableWriter, TransportContext.CloudStorageTransportContext transportContext, String sessionID, Range<BigInteger> tokenRange, ReplicaAwareFailureHandler<RingInstance> failureHandler, ExecutorService executorService) {
        this(bulkWriterContext, sstableWriter, transportContext, sessionID, tokenRange, CassandraBridgeFactory.get(bulkWriterContext.cluster().getLowestCassandraVersion()), failureHandler, executorService);
    }

    @VisibleForTesting
    public CloudStorageStreamSession(BulkWriterContext bulkWriterContext, SortedSSTableWriter sstableWriter, TransportContext.CloudStorageTransportContext transportContext, String sessionID, Range<BigInteger> tokenRange, CassandraBridge bridge, ReplicaAwareFailureHandler<RingInstance> failureHandler, ExecutorService executorService) {
        super(bulkWriterContext, sstableWriter, transportContext, sessionID, tokenRange, failureHandler, executorService);
        JobInfo job = bulkWriterContext.job();
        long maxSizePerBundleInBytes = job.transportInfo().getMaxSizePerBundleInBytes();
        this.bundleNameGenerator = new BundleNameGenerator(job.getId(), sessionID);
        this.dataTransferApi = transportContext.dataTransferApi();
        this.bridge = bridge;
        QualifiedTableName qualifiedTableName = job.qualifiedTableName();
        SSTableLister sstableLister = new SSTableLister(qualifiedTableName, bridge);
        Path bundleStagingDir = sstableWriter.getOutDir().resolve("bundle_staging");
        this.sstablesBundler = new SSTablesBundler(bundleStagingDir, sstableLister, this.bundleNameGenerator, maxSizePerBundleInBytes);
    }

    @Override
    protected void onSSTablesProduced(Set<SSTableDescriptor> sstables) {
        if (sstables.isEmpty() || this.isStreamFinalized()) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                Map<Path, Digest> fileDigests = this.sstableWriter.prepareSStablesToSend(this.writerContext, sstables);
                this.sstablesBundler.includeFileDigests(fileDigests);
                fileDigests.keySet().stream().collect(Collectors.groupingBy(SSTables::getSSTableBaseName)).values().forEach(this.sstablesBundler::includeSSTable);
                if (!this.sstablesBundler.hasNext()) {
                    return;
                }
                ++this.bundleCount;
                Bundle bundle = this.sstablesBundler.next();
                try {
                    this.sendBundle(bundle, false);
                }
                catch (RuntimeException e) {
                    LOGGER.error("[{}]: Unexpected exception while upload SSTable", (Object)this.sessionID, (Object)e);
                    this.setLastStreamFailure(e);
                }
                finally {
                    bundle.deleteAll();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    protected StreamResult doFinalizeStream() {
        this.sstablesBundler.includeDirectory(this.sstableWriter.getOutDir());
        this.sstablesBundler.includeFileDigests(this.sstableWriter.fileDigestMap());
        this.sstablesBundler.finish();
        if (!this.sstablesBundler.hasNext() && this.bundleCount == 0) {
            if (this.sstableWriter.sstableCount() != 0) {
                LOGGER.error("[{}] SSTable writer has produced files, but no bundle is produced", (Object)this.sessionID);
                throw new RuntimeException("Bundle expected but not found");
            }
            LOGGER.warn("[{}] SSTableBundler does not produce any bundle to send", (Object)this.sessionID);
            return CloudStorageStreamResult.empty(this.sessionID, (Range<BigInteger>)this.tokenRange);
        }
        this.sendRemainingSSTables();
        LOGGER.info("[{}]: Uploaded bundles to S3. sstables={} bundles={}", new Object[]{this.sessionID, this.sstableWriter.sstableCount(), this.bundleCount});
        int sliceCount = this.writerContext.job().isCoordinatedWriteEnabled() ? this.bundleCount : this.createdRestoreSlices.size();
        CloudStorageStreamResult streamResult = new CloudStorageStreamResult(this.sessionID, (Range<BigInteger>)this.tokenRange, this.errors, this.replicas, this.createdRestoreSlices, sliceCount, this.sstableWriter.rowCount(), this.sstableWriter.bytesWritten());
        LOGGER.info("StreamResult: {}", (Object)streamResult);
        if (!this.writerContext.job().isCoordinatedWriteEnabled()) {
            BulkWriteValidator.validateClOrFail(this.tokenRangeMapping, this.failureHandler, LOGGER, WRITE_PHASE, this.writerContext.job(), this.writerContext.cluster());
        }
        return streamResult;
    }

    @Override
    protected void sendRemainingSSTables() {
        while (this.sstablesBundler.hasNext()) {
            ++this.bundleCount;
            try {
                this.sendBundle(this.sstablesBundler.next(), false);
            }
            catch (RuntimeException e) {
                LOGGER.error("[{}]: Unexpected exception while upload SSTable", (Object)this.sessionID, (Object)e);
                throw e;
            }
            finally {
                this.sstablesBundler.cleanupBundle(this.sessionID);
            }
        }
    }

    void sendBundle(Bundle bundle, boolean hasRefreshedCredentials) {
        BundleStorageObject bundleStorageObject;
        StorageCredentials writeCredentials = this.getStorageCredentialsFromSidecar();
        try {
            bundleStorageObject = this.uploadBundle(writeCredentials, bundle);
        }
        catch (Exception e) {
            if (!hasRefreshedCredentials) {
                this.sendBundle(bundle, true);
                return;
            }
            LOGGER.error("[{}]: Failed to send SSTables after refreshing token", (Object)this.sessionID, (Object)e);
            throw new RuntimeException(e);
        }
        this.createRestoreSliceOnSidecar(bundleStorageObject);
    }

    private void createRestoreSliceOnSidecar(BundleStorageObject bundleStorageObject) {
        if (this.writerContext.job().isCoordinatedWriteEnabled()) {
            CoordinatedCloudStorageDataTransferApi coordinatedApi = (CoordinatedCloudStorageDataTransferApi)this.dataTransferApi;
            coordinatedApi.forEach((clusterId, ignored) -> {
                String readBucket = ((TransportContext.CloudStorageTransportContext)this.transportContext).transportConfiguration().readAccessConfiguration((String)clusterId).bucket();
                CreateSliceRequestPayload slicePayload = this.toCreateSliceRequestPayload(bundleStorageObject, readBucket);
                coordinatedApi.createRestoreSliceFromExecutor((String)clusterId, slicePayload);
            });
        } else {
            CreateSliceRequestPayload slicePayload = this.toCreateSliceRequestPayload(bundleStorageObject);
            this.replicas.removeIf(replica -> !this.tryCreateRestoreSlicePerReplica((RingInstance)replica, slicePayload));
            if (this.replicas.isEmpty()) {
                throw new ConsistencyNotSatisfiedException("All replicas of the token range has failed. tokenRange: " + String.valueOf(this.getTokenRange()));
            }
            this.createdRestoreSlices.add(new CreatedRestoreSlice(slicePayload));
        }
    }

    private StorageCredentials getStorageCredentialsFromSidecar() {
        try {
            RestoreJobSummaryResponsePayload summary = this.dataTransferApi.restoreJobSummary();
            return StorageCredentials.fromSidecarCredentials(summary.secrets().writeCredentials());
        }
        catch (SidecarApiCallException exception) {
            LOGGER.error("[{}]: Failed to get restore job summary during uploading SSTable bundles", (Object)this.sessionID, (Object)exception);
            throw exception;
        }
    }

    private BundleStorageObject uploadBundle(StorageCredentials writeCredentials, Bundle bundle) throws S3ApiCallException {
        BundleStorageObject object = this.dataTransferApi.uploadBundle(writeCredentials, bundle);
        ((TransportContext.CloudStorageTransportContext)this.transportContext).transportExtensionImplementation().onObjectPersisted(((TransportContext.CloudStorageTransportContext)this.transportContext).transportConfiguration().writeAccessConfiguration().bucket(), object.storageObjectKey, bundle.bundleCompressedSize);
        LOGGER.info("[{}]: Uploaded bundle. storageKey={} uncompressedSize={} compressedSize={}", new Object[]{this.sessionID, object.storageObjectKey, bundle.bundleUncompressedSize, bundle.bundleCompressedSize});
        return object;
    }

    private boolean tryCreateRestoreSlicePerReplica(RingInstance replica, CreateSliceRequestPayload slicePayload) {
        try {
            SidecarInstance sidecarInstance = Sidecar.toSidecarInstance((CassandraInstance)replica, (int)this.writerContext.job().effectiveSidecarPort());
            this.dataTransferApi.createRestoreSliceFromExecutor(sidecarInstance, slicePayload);
            return true;
        }
        catch (Exception exception) {
            LOGGER.error("[{}]: Failed to create slice. instance={}, slicePayload={}", new Object[]{this.sessionID, replica.nodeName(), slicePayload, exception});
            this.writerContext.cluster().refreshClusterInfo();
            Range failedRange = Range.closed((Comparable)slicePayload.firstToken(), (Comparable)slicePayload.endToken());
            this.failureHandler.addFailure((Range<BigInteger>)failedRange, replica, exception.getMessage());
            this.errors.add(new StreamError((Range<BigInteger>)failedRange, replica, exception.getMessage()));
            return false;
        }
    }

    private CreateSliceRequestPayload toCreateSliceRequestPayload(BundleStorageObject bundleStorageObject) {
        return this.toCreateSliceRequestPayload(bundleStorageObject, ((TransportContext.CloudStorageTransportContext)this.transportContext).transportConfiguration().readAccessConfiguration(null).bucket());
    }

    private CreateSliceRequestPayload toCreateSliceRequestPayload(BundleStorageObject bundleStorageObject, String readBucket) {
        Bundle bundle = bundleStorageObject.bundle;
        String sliceId = this.generateSliceId(bundle.bundleSequence);
        return new CreateSliceRequestPayload(sliceId, 0, readBucket, bundleStorageObject.storageObjectKey, bundleStorageObject.storageObjectChecksum, bundle.firstToken, bundle.endToken, Long.valueOf(bundle.bundleUncompressedSize), Long.valueOf(bundle.bundleCompressedSize));
    }

    private String generateSliceId(int bundleSequence) {
        return this.sessionID + "-" + bundleSequence;
    }

    @VisibleForTesting
    Set<CreatedRestoreSlice> createdRestoreSlices() {
        return this.createdRestoreSlices;
    }
}

