/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.BaseCassandraBridgeFactory;
import org.apache.cassandra.bridge.BigNumberConfigImpl;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.secrets.SslConfig;
import org.apache.cassandra.spark.data.CassandraDataLayer;
import org.apache.cassandra.spark.data.LocalDataLayer;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.data.partitioner.TokenPartitioner;
import org.apache.cassandra.spark.sparksql.filters.SSTableTimeRangeFilter;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoRegistrator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoRegister
implements KryoRegistrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KryoRegister.class);
    private static final String SPARK_SERIALIZER = "spark.serializer";
    private static final String SPARK_REGISTRATORS = "spark.kryo.registrator";
    private static final Map<Class<?>, Serializer<?>> KRYO_SERIALIZERS = Collections.synchronizedMap(new LinkedHashMap());
    public static final Map<CassandraVersion, Class<?>> KRYO_REGISTRATORS = Map.of(CassandraVersion.FOURZERO, V40.class, CassandraVersion.FOURONE, V41.class, CassandraVersion.FIVEZERO, V50.class);
    private final CassandraVersion cassandraVersion;

    public static <T> void addSerializer(@NotNull Class<T> type, @NotNull Serializer<T> serializer) {
        LOGGER.info("Registering custom Kryo serializer type={}", (Object)type.getName());
        KRYO_SERIALIZERS.put(type, serializer);
    }

    protected KryoRegister(CassandraVersion cassandraVersion) {
        this.cassandraVersion = cassandraVersion;
    }

    public void registerClasses(@NotNull Kryo kryo) {
        LOGGER.info("Initializing KryoRegister for Cassandra bridge {}", (Object)this.cassandraVersion);
        CassandraBridgeFactory.get(this.cassandraVersion).kryoRegister(kryo);
        KRYO_SERIALIZERS.forEach((arg_0, arg_1) -> ((Kryo)kryo).register(arg_0, arg_1));
    }

    public static void setup(@NotNull SparkConf configuration) {
        LOGGER.info("Setting up Kryo");
        configuration.set(SPARK_SERIALIZER, "org.apache.spark.serializer.KryoSerializer");
        Set registratorsSet = Arrays.stream(configuration.get(SPARK_REGISTRATORS, "").split(",")).filter(string -> string != null && !string.isEmpty()).collect(Collectors.toSet());
        CassandraVersion cassandraVersion = BaseCassandraBridgeFactory.getCassandraVersion((String)configuration.get("spark.cassandra_analytics.cassandra.version", "4.0.0"));
        Class<?> registratorClass = KRYO_REGISTRATORS.get(cassandraVersion);
        if (registratorClass == null) {
            throw new IllegalArgumentException("Kryo registrator not configured for Cassandra version: " + String.valueOf(cassandraVersion));
        }
        registratorsSet.add(registratorClass.getName());
        String registratorsString = String.join((CharSequence)",", registratorsSet);
        LOGGER.info("Setting kryo registrators: " + registratorsString);
        configuration.set(SPARK_REGISTRATORS, registratorsString);
        configuration.registerKryoClasses(new Class[]{registratorClass});
    }

    static {
        KRYO_SERIALIZERS.put(LocalDataLayer.class, new LocalDataLayer.Serializer());
        KRYO_SERIALIZERS.put(CassandraInstance.class, (Serializer<?>)CassandraInstance.SERIALIZER);
        KRYO_SERIALIZERS.put(ReplicationFactor.class, (Serializer<?>)new ReplicationFactor.Serializer());
        KRYO_SERIALIZERS.put(CassandraRing.class, (Serializer<?>)new CassandraRing.Serializer());
        KRYO_SERIALIZERS.put(TokenPartitioner.class, (Serializer<?>)new TokenPartitioner.Serializer());
        KRYO_SERIALIZERS.put(CassandraDataLayer.class, new CassandraDataLayer.Serializer());
        KRYO_SERIALIZERS.put(BigNumberConfigImpl.class, (Serializer<?>)new BigNumberConfigImpl.Serializer());
        KRYO_SERIALIZERS.put(SslConfig.class, (Serializer<?>)new SslConfig.Serializer());
        KRYO_SERIALIZERS.put(SSTableTimeRangeFilter.class, (Serializer<?>)new SSTableTimeRangeFilter.Serializer());
    }

    public static class V50
    extends KryoRegister {
        public V50() {
            super(CassandraVersion.FIVEZERO);
        }
    }

    public static class V41
    extends KryoRegister {
        public V41() {
            super(CassandraVersion.FOURONE);
        }
    }

    public static class V40
    extends KryoRegister {
        public V40() {
            super(CassandraVersion.FOURZERO);
        }
    }
}

