/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.predicate.ResponsePredicateResult;
import io.vertx.ext.web.codec.BodyCodec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.client.HttpClient;
import org.apache.cassandra.sidecar.client.HttpClientConfig;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.HttpResponseImpl;
import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.client.StreamConsumer;
import org.apache.cassandra.sidecar.client.StreamConsumerWriteStream;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.request.UploadableRequest;
import org.apache.cassandra.sidecar.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxHttpClient
implements HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxHttpClient.class);
    protected final Vertx vertx;
    protected final WebClient webClient;
    protected final HttpClientConfig config;

    public VertxHttpClient(Vertx vertx, HttpClientConfig config) {
        WebClientOptions options = new WebClientOptions().setMaxPoolSize(config.maxPoolSize()).setIdleTimeout(config.idleTimeoutMillis()).setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setMaxChunkSize(config.maxChunkSize()).setReceiveBufferSize(config.receiveBufferSize()).setConnectTimeout((int)config.timeoutMillis()).setUserAgent(config.userAgent());
        options = VertxHttpClient.applySSLOptions(options, config);
        this.vertx = vertx;
        this.webClient = WebClient.create((Vertx)vertx, (WebClientOptions)options);
        this.config = config;
    }

    public VertxHttpClient(Vertx vertx, WebClient webClient, HttpClientConfig config) {
        this.vertx = vertx;
        this.webClient = webClient;
        this.config = config;
    }

    Vertx vertx() {
        return this.vertx;
    }

    public HttpClientConfig config() {
        return this.config;
    }

    public CompletableFuture<HttpResponse> execute(SidecarInstance sidecarInstance, RequestContext context) {
        if (context.request() instanceof UploadableRequest) {
            HttpRequest<Buffer> vertxRequest = this.vertxRequest(sidecarInstance, context);
            UploadableRequest uploadableRequest = (UploadableRequest)context.request();
            LOGGER.debug("Uploading file={}, for request={}, instance={}", new Object[]{uploadableRequest.filename(), context.request(), sidecarInstance});
            return this.executeUploadFileInternal(sidecarInstance, vertxRequest, uploadableRequest.filename());
        }
        LOGGER.debug("Executing request={}, on instance={}", (Object)context.request(), (Object)sidecarInstance);
        return this.executeInternal(sidecarInstance, context);
    }

    protected CompletableFuture<HttpResponse> executeInternal(SidecarInstance sidecarInstance, RequestContext context) {
        Future future = Future.future(promise -> promise.complete((Object)this.vertxRequest(sidecarInstance, context).ssl(Boolean.valueOf(this.config.ssl())).timeout(this.config.timeoutMillis())));
        return future.compose(vertxRequest -> {
            Request request = context.request();
            if (request.requestBody() != null) {
                return vertxRequest.sendJson(request.requestBody());
            }
            return vertxRequest.send();
        }).map(response -> {
            byte[] raw = response.body() != null ? ((Buffer)response.body()).getBytes() : null;
            return new HttpResponseImpl(response.statusCode(), response.statusMessage(), raw, this.mapHeaders(response.headers()), sidecarInstance);
        }).toCompletionStage().toCompletableFuture();
    }

    protected CompletableFuture<HttpResponse> executeUploadFileInternal(SidecarInstance sidecarInstance, HttpRequest<Buffer> vertxRequest, String filename) {
        Promise promise = Promise.promise();
        this.openFileForRead(this.vertx.fileSystem(), filename).compose(pair -> vertxRequest.ssl(Boolean.valueOf(this.config.ssl())).putHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(pair.getKey())).sendStream((ReadStream)((AsyncFile)pair.getValue()).setReadBufferSize(this.config.sendReadBufferSize()))).onFailure(arg_0 -> ((Promise)promise).fail(arg_0)).onSuccess(response -> {
            byte[] raw = response.body() != null ? ((Buffer)response.body()).getBytes() : null;
            promise.complete((Object)new HttpResponseImpl(response.statusCode(), response.statusMessage(), raw, this.mapHeaders(response.headers()), sidecarInstance));
        });
        return promise.future().toCompletionStage().toCompletableFuture();
    }

    public CompletableFuture<HttpResponse> stream(SidecarInstance sidecarInstance, RequestContext context, StreamConsumer streamConsumer) {
        Objects.requireNonNull(streamConsumer, "The streamConsumer must be set");
        HttpRequest<Buffer> vertxRequest = this.vertxRequest(sidecarInstance, context);
        LOGGER.debug("Streaming request={}, from instance={}", (Object)context.request(), (Object)sidecarInstance);
        Promise promise = Promise.promise();
        vertxRequest.ssl(Boolean.valueOf(this.config.ssl())).timeout(this.config.timeoutMillis()).expect(response -> {
            promise.complete((Object)new HttpResponseImpl(response.statusCode(), response.statusMessage(), this.mapHeaders(response.headers()), sidecarInstance));
            if (response.statusCode() == HttpResponseStatus.OK.code() || response.statusCode() == HttpResponseStatus.PARTIAL_CONTENT.code()) {
                return ResponsePredicateResult.success();
            }
            LOGGER.warn("Unexpected status code received statusCode={}, statusMessage={}", (Object)response.statusCode(), (Object)response.statusMessage());
            return ResponsePredicateResult.failure((String)("Unexpected status code: " + response.statusCode()));
        }).as(BodyCodec.pipe((WriteStream)new StreamConsumerWriteStream(streamConsumer))).send().onFailure(throwable -> {
            if (!promise.tryFail(throwable)) {
                streamConsumer.onError(throwable);
            }
        });
        return promise.future().toCompletionStage().toCompletableFuture();
    }

    public void close() {
        this.webClient.close();
    }

    protected HttpRequest<Buffer> vertxRequest(SidecarInstance sidecarInstance, RequestContext context) {
        Request request = context.request();
        HttpMethod method = HttpMethod.valueOf((String)request.method().name());
        HttpRequest<Buffer> vertxRequest = this.webClient.request(method, sidecarInstance.port(), sidecarInstance.hostname(), request.requestURI());
        vertxRequest = this.applyHeaders(vertxRequest, request.headers());
        Map customHeaders = context.customHeaders();
        if (customHeaders != null && !customHeaders.isEmpty()) {
            vertxRequest = this.applyHeaders(vertxRequest, customHeaders);
        }
        return vertxRequest;
    }

    protected HttpRequest<Buffer> applyHeaders(HttpRequest<Buffer> vertxRequest, Map<String, String> headers) {
        this.applyAuthHeader(vertxRequest);
        if (headers == null || headers.isEmpty()) {
            return vertxRequest;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            vertxRequest = vertxRequest.putHeader(header.getKey(), header.getValue());
        }
        return vertxRequest;
    }

    private HttpRequest<Buffer> applyAuthHeader(HttpRequest<Buffer> vertxRequest) {
        if (StringUtils.isNullOrEmpty((String)this.config.cassandraRole())) {
            return vertxRequest;
        }
        vertxRequest = vertxRequest.putHeader("cassandra-auth-role", this.config.cassandraRole());
        return vertxRequest;
    }

    protected Map<String, List<String>> mapHeaders(MultiMap headers) {
        if (headers == null) {
            return Collections.emptyMap();
        }
        return headers.entries().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList((String)entry.getValue())));
    }

    protected static WebClientOptions applySSLOptions(WebClientOptions options, HttpClientConfig config) {
        if (!config.ssl()) {
            return options;
        }
        options = options.setSsl(true);
        if (config.trustStoreInputStream() != null && config.trustStorePassword() != null) {
            KeyStoreOptions trustOptions = VertxHttpClient.buildKeyCertOptions(config.trustStoreInputStream(), config.trustStorePassword(), config.trustStoreType());
            options = options.setTrustOptions((TrustOptions)trustOptions);
        }
        if (config.keyStoreInputStream() != null && config.keyStorePassword() != null) {
            KeyStoreOptions keyCertOptions = VertxHttpClient.buildKeyCertOptions(config.keyStoreInputStream(), config.keyStorePassword(), config.keyStoreType());
            options = options.setKeyCertOptions((KeyCertOptions)keyCertOptions);
        }
        if (OpenSSLEngineOptions.isAvailable()) {
            LOGGER.info("Building Sidecar vertx client with OpenSSL");
            options = options.setOpenSslEngineOptions(new OpenSSLEngineOptions());
        } else {
            LOGGER.warn("OpenSSL not available when building Sidecar vertx client");
        }
        return options;
    }

    protected static KeyStoreOptions buildKeyCertOptions(InputStream storeStream, String storePass, String storeType) {
        KeyStoreOptions keyStoreOptions;
        block8: {
            InputStream inputStream = storeStream;
            try {
                byte[] trustBytes = VertxHttpClient.readStore(inputStream);
                keyStoreOptions = new KeyStoreOptions().setType(storeType).setPassword(storePass).setValue(Buffer.buffer((byte[])trustBytes));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load default truststore.", e);
                }
            }
            inputStream.close();
        }
        return keyStoreOptions;
    }

    protected static byte[] readStore(InputStream storeStream) throws IOException {
        int temp;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((temp = storeStream.read(buffer)) != -1) {
            bos.write(buffer, 0, temp);
        }
        return bos.toByteArray();
    }

    protected Future<AbstractMap.SimpleEntry<Long, AsyncFile>> openFileForRead(FileSystem fs, String filename) {
        Promise promise = Promise.promise();
        fs.exists(filename).compose(exists -> {
            if (!exists.booleanValue()) {
                String errMsg = "File '" + filename + "' does not exist";
                return Future.failedFuture((Throwable)new NoSuchFileException(errMsg));
            }
            return fs.props(filename);
        }).onSuccess(props -> fs.open(filename, new OpenOptions().setWrite(false).setCreate(false).setRead(true)).onFailure(arg_0 -> ((Promise)promise).tryFail(arg_0)).onSuccess(asyncFile -> promise.complete(new AbstractMap.SimpleEntry<Long, AsyncFile>(props.size(), (AsyncFile)asyncFile)))).onFailure(arg_0 -> ((Promise)promise).tryFail(arg_0));
        return promise.future();
    }
}

