/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.threaddump;

public class JvmThreadInfo {
    private final String name;
    private final boolean isJavaThread;
    private final boolean isDaemon;
    private final long nativeId;
    private final Thread.State javaThreadState;
    private final String extThreadState;
    private StackTraceElement[] javaStackTrace;

    public JvmThreadInfo(String name, boolean isDaemon, boolean isJavaThread, long nativeId, Thread.State javaThreadState, String extThreadState) {
        this.name = name;
        this.isJavaThread = isJavaThread;
        this.isDaemon = isDaemon;
        this.nativeId = nativeId;
        this.javaThreadState = javaThreadState;
        this.extThreadState = extThreadState;
    }

    public String getName() {
        return this.name;
    }

    public boolean isJavaThread() {
        return this.isJavaThread;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public long getNativeId() {
        return this.nativeId;
    }

    public Thread.State getJavaThreadState() {
        return this.javaThreadState;
    }

    public String getExtThreadState() {
        return this.extThreadState;
    }

    public StackTraceElement[] getJavaStackTrace() {
        return this.javaStackTrace;
    }

    public void setJavaStackTrace(StackTraceElement[] trace) {
        this.javaStackTrace = trace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(this.name);
        sb.append("\"");
        if (this.isDaemon) {
            sb.append(" daemon");
        }
        if (this.nativeId > 0L) {
            sb.append(" nid=0x").append(Long.toHexString(this.nativeId));
        }
        if (this.nativeId > 0L) {
            sb.append(" nid=0x").append(Long.toHexString(this.nativeId));
        }
        if (this.extThreadState != null) {
            sb.append(" ").append(this.extThreadState);
        }
        if (this.isJavaThread) {
            if (this.javaStackTrace != null && this.javaStackTrace.length > 0) {
                sb.append(" java stack (").append(this.javaStackTrace.length).append(")");
            } else {
                sb.append(" no java stack");
            }
        } else {
            sb.append(" non-java thread");
        }
        return sb.toString();
    }
}

