/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.retry;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.exception.RetriesExhaustedException;
import org.apache.cassandra.sidecar.client.retry.RetryAction;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.common.request.Request;

public class CreateRestoreJobRetryPolicy
extends RetryPolicy {
    private final RetryPolicy delegate;

    public CreateRestoreJobRetryPolicy(RetryPolicy delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
        if (response != null && (response.statusCode() == HttpResponseStatus.CONFLICT.code() || response.statusCode() == HttpResponseStatus.BAD_REQUEST.code())) {
            this.logger.error("Request exhausted. response={}, attempts={}", (Object)response, (Object)attempts);
            responseFuture.completeExceptionally(RetriesExhaustedException.of(attempts, request, response));
        } else {
            this.delegate.onResponse(responseFuture, request, response, throwable, attempts, canRetryOnADifferentHost, retryAction);
        }
    }
}

