/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cassandra.io.sstable.indexsummary;

import java.io.IOException;
import java.util.Map;

public interface IndexSummaryManagerMBean
{
    public long getMemoryPoolCapacityInMB();
    public void setMemoryPoolCapacityInMB(long memoryPoolCapacityInMB);

    /**
     * Returns the current actual off-heap memory usage of the index summaries for all non-compacting sstables.
     * @return The amount of memory used in MiB.
     */
    public double getMemoryPoolSizeInMB();

    /**
     * Returns a map of SSTable filenames to their current effective index interval.
     */
    public Map<String, Integer> getIndexIntervals();

    public double getAverageIndexInterval();

    public void redistributeSummaries() throws IOException;

    public int getResizeIntervalInMinutes();

    /**
     * Set resizeIntervalInMinutes = -1 for disabled; This is the equivalent of index_summary_resize_interval being
     * set to null in cassandra.yaml
     */
    public void setResizeIntervalInMinutes(int resizeIntervalInMinutes);
}
