/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.StressMetrics;
import org.apache.cassandra.stress.WorkManager;
import org.apache.cassandra.stress.operations.OpDistribution;
import org.apache.cassandra.stress.operations.OpDistributionFactory;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.transport.SimpleClient;

public class StressAction
implements Runnable {
    private final StressSettings settings;
    private final PrintStream output;

    public StressAction(StressSettings settings, PrintStream out) {
        this.settings = settings;
        this.output = out;
    }

    @Override
    public void run() {
        boolean success;
        this.settings.maybeCreateKeyspaces();
        if (this.settings.command.count == 0L) {
            this.output.println("N=0: SCHEMA CREATED, NOTHING ELSE DONE.");
            this.settings.disconnect();
            return;
        }
        this.output.println("Sleeping 2s...");
        Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        if (!this.settings.command.noWarmup) {
            this.warmup(this.settings.command.getFactory(this.settings));
        }
        if (this.settings.command.truncate == SettingsCommand.TruncateWhen.ONCE) {
            this.settings.command.truncateTables(this.settings);
        }
        RateLimiter rateLimiter = null;
        if (this.settings.rate.opRateTargetPerSecond > 0) {
            rateLimiter = RateLimiter.create((double)this.settings.rate.opRateTargetPerSecond);
        }
        if (this.settings.rate.minThreads > 0) {
            success = this.runMulti(this.settings.rate.auto, rateLimiter);
        } else {
            boolean bl = success = null != this.run(this.settings.command.getFactory(this.settings), this.settings.rate.threadCount, this.settings.command.count, this.settings.command.duration, rateLimiter, this.settings.command.durationUnits, this.output, false);
        }
        if (success) {
            this.output.println("END");
        } else {
            this.output.println("FAILURE");
        }
        this.settings.disconnect();
    }

    private void warmup(OpDistributionFactory operations) {
        PrintStream warmupOutput = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
        int iterations = (this.settings.command.count >= 0L ? Math.min(50000, (int)((double)this.settings.command.count * 0.25)) : 50000) * this.settings.node.nodes.size();
        if (iterations <= 0) {
            return;
        }
        int threads = 100;
        if (this.settings.rate.maxThreads > 0) {
            threads = Math.min(threads, this.settings.rate.maxThreads);
        }
        if (this.settings.rate.threadCount > 0) {
            threads = Math.min(threads, this.settings.rate.threadCount);
        }
        for (OpDistributionFactory single : operations.each()) {
            this.output.println(String.format("Warming up %s with %d iterations...", single.desc(), iterations));
            this.run(single, threads, iterations, 0L, null, null, warmupOutput, true);
        }
    }

    private boolean runMulti(boolean auto, RateLimiter rateLimiter) {
        if (this.settings.command.targetUncertainty >= 0.0) {
            this.output.println("WARNING: uncertainty mode (err<) results in uneven workload between thread runs, so should be used for high level analysis only");
        }
        int prevThreadCount = -1;
        int threadCount = this.settings.rate.minThreads;
        ArrayList<StressMetrics> results = new ArrayList<StressMetrics>();
        ArrayList<String> runIds = new ArrayList<String>();
        do {
            StressMetrics result;
            this.output.println(String.format("Running with %d threadCount", threadCount));
            if (this.settings.command.truncate == SettingsCommand.TruncateWhen.ALWAYS) {
                this.settings.command.truncateTables(this.settings);
            }
            if ((result = this.run(this.settings.command.getFactory(this.settings), threadCount, this.settings.command.count, this.settings.command.duration, rateLimiter, this.settings.command.durationUnits, this.output, false)) == null) {
                return false;
            }
            results.add(result);
            if (prevThreadCount > 0) {
                System.out.println(String.format("Improvement over %d threadCount: %.0f%%", prevThreadCount, 100.0 * this.averageImprovement(results, 1)));
            }
            runIds.add(threadCount + " threadCount");
            prevThreadCount = threadCount;
            threadCount = threadCount < 16 ? (threadCount *= 2) : (int)((double)threadCount * 1.5);
            if (!results.isEmpty() && threadCount > this.settings.rate.maxThreads) break;
            if (!this.settings.command.type.updates) continue;
            this.output.println("Sleeping for 15s");
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                return false;
            }
        } while (!auto || this.hasAverageImprovement(results, 3, 0.0) && this.hasAverageImprovement(results, 5, this.settings.command.targetUncertainty));
        StressMetrics.summarise(runIds, results, this.output, this.settings.samples.historyCount);
        return true;
    }

    private boolean hasAverageImprovement(List<StressMetrics> results, int count, double minImprovement) {
        return results.size() < count + 1 || this.averageImprovement(results, count) >= minImprovement;
    }

    private double averageImprovement(List<StressMetrics> results, int count) {
        double improvement = 0.0;
        for (int i = results.size() - count; i < results.size(); ++i) {
            double prev = results.get(i - 1).getTiming().getHistory().opRate();
            double cur = results.get(i).getTiming().getHistory().opRate();
            improvement += (cur - prev) / prev;
        }
        return improvement / (double)count;
    }

    private StressMetrics run(OpDistributionFactory operations, int threadCount, long opCount, long duration, RateLimiter rateLimiter, TimeUnit durationUnits, PrintStream output, boolean isWarmup) {
        int i;
        output.println(String.format("Running %s with %d threads %s", operations.desc(), threadCount, durationUnits != null ? duration + " " + durationUnits.toString().toLowerCase() : (opCount > 0L ? "for " + opCount + " iteration" : "until stderr of mean < " + this.settings.command.targetUncertainty)));
        WorkManager workManager = opCount < 0L ? new WorkManager.ContinuousWorkManager() : new WorkManager.FixedWorkManager(opCount);
        StressMetrics metrics = new StressMetrics(output, this.settings.log.intervalMillis, this.settings);
        CountDownLatch done = new CountDownLatch(threadCount);
        Consumer[] consumers = new Consumer[threadCount];
        int sampleCount = this.settings.samples.liveCount / threadCount;
        for (i = 0; i < threadCount; ++i) {
            consumers[i] = new Consumer(operations.get(metrics.getTiming(), sampleCount, isWarmup), done, workManager, metrics, rateLimiter);
        }
        for (i = 0; i < threadCount; ++i) {
            consumers[i].start();
        }
        metrics.start();
        if (durationUnits != null) {
            Uninterruptibles.sleepUninterruptibly((long)duration, (TimeUnit)durationUnits);
            workManager.stop();
        } else if (opCount <= 0L) {
            try {
                metrics.waitUntilConverges(this.settings.command.targetUncertainty, this.settings.command.minimumUncertaintyMeasurements, this.settings.command.maximumUncertaintyMeasurements);
            }
            catch (InterruptedException i2) {
                // empty catch block
            }
            workManager.stop();
        }
        try {
            done.await();
            metrics.stop();
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        if (metrics.wasCancelled()) {
            return null;
        }
        metrics.summarise();
        boolean success = true;
        for (Consumer consumer : consumers) {
            success &= consumer.success;
        }
        if (!success) {
            return null;
        }
        return metrics;
    }

    private class Consumer
    extends Thread {
        private final OpDistribution operations;
        private final StressMetrics metrics;
        private final RateLimiter rateLimiter;
        private volatile boolean success = true;
        private final WorkManager workManager;
        private final CountDownLatch done;

        public Consumer(OpDistribution operations, CountDownLatch done, WorkManager workManager, StressMetrics metrics, RateLimiter rateLimiter) {
            this.done = done;
            this.rateLimiter = rateLimiter;
            this.workManager = workManager;
            this.metrics = metrics;
            this.operations = operations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.operations.initTimers();
            try {
                Operation op;
                SimpleClient sclient = null;
                ThriftClient tclient = null;
                JavaDriverClient jclient = null;
                switch (((StressAction)StressAction.this).settings.mode.api) {
                    case JAVA_DRIVER_NATIVE: {
                        jclient = StressAction.this.settings.getJavaDriverClient();
                        break;
                    }
                    case SIMPLE_NATIVE: {
                        sclient = StressAction.this.settings.getSimpleNativeClient();
                        break;
                    }
                    case THRIFT: 
                    case THRIFT_SMART: {
                        tclient = StressAction.this.settings.getThriftClient();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                while ((op = this.operations.next()).ready(this.workManager, this.rateLimiter)) {
                    try {
                        switch (((StressAction)StressAction.this).settings.mode.api) {
                            case JAVA_DRIVER_NATIVE: {
                                op.run(jclient);
                                break;
                            }
                            case SIMPLE_NATIVE: {
                                op.run(sclient);
                                break;
                            }
                            default: {
                                op.run(tclient);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (StressAction.this.output == null) {
                            System.err.println(e.getMessage());
                            this.success = false;
                            System.exit(-1);
                        }
                        e.printStackTrace(StressAction.this.output);
                        this.success = false;
                        this.workManager.stop();
                        this.metrics.cancel();
                        this.done.countDown();
                        this.operations.closeTimers();
                        return;
                    }
                }
            }
            finally {
                this.done.countDown();
                this.operations.closeTimers();
            }
        }
    }
}

