/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidJMSThreadFactory
implements ThreadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(QpidJMSThreadFactory.class);
    private final Function<Thread, String> threadNamingStrategy;
    private final boolean daemon;
    private final AtomicReference<Thread> threadTracker;

    public QpidJMSThreadFactory(String threadName, boolean daemon) {
        this.threadNamingStrategy = t -> threadName;
        this.daemon = daemon;
        this.threadTracker = null;
    }

    public QpidJMSThreadFactory(String threadName, boolean daemon, AtomicReference<Thread> threadTracker) {
        this.threadNamingStrategy = t -> threadName;
        this.daemon = daemon;
        this.threadTracker = threadTracker;
    }

    public QpidJMSThreadFactory(Function<Thread, String> threadNamingStrategy, boolean daemon) {
        this.threadNamingStrategy = threadNamingStrategy;
        this.daemon = daemon;
        this.threadTracker = null;
    }

    @Override
    public Thread newThread(final Runnable target) {
        Runnable runner = target;
        if (this.threadTracker != null) {
            runner = new Runnable(){

                @Override
                public void run() {
                    QpidJMSThreadFactory.this.threadTracker.set(Thread.currentThread());
                    try {
                        target.run();
                    }
                    finally {
                        QpidJMSThreadFactory.this.threadTracker.set(null);
                    }
                }
            };
        }
        Thread thread = new Thread(runner);
        thread.setDaemon(this.daemon);
        thread.setName(this.threadNamingStrategy.apply(thread));
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread target, Throwable error) {
                LOG.warn("Thread: {} failed due to an uncaught exception: {}", (Object)target.getName(), (Object)error.getMessage());
                LOG.trace("Uncaught Stacktrace: ", error);
            }
        });
        return thread;
    }
}

