/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.plugin.ConfigurationProcessor;
import org.apache.activemq.plugin.DefaultConfigurationProcessor;
import org.apache.activemq.plugin.NetworkConnectorProcessor;
import org.apache.activemq.plugin.RuntimeConfigurationBroker;
import org.apache.activemq.schema.core.DtoNetworkConnector;

public class NetworkConnectorsProcessor
extends DefaultConfigurationProcessor {
    public NetworkConnectorsProcessor(RuntimeConfigurationBroker plugin, Class configurationClass) {
        super(plugin, configurationClass);
    }

    @Override
    public ConfigurationProcessor findProcessor(Object o) {
        if (o instanceof DtoNetworkConnector) {
            return new NetworkConnectorProcessor(this.plugin, o.getClass());
        }
        return super.findProcessor(o);
    }

    @Override
    protected void applyModifications(List<Object> current, List<Object> modification) {
        ConfigurationProcessor processor;
        for (Object currentObj : new ArrayList<Object>(current)) {
            if (modification.contains(currentObj)) continue;
            processor = this.findProcessor(currentObj);
            if (processor != null) {
                processor.remove(currentObj);
                continue;
            }
            this.remove(currentObj);
        }
        for (Object modObj : modification) {
            if (!current.contains(modObj)) {
                processor = this.findProcessor(modObj);
                if (processor != null) {
                    processor.addNew(modObj);
                    continue;
                }
                this.addNew(modObj);
                continue;
            }
            this.plugin.debug("Skipping unchanged network connector: " + String.valueOf(modObj));
        }
    }
}

