/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.shiro.authz.Permission;

public class SimpleRole
implements Serializable {
    protected String name;
    protected Set<Permission> permissions;

    public SimpleRole() {
    }

    public SimpleRole(String name) {
        this.setName(name);
    }

    public SimpleRole(String name, Set<Permission> permissions) {
        this.setName(name);
        this.setPermissions(permissions);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public void add(Permission permission) {
        Set<Permission> permissions = this.getPermissions();
        if (permissions == null) {
            permissions = new LinkedHashSet<Permission>();
            this.setPermissions(permissions);
        }
        permissions.add(permission);
    }

    public void addAll(Collection<Permission> perms) {
        if (perms != null && !perms.isEmpty()) {
            Set<Permission> permissions = this.getPermissions();
            if (permissions == null) {
                permissions = new LinkedHashSet<Permission>(perms.size());
                this.setPermissions(permissions);
            }
            permissions.addAll(perms);
        }
    }

    public boolean isPermitted(Permission p) {
        Set<Permission> perms = this.getPermissions();
        if (perms != null && !perms.isEmpty()) {
            for (Permission perm : perms) {
                if (!perm.implies(p)) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SimpleRole) {
            SimpleRole sr = (SimpleRole)o;
            return this.getName() != null ? this.getName().equals(sr.getName()) : sr.getName() == null;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

