
/*
   send.c - send data to Yaesu VX-1

   Copyright (c) 1997 Riku Kalinen, OH2LWO, oh2lwo@sral.fi

   RCS $Header: /home/mole/riku/CVS/yaesu/vx1send.c,v 1.2 1997/12/11 15:02:03 riku Exp $

   */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <stdlib.h>

#include "yaesu.h"

int debug = 0;

/* Write data to Yaesu. Wait every byte to be echoed. Wait ack when block
   finished if so instructed. */

static int yaesu_write (int fd_w, int fd_r, unsigned char *buf, size_t size,
		 int waitack)
{
  unsigned char retbuf[32];
  int ret, i, e;

  for (i = 0; i < size; i ++) {
    if (debug) { printf ("%d", i); fflush (stdout); }
    if ((i % 1024) == 0) { printf ("."); fflush (stdout); }
    ret = write (fd_w, buf + i, 1);
    if (ret != 1) {
      if (debug) {
	e = errno;
	printf (" Write error, ret=%d, errno=%d\n", ret, e);
      }
      return -1;
    }
    ret = read (fd_r, retbuf, 1);
    if (ret != 1) {
      if (debug) {
	e = errno;
	printf (" Read error (data), ret=%d, errno=%d\n", ret, e);
      }
      return -2;
    }
    if (retbuf[0] != buf[i]) {
      if (debug)
	printf (" Echoed character (%02x) does not match sent (%02x)\n",
		retbuf[0], buf[i]);
      return -3;
    }
    if (debug) { printf ("+"); fflush (stdout); }
  }

  if (! waitack)
    return size;

  ret = read (fd_r, retbuf, 1);
  if (ret != 1) {
    if (debug) {
      e = errno;
      printf (" Read error (ack), ret=%d, errno=%d\n", ret, e);
    }
    return -4;
  }
  if (retbuf[0] != 0x21) {
    if (debug) 
      printf (" Ack character (%02x) is not 0x21\n", retbuf[0]);
    return -5;
  }

  return size;

}

int main (int argc, char *argv[])
{
  int fd, fd_read, fd_write, ret, c;
  unsigned char b1[4818];
  unsigned char cksum, cksum2;
  char str[4096];

  while ((c = getopt (argc, argv, "d")) != -1)
    switch (c) {
    case 'd': debug ++; break;
    case '?': printf ("Usage: send [-d] <device> <infile>\n"); exit (1); break;
    }
 
  if ((argc - optind) != 2) {
    printf ("Usage: send [-d] <device> <infile>\n");
    exit (1);
  }

  fd = open (argv[optind + 1], O_RDONLY);
  if (fd < 0) {
    perror (argv[optind + 1]);
    exit (1);
  }

  ret = read_vx1_save_file (fd, b1, sizeof b1);
  if (ret != 0) {
    perror ("read_save_file");
    exit (1);
  }

  close (fd);

  cksum = calculate_vx1_cksum (b1, sizeof b1 - 1);
  cksum2 = calculate_vx1_cksum_2 (b1, 0xa0);
  if ((cksum != b1[sizeof b1 - 1]) || (cksum2 != b1[0xa0])) {
    printf ("Checksum failed, send aborted.\n");
    printf ("Calculated checksums = %02x, %02x; checksums form file = %02x, %02x .\n",
	    cksum, cksum2, b1[sizeof b1 - 1], b1[0xa0]);
    exit (1);
  }

  fd_read = open (argv[optind], O_RDONLY);
  if (fd_read < 0) {
    perror (argv[optind]);
    exit (1);
  }
  fd_write = open (argv[optind], O_WRONLY);
  if (fd_write < 0) {
    perror (argv[optind]);
    exit (1);
  }

  ret = tcflush (fd_write, TCIOFLUSH);
  if (ret != 0) {
    perror ("tcflush fd_write");
    printf ("ret=%d\n", ret);
  }
  ret = tcflush (fd_read, TCIOFLUSH);
  if (ret != 0) {
    perror ("tcflush fd_read");
    printf ("ret=%d\n", ret);
  }

  sprintf (str, "stty 9600 -parenb cs8 -hupcl -cstopb cread clocal -crtscts ignbrk -brkint ignpar -parmrk -inpck -istrip -inlcr -igncr -icrnl -ixon -ixoff -iuclc -ixany -imaxbel -opost -olcuc -ocrnl -onlcr -onocr -onlret -ofill -ofdel nl0 cr0 tab0 bs0 vt0 ff0 -isig -icanon -iexten -echo -echoe -echok -echonl -noflsh -xcase -tostop -echoprt -echoctl -echoke min 1 time 0 < %s > %s", argv[optind], argv[optind]);
  system (str);
  
  printf ("Ensure that radio is in CLONE mode and UP is pressed.\n\n");

  printf ("Sending %d bytes", sizeof (b1)); fflush (stdout);
  if ((ret = yaesu_write (fd_write, fd_read, b1, sizeof (b1), 1))
      != sizeof (b1)) {
    perror ("yaesu_write b1");
    printf ("yaesu_write returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  close (fd_read);
  close (fd_write);

  exit (0);

}
