/*
 * aorwrite.c very simple program to communicate with AOR-AR8200
 * By Kari Karvoenen <karika@kaustinen.fi> 29.8.1999
 */
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>

#define AORPORT "/dev/ttyS0"	/* /dev/ttyS0 for COM1 /dev/ttyS1 for COM2 */
#define AORSPEED B9600		/* Baudrate. B9600 or B19200 */

int open_port(void)
{
    int fd;
    fd = open(AORPORT, O_RDWR | O_NOCTTY);

    if (fd == -1) {
        fprintf(stderr, "open_port: Unable to %s - %s\n",
                AORPORT, strerror(errno));
    }
    return (fd);
}

int configure_port(int mainfd)
{
    /* Set AOR-AR8200 communication options (9600,N,8,2 Xon/Xoff by default) */
    struct termios options;
    tcgetattr(mainfd, &options);    	  /* Get the current options for the port */
    cfsetispeed(&options, AORSPEED);      /* Set input speed (to 9600) */
    cfsetospeed(&options, AORSPEED);	  /* Set output speed (to 9600) */
    options.c_cflag |= (CLOCAL | CREAD);  /* Enable the receiver and set local mode */
    options.c_cflag &= ~PARENB;  	  /* Mask the character size to 8 bits, no parity */
    options.c_cflag |= CSTOPB;   	  /* set 2 stop bits */
    options.c_cflag &= ~CSIZE;   	  /* disable Bit mask for data bits */
    options.c_cflag |=  CS8;     	  /* and select 8 data bits */
    options.c_cflag &= ~CRTSCTS; 	  /* Disable hardware flow control */
    options.c_lflag &= ~(ICANON | ECHO | ISIG); /* Enable data to be processed as raw input */
    options.c_iflag |= (IXON);      	  /* Enable Xon/Xoff software handshaking */
    tcflush(mainfd,TCIFLUSH);             /* Flush serial port */
    tcsetattr(mainfd, TCSANOW, &options); /* Set the new options for the port */
    return 0;
}

int write_aor(int mainfd, char *command)
{
    int tmp;
    tmp=write(mainfd,command,strlen(command)); /* Write to AOR */
    if (tmp!=strlen(command)) return(1);
    return 0;
}

int read_aor(int mainfd, char *response)
{
    int tmp=0;
    usleep(100000); /* Give scanner some time to transfer data */
    fcntl(mainfd, F_SETFL, FNDELAY);
    tmp=read(mainfd, response, 63); /* Read from AOR */
    response[tmp]='\0';
    return tmp;
}

int main(int argc, char *argv[])
{
 
    char response[200];			/* Received reply  */
    char command[200];  		/* Command to send */
    int  mainfd=0;      		/* File descriptor */
    int  tmp;				/* Multipurpose integer variable */

    if (argc<2 || argc>2) { printf ("Usage: %s <command>\n",argv[0]);
    				return 1; }

    sprintf (command,"%s\n",argv[1]);	
    mainfd = open_port();		/* Open serial port */
    tmp = configure_port(mainfd);	/* Configure port */

    tmp=write_aor(mainfd, command);	/* Write command to radio */
    if (tmp==1) {			/* Was write successfull? */
      printf ("ERROR: AOR write failed\n");
      return 1;
    }

    tmp=read_aor(mainfd,response);	/* Read reply from radio */
    if (tmp<1)				/* Was read succesfull? */ 
      printf ("WARNING: No reply from AOR!\n");
    else printf ("%s",response);

    close(mainfd);			/* Close serial port */
    return 0;
}
