#include "sun.h"

char sunrise[8],sunset[8];

/* in Sunrisetimes wird der Algorithmus nach ON4UN verwendet */
/* wird im Moment nicht mehr benutzt. Fuer SH/SUN werden auch */
/* die Zeiten des GRAYLINE-Algorithmus hergenommen */
Sun sunrisetimes(double x,double y)
{

	/* 
	   day:   1...31
	   month: 1...12

	   x:     -90...90     Breite N positiv
	   y:    -180...180    Laenge E positiv
	*/

	static double sw = -0.97599592;
	static double cw =  0.21778881;
	static double se =  0.39777961;
	static double ce =  0.9174811;
	static double k1 = -0.014834754;

	double c1,c2,c3,c4,c5,c6,b1,b2,b3,b4,b5,m,l,lo,la;
	Sun sun_time;

   	time_t t;
	struct tm now;

        /* printf("x=%8.2f, y=%8.2f\n",x,y); */

	lo = ((double)(-y)) *M_PI/180; 	   /* stliche Lngen positiv */
	la = ((double)(x)) *M_PI/180;      /* nrdliche Breiten positiv */

	time(&t);
   
	now = *gmtime(&t);

         m = (2 * M_PI* ((double) now.tm_yday) +lo)/365.24219-0.052708; 
	 l = m-1.351248;
	c1 = 1-0.03343*cos(m);
	c2 = 0.99944*sin(m)/c1;
	c3 = (cos(m)-0.03343)/c1;
	c4 = sw * c3 + cw * c2;
	c5 = cw * c3 - sw * c2;
	c6 = se * c4;

	b1 = k1 - c6 *sin(la);
	b2 = (cos(la) * cos(la)) * (1 - c6*c6) - b1*b1;

	if (b2>0) {
		b3= atan(b1/sqrt(b2)) - M_PI_2;
		b4= atan((cos(l)*ce*c4-sin(l)*c5)/(sin(l)*ce*c4+cos(l)*c5));
		b5= b4 + b3 + lo + M_PI;
		if (b5<0)
			b5+=2*M_PI;
		b5= floor(b5*720/M_PI+0.5);
		if (b5>1439)
			b5-=1440;
		sun_time.rise=(int) b5;

		b3=-b3;
		b5= b4 + b3 + lo + M_PI;
		if (b5<0)
			b5+=2*M_PI;
		b5= floor(b5*720/M_PI+0.5);
		if (b5>1439)
			b5-=1440;
		sun_time.set=(int) b5;
	}
	else {
		sun_time.rise=0;
		if (b1>0)
			sun_time.set=0;	/* Polarnacht */
		else
			sun_time.set=1440;	/* Polartag */
	}


	return (sun_time);
}


Grayline graylinetimes(double gb,double gl)
{
/*    Grundlage fr die Berechnung der Dmmerungszeiten ist der Algorithmus aus dem Buch
      "Sterne und Computer"
      
      Es existieren 5 verschiedene Flle bei der Grayline-Berechnung. Der jeweils zutreffende
      Fall wird in der Variablen gcase mit in der Struktur grayline_times von der Funktion
      zurckgegeben.
      Fall 1: Es existieren alle Auf-/Untergangs- und Dmmerungszeiten (Normalfall)
      Fall 2: Polartag ohne Dmmerungsphase
      Fall 3: Polartag mit Dmmerungsphase. Die Dmmerung herrscht zwischen Sonnenunter- und 
              Sonnenaufgang. Mitternacht ist die Grenze zwischen Abend- und Morgendmmerung.
      Fall 4: Polarnacht ohne Dmmerungsphase
      Fall 5: Polarnacht mit Dmmerungsphase
   
      day:   1...31
      month: 1...12

      gb:     -90...90     Breite N positiv
      gl:    -180...180    Laenge E positiv
*/

   static double c0 = 0.0174532926;
   static double c1 = 3.81971862;
   int i;
      
   double a,b,bs,ct,de,dx,ep,g,jd,l,l1,ls;
   double x,y,z,zg;
   double aa[5],bb[5],ti[5],u[5],v[5],zz[5];
   double jj,m,t;
   double jr,mm,tt;		/* Jahr/Monat/Tag */

   Grayline grayline_time;
   time_t tim;
   struct tm now;

   /* printf("gb=%8.2f, gl=%8.2f\n",gb,gl); */

   /* Umwandlung der geographischen Koordinaten */
   gb=c0*gb;	/* nrdliche Breiten positiv */

   gl=-1.0*gl; 	/* Bei der Berechnung westliche Lngen positiv */


   /* Ermittlung von Tag/Monat/Jahr */
   time(&tim);
   now = *gmtime(&tim);
   jr=(double) (now.tm_year+1900); /* Y2K? */
   mm=(double) now.tm_mon+1;
   tt=(double) now.tm_mday;

   /* printf("jr=%8.2f, mm=%8.2f, tt=%8.2f\n",jr,mm,tt); */
   
   /* Zeitzonenkorrektur */
   /* hier nicht notwendig, da Zeit immer UTC ist */
   /*   if (gl>-7.5)
      l1=( (int)((gl+7.5)/15))*15.0;
   else
      l1=-1.0 * ( (int)(-1.0*(gl-7.5)/15))*15.0;
   */
   l1=0;

   /* Julianisches Datum berechnen */
   jj=jr;
   m=mm;
   if (m<3)
   {
      m+=12;
      jj--;
   }
   a=(int)(jj/100.0);
   b=2.0-a+(int)(a/4.0);
   jd=((int)(365.25*jj)) + ((int)(30.6001*(m+1))) + tt + b + 1720994.5;
   
   jd=jd+0.5+l1/360.0;
   /* printf("a=%10.2f, b=%10.2f, jd = %10.2f\n",a,b,jd); */
   t=jd-2451545.0;
   
   /* Genaeherte Sonnenkoordianten */
   l=280.46+0.9856474*t;
   g=357.528+0.9856003*t;
   g=c0*g;
   ls=l+1.915*sin(g)+0.02*sin(2*g);
   bs=0.0;
   ls=ls-((int)(ls/360.0))*360.0;
   
   l=c0*ls;
   b=c0*bs;
   
   /* Zeitgleichung */
   zg= -105.1*sin(l) + 596.2*sin(2*l) + 4.3*sin(3*l) - 12.7*sin(4*l);
   zg= zg - 429.2*cos(l) - 2.1*cos(2*l) + 19.3*cos(3*l);
   zg= zg/3600.0;
   
   t=(jd-2415020.0)/36525.0;
   
   /* Koordinatentransformation */
   ep=23.452-0.01301*t-1.6E-6*t*t+0.0000005*t*t*t;
   ep=c0*ep;
   x=cos(b)*cos(l);
   y=cos(b)*sin(l)*cos(ep)-sin(b)*sin(ep);
   z=cos(b)*sin(l)*sin(ep)+sin(b)*cos(ep);
   de=atan(z/sqrt(x*x+y*y));

   /*
   printf("x=%8.6f, y=%8.6f, z=%8.6f\n",x,y,z);
   printf("de=%8.6f\n",de);
   */
   
   dx=-zg+(gl-l1)/15.0;

   zz[1]=90.833;
   zz[2]=96.0;
   zz[3]=102.0;
   zz[4]=108.0;	
   aa[1]=aa[2]=aa[3]=aa[4]=u[1]=u[2]=u[3]=u[4]=0.0;
   for (i=1;i<=4;i++)
   {
      z=zz[i]*c0;
      if (z>(180.0*c0-de-gb))
      {
         t=0;
      }
      else
      {
      	ct=(cos(z)-sin(gb)*sin(de))/(cos(gb)*cos(de));
         t=1.57079633-atan(ct/sqrt(1-ct*ct));
         t=c1*t;
      }
      ti[i]=t;
      if (ti[i]!=0)
      {
      	aa[i]=12-ti[i]+dx;
         u[i]=12+ti[i]+dx;
      }
      /* Zeitkorrektur bei Datumswechsel */
      if (aa[i]<0)	aa[i]=aa[i]+24.0;
      if (aa[i]>=24)	aa[i]=aa[i]-24.0;
      if (u[i]<0)	u[i]=u[i]+24.0;
      if (u[i]>=24)	u[i]=u[i]-24.0;
      
      bb[i] = (int)((aa[i]-((int) aa[i]))*60.0 + 0.5);
       v[i] = (int)((u[i]-((int) u[i])) *60.0 + 0.5);
      aa[i] = (int) aa[i];
       u[i] = (int) u[i];
      if (bb[i]<0) bb[i]=-1;
      if (v[i]<0) v[i]=-1;
      if (aa[i]<0) aa[i]=-1;
      if (u[i]<0) u[i]=-1;
   }

/*
   printf("Astronomische Dmmerung: %2.0f:%02.0f Uhr\n",aa[4],bb[4]);
   printf("Nautische  Dmmerung:    %2.0f:%02.0f Uhr\n",aa[3],bb[3]);
   printf("Buergerliche Dmmerung:  %2.0f:%02.0f Uhr\n",aa[2],bb[2]);
   printf("Sonnenaufgang:           %2.0f:%02.0f Uhr\n",aa[1],bb[1]);
   printf("Sonnenuntergang:         %2.0f:%02.0f Uhr\n",u[1],v[1]);
   printf("Buergerliche Dmmerung:  %2.0f:%02.0f Uhr\n",u[2],v[2]);
   printf("Nautische Dmmerung:     %2.0f:%02.0f Uhr\n",u[3],v[3]);
   printf("Astronomische Dmmerung: %2.0f:%02.0f Uhr\n",u[4],v[4]);
*/

   
   grayline_time.dawn=(int) ((aa[2])*60.0+bb[2]);
   grayline_time.rise=(int) ((aa[1])*60.0+bb[1]);
   grayline_time.set=(int) ((u[1])*60.0+v[1]);
   grayline_time.dusk=(int) ((u[2])*60.0+v[2]);
   if (grayline_time.dawn==0 && grayline_time.dusk==0 && grayline_time.rise==0 && grayline_time.set==0)
   {
      /* Polartag ohne Dmmerung */
      grayline_time.dawn=-1;
      grayline_time.dusk=-1;
      grayline_time.rise=0;
      grayline_time.set=1440;
      grayline_time.gcase=2;
   }
   else if (grayline_time.dawn==0 && grayline_time.dusk==0)
   {
      /* Polartag mit Dmmerung */
      if (grayline_time.set>grayline_time.rise)
      {
      	grayline_time.dawn=(grayline_time.set+grayline_time.rise)/2.0+12*60;
         if (grayline_time.dawn>1440)
         {
         	grayline_time.dawn=grayline_time.dawn-1440;
         }
      }
      else
      {
      	grayline_time.dawn=(grayline_time.set+grayline_time.rise)/2.0;
      }
      grayline_time.dawn= (int) grayline_time.dawn;
      grayline_time.dusk= grayline_time.dawn;
      grayline_time.gcase=3;
   }
   else if (grayline_time.dawn<0 && grayline_time.dusk<0 && grayline_time.rise<0 && grayline_time.set<0)
   {
      /* Polarnacht ohne Dmmerung */
      grayline_time.dawn=-1;
      grayline_time.dusk=-1;
      grayline_time.rise=-1;
      grayline_time.set=-1;
      grayline_time.gcase=4;
   }
   else if (grayline_time.rise<0 && grayline_time.set<0)
   {
      /* Polarnacht mit Dmmerung */
      grayline_time.rise=-1;
      grayline_time.set=-1;
      grayline_time.gcase=5;
   }      
   else
   {
      /* Normalfall mit Morgendmnmerung, Sonnenaufgang, Sonnenuntergang und Abenddmmerung */
      grayline_time.gcase=1;
   }
	return (grayline_time);
}

/*
char *min2tim(int time)
{
        int hours, mins, dayoffset;
        static char buffer[40];

	dayoffset=0;

	printf("min2tim: time = %d\n",time);
	while (time >= 1440) {
		dayoffset++;
		time = time - 1440;
	}

	while (time <= 0) {
		dayoffset--;
		time = time + 1440;
	}

        hours=time/60;
        mins=time-hours*60;
	if ( dayoffset == 0) {
        	sprintf(buffer,"%02d:%02d",hours,mins);
	} else {
        	sprintf(buffer,"%02d:%02d%+2d",hours,mins,dayoffset);
	} 
	printf("min2tim: buffer = %s\n",buffer);

        return(buffer);
}

*/
