/* Miscellaneous machine independent utilities */

#include <ctype.h>
#include <string.h>
#include "global.h"

/* Convert hex-ascii to integer */
int
htoi(s)
char *s;
{
	int i = 0;
	char c;

	while((c = *s++) != '\0'){
		if(c == 'x')
			continue;	/* allow 0x notation */
		if('0' <= c && c <= '9')
			i = (i * 16) + (c - '0');
		else if('a' <= c && c <= 'f')
			i = (i * 16) + (c - 'a' + 10);
		else if('A' <= c && c <= 'F')
			i = (i * 16) + (c - 'A' + 10);
		else
			break;
	}
	return i;
}
/* replace terminating end of line marker(s) with null */
rip(s)
register char *s;
{
	register char *cp;

	if((cp = strchr(s,'\r')) != NULLCHAR)
		*cp = '\0';
	if((cp = strchr(s,'\n')) != NULLCHAR)
		*cp = '\0';
}
