/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.regex.runtime.nodes.ToCharNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToCharNode.class)
public final class ToCharNodeGen
extends ToCharNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private Long0Data long0_cache;

    private ToCharNodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop
    public char execute(Object arg0Value) throws UnsupportedTypeException {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return ToCharNode.doByte(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return ToCharNode.doChar(arg0Value_);
        }
        if ((state & 0xC) != 0) {
            if ((state & 4) != 0) {
                Long0Data s3_ = this.long0_cache;
                while (s3_ != null) {
                    if (s3_.args_.accepts(arg0Value) && s3_.args_.fitsInInt(arg0Value)) {
                        return ToCharNode.doLong(arg0Value, s3_.args_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0) {
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).fitsInInt(arg0Value)) {
                        char c = ToCharNode.doLong(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                        return c;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char executeAndSpecialize(Object arg0Value) throws UnsupportedTypeException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                char c = ToCharNode.doByte(arg0Value_);
                return c;
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = ((Character)arg0Value).charValue();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                char c = ToCharNode.doChar(arg0Value_);
                return c;
            }
            if (exclude == 0) {
                InteropLibrary args__;
                int count3_ = 0;
                Long0Data s3_ = this.long0_cache;
                if ((state & 4) != 0) {
                    while (!(s3_ == null || s3_.args_.accepts(arg0Value) && s3_.args_.fitsInInt(arg0Value))) {
                        s3_ = s3_.next_;
                        ++count3_;
                    }
                }
                if (s3_ == null && (args__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg0Value))).fitsInInt(arg0Value) && count3_ < 2) {
                    s3_ = (Long0Data)super.insert((Node)new Long0Data(this.long0_cache));
                    s3_.args_ = s3_.insertAccessor(args__);
                    this.long0_cache = s3_;
                    this.state_ = state |= 4;
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    char c = ToCharNode.doLong(arg0Value, s3_.args_);
                    return c;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                InteropLibrary long1_args__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                if (long1_args__.fitsInInt(arg0Value)) {
                    this.exclude_ = exclude |= 1;
                    this.long0_cache = null;
                    state &= 0xFFFFFFFB;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    char c = ToCharNode.doLong(arg0Value, long1_args__);
                    return c;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        Long0Data s3_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s3_ = this.long0_cache) == null || s3_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToCharNode create() {
        return new ToCharNodeGen();
    }

    public static ToCharNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ToCharNode.class)
    private static final class Uncached
    extends ToCharNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public char execute(Object arg0Value) throws UnsupportedTypeException {
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                return ToCharNode.doByte(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = ((Character)arg0Value).charValue();
                return ToCharNode.doChar(arg0Value_);
            }
            if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).fitsInInt(arg0Value)) {
                return ToCharNode.doLong(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=ToCharNode.class)
    private static final class Long0Data
    extends Node {
        @Node.Child
        Long0Data next_;
        @Node.Child
        InteropLibrary args_;

        Long0Data(Long0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

