/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.classworlds.ClassWorldListener;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class ClassWorld {
    private Map realms;
    private final List listeners = new ArrayList();

    public ClassWorld(String realmId, ClassLoader classLoader) {
        this();
        try {
            this.newRealm(realmId, classLoader);
        }
        catch (DuplicateRealmException duplicateRealmException) {
            // empty catch block
        }
    }

    public ClassWorld() {
        this.realms = new LinkedHashMap();
    }

    public ClassRealm newRealm(String id) throws DuplicateRealmException {
        return this.newRealm(id, this.getClass().getClassLoader());
    }

    public synchronized ClassRealm newRealm(String id, ClassLoader classLoader) throws DuplicateRealmException {
        if (this.realms.containsKey(id)) {
            throw new DuplicateRealmException(this, id);
        }
        ClassRealm realm = new ClassRealm(this, id, classLoader);
        this.realms.put(id, realm);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ClassWorldListener listener = (ClassWorldListener)this.listeners.get(i);
            listener.realmCreated(realm);
        }
        return realm;
    }

    public synchronized void disposeRealm(String id) throws NoSuchRealmException {
        ClassRealm realm = (ClassRealm)this.realms.remove(id);
        if (realm != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ClassWorldListener listener = (ClassWorldListener)this.listeners.get(i);
                listener.realmDisposed(realm);
            }
        }
    }

    public synchronized ClassRealm getRealm(String id) throws NoSuchRealmException {
        if (this.realms.containsKey(id)) {
            return (ClassRealm)this.realms.get(id);
        }
        throw new NoSuchRealmException(this, id);
    }

    public synchronized Collection getRealms() {
        return Collections.unmodifiableList(new ArrayList(this.realms.values()));
    }

    public synchronized ClassRealm getClassRealm(String id) {
        if (this.realms.containsKey(id)) {
            return (ClassRealm)this.realms.get(id);
        }
        return null;
    }

    public synchronized void addListener(ClassWorldListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeListener(ClassWorldListener listener) {
        this.listeners.remove(listener);
    }
}

