/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser;

import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BlockParser;
import org.apache.maven.doxia.module.confluence.parser.DefinitionListBlock;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class DefinitionListBlockParser
implements BlockParser {
    static final String LS = System.getProperty("line.separator");

    @Override
    public boolean accept(String line, ByLineSource source) {
        return line.startsWith("{note") || line.startsWith("{tip") || line.startsWith("{info") || line.startsWith("{quote");
    }

    @Override
    public Block visit(String line, ByLineSource source) throws ParseException {
        StringBuilder text = new StringBuilder();
        StringBuilder title = new StringBuilder();
        int index = line.indexOf("title=");
        if (index >= 0) {
            line = line.substring(index + 6);
            while (!line.contains("}") && line != null) {
                this.append(title, line);
                line = source.getNextLine();
            }
            if (line != null) {
                this.append(title, line.substring(0, line.indexOf("}")));
            }
        }
        while (!((line = source.getNextLine()) == null || line.startsWith("{note") || line.startsWith("{tip") || line.startsWith("{info") || line.startsWith("{quote"))) {
            this.append(text, line);
        }
        return new DefinitionListBlock(title.toString(), text.toString());
    }

    private void append(StringBuilder title, String line) {
        if (title.length() > 0) {
            title.append(" ");
        }
        title.append(line.trim());
    }
}

