/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java.adapter;

import com.oracle.truffle.js.runtime.java.adapter.JavaAdapterServices;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import org.graalvm.polyglot.Value;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.TraceClassVisitor;

final class JavaAdapterClassLoader {
    static final ProtectionDomain GENERATED_PROTECTION_DOMAIN = JavaAdapterClassLoader.createGeneratedProtectionDomain();
    static final Collection<String> VISIBLE_INTERNAL_CLASS_NAMES = Collections.unmodifiableCollection(new HashSet<String>(Arrays.asList(JavaAdapterServices.class.getName(), Value.class.getName())));
    private final String className;
    private final byte[] classBytes;

    JavaAdapterClassLoader(String className, byte[] classBytes) {
        this.className = className.replace('/', '.');
        this.classBytes = classBytes;
    }

    Class<?> generateClass(ClassLoader parentLoader, Value classOverrides) {
        try {
            return Class.forName(this.className, true, this.createClassLoader(parentLoader, classOverrides));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private ClassLoader createClassLoader(final ClassLoader parentLoader, final Value classOverrides) {
        final class CLImpl
        extends SecureClassLoader
        implements Supplier<Value> {
            private static final boolean PRINT_CODE = false;
            private final ClassLoader myLoader;

            CLImpl() {
                super(classLoader);
                this.myLoader = this.getClass().getClassLoader();
            }

            @Override
            public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                try {
                    return super.loadClass(name, resolve);
                }
                catch (SecurityException se) {
                    if (VISIBLE_INTERNAL_CLASS_NAMES.contains(name)) {
                        return this.loadInternalClass(name);
                    }
                    throw se;
                }
            }

            private Class<?> loadInternalClass(String name) throws ClassNotFoundException {
                return this.myLoader != null ? this.myLoader.loadClass(name) : Class.forName(name, false, this.myLoader);
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.equals(JavaAdapterClassLoader.this.className)) {
                    return this.defineClass(name, JavaAdapterClassLoader.this.classBytes, 0, JavaAdapterClassLoader.this.classBytes.length, GENERATED_PROTECTION_DOMAIN);
                }
                if (VISIBLE_INTERNAL_CLASS_NAMES.contains(name)) {
                    return this.loadInternalClass(name);
                }
                throw new ClassNotFoundException(name);
            }

            private void printCode(byte[] bytecode) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (PrintWriter pw = new PrintWriter(baos);){
                    new ClassReader(bytecode).accept((ClassVisitor)new TraceClassVisitor(pw), 0);
                }
                System.out.println(new String(baos.toByteArray()));
            }

            @Override
            public Value get() {
                return classOverrides;
            }
        }
        return new CLImpl();
    }

    private static ProtectionDomain createGeneratedProtectionDomain() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return new ProtectionDomain(new CodeSource(null, (CodeSigner[])null), permissions);
    }

    static Value getClassOverrides(ClassLoader classLoader) {
        return (Value)((Supplier)((Object)classLoader)).get();
    }
}

