/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.options;

import com.vladsch.flexmark.util.collection.DataValueFactory;
import com.vladsch.flexmark.util.options.DataHolder;

public class DataKey<T> {
    private final String name;
    private final DataValueFactory<T> factory;
    private final T defaultValue;

    public DataKey(String name, DataValueFactory<T> factory) {
        this.name = name;
        this.defaultValue = factory.create(null);
        this.factory = factory;
    }

    private DataKey(String name, DataKey<? extends T> defaultKey) {
        this(name, new DataValueFactory<T>(){

            @Override
            public T create(DataHolder value) {
                return DataKey.this.getFrom(value);
            }
        });
    }

    public DataKey(String name, final T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.factory = new DataValueFactory<T>(){

            @Override
            public T create(DataHolder options) {
                return defaultValue;
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public DataValueFactory<T> getFactory() {
        return this.factory;
    }

    public T getDefaultValue(DataHolder holder) {
        return this.defaultValue;
    }

    public T getValue(Object value) {
        return (T)value;
    }

    public T getFrom(DataHolder holder) {
        return holder == null ? this.defaultValue : holder.get(this);
    }

    public String toString() {
        if (this.defaultValue != null) {
            return "DataKey<" + this.defaultValue.getClass().getName().substring(this.defaultValue.getClass().getPackage().getName().length() + 1) + "> " + this.name;
        }
        Object defaultValue = this.factory.create(null);
        if (defaultValue != null) {
            return "DataKey<" + defaultValue.getClass().getName().substring(defaultValue.getClass().getPackage().getName().length() + 1) + "> " + this.name;
        }
        return "DataKey<unknown> " + this.name;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.factory.hashCode();
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        return result;
    }
}

