/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldSetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Accessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PrivateFieldSetNode.class)
public final class PrivateFieldSetNodeGen
extends PrivateFieldSetNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile errorBranch;
    @Node.Child
    private HasHiddenKeyCacheNode fieldCachedKey_hasNode_;
    @Node.Child
    private PropertySetNode fieldCachedKey_setNode_;
    @Node.Child
    private JSFunctionCallNode accessor_callNode_;

    private PrivateFieldSetNodeGen(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        super(targetNode, keyNode, valueNode, context);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object targetNodeValue) {
        int state = this.state_;
        Object keyNodeValue_ = this.keyNode.execute(frameValue);
        Object valueNodeValue_ = this.valueNode.execute(frameValue);
        if (state != 0) {
            if ((state & 7) != 0 && JSTypes.isDynamicObject(targetNodeValue)) {
                Object keyNodeValue__;
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if ((state & 3) != 0 && keyNodeValue_ instanceof HiddenKey) {
                    keyNodeValue__ = (HiddenKey)keyNodeValue_;
                    if ((state & 1) != 0 && JSGuards.isJSObject(targetNodeValue_) && keyNodeValue__ == this.fieldCachedKey_hasNode_.getKey()) {
                        return this.doFieldCachedKey(targetNodeValue_, (HiddenKey)keyNodeValue__, valueNodeValue_, this.fieldCachedKey_hasNode_, this.fieldCachedKey_setNode_, this.errorBranch);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSObject(targetNodeValue_)) {
                        return this.doFieldUncachedKey(targetNodeValue_, (HiddenKey)keyNodeValue__, valueNodeValue_, this.errorBranch);
                    }
                }
                if ((state & 4) != 0 && keyNodeValue_ instanceof Accessor) {
                    keyNodeValue__ = (Accessor)keyNodeValue_;
                    if (JSGuards.isJSObject(targetNodeValue_)) {
                        return this.doAccessor(targetNodeValue_, (Accessor)keyNodeValue__, valueNodeValue_, this.accessor_callNode_, this.errorBranch);
                    }
                }
            }
            if ((state & 8) != 0 && PrivateFieldSetNodeGen.fallbackGuard_(targetNodeValue, keyNodeValue_, valueNodeValue_)) {
                return this.missing(targetNodeValue, keyNodeValue_, valueNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, keyNodeValue_, valueNodeValue_);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        Object keyNodeValue_ = this.keyNode.execute(frameValue);
        Object valueNodeValue_ = this.valueNode.execute(frameValue);
        if (state != 0) {
            if ((state & 7) != 0 && JSTypes.isDynamicObject(targetNodeValue_)) {
                Object keyNodeValue__;
                DynamicObject targetNodeValue__ = (DynamicObject)targetNodeValue_;
                if ((state & 3) != 0 && keyNodeValue_ instanceof HiddenKey) {
                    keyNodeValue__ = (HiddenKey)keyNodeValue_;
                    if ((state & 1) != 0 && JSGuards.isJSObject(targetNodeValue__) && keyNodeValue__ == this.fieldCachedKey_hasNode_.getKey()) {
                        return this.doFieldCachedKey(targetNodeValue__, (HiddenKey)keyNodeValue__, valueNodeValue_, this.fieldCachedKey_hasNode_, this.fieldCachedKey_setNode_, this.errorBranch);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSObject(targetNodeValue__)) {
                        return this.doFieldUncachedKey(targetNodeValue__, (HiddenKey)keyNodeValue__, valueNodeValue_, this.errorBranch);
                    }
                }
                if ((state & 4) != 0 && keyNodeValue_ instanceof Accessor) {
                    keyNodeValue__ = (Accessor)keyNodeValue_;
                    if (JSGuards.isJSObject(targetNodeValue__)) {
                        return this.doAccessor(targetNodeValue__, (Accessor)keyNodeValue__, valueNodeValue_, this.accessor_callNode_, this.errorBranch);
                    }
                }
            }
            if ((state & 8) != 0 && PrivateFieldSetNodeGen.fallbackGuard_(targetNodeValue_, keyNodeValue_, valueNodeValue_)) {
                return this.missing(targetNodeValue_, keyNodeValue_, valueNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue_, keyNodeValue_, valueNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object targetNodeValue, Object keyNodeValue, Object valueNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                Object keyNodeValue_;
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (keyNodeValue instanceof HiddenKey) {
                    keyNodeValue_ = (HiddenKey)keyNodeValue;
                    if (exclude == 0) {
                        HasHiddenKeyCacheNode fieldCachedKey_hasNode__;
                        boolean FieldCachedKey_duplicateFound_ = false;
                        if ((state & 1) != 0 && JSGuards.isJSObject(targetNodeValue_) && keyNodeValue_ == this.fieldCachedKey_hasNode_.getKey()) {
                            FieldCachedKey_duplicateFound_ = true;
                        }
                        if (!FieldCachedKey_duplicateFound_ && JSGuards.isJSObject(targetNodeValue_) && keyNodeValue_ == (fieldCachedKey_hasNode__ = (HasHiddenKeyCacheNode)super.insert((Node)HasHiddenKeyCacheNode.create(keyNodeValue_))).getKey() && (state & 1) == 0) {
                            this.fieldCachedKey_hasNode_ = (HasHiddenKeyCacheNode)super.insert((Node)fieldCachedKey_hasNode__);
                            this.fieldCachedKey_setNode_ = (PropertySetNode)super.insert((Node)PropertySetNode.createSetHidden(keyNodeValue_, this.context));
                            if (this.errorBranch == null) {
                                this.errorBranch = BranchProfile.create();
                            }
                            this.state_ = state |= 1;
                            FieldCachedKey_duplicateFound_ = true;
                        }
                        if (FieldCachedKey_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doFieldCachedKey(targetNodeValue_, (HiddenKey)keyNodeValue_, valueNodeValue, this.fieldCachedKey_hasNode_, this.fieldCachedKey_setNode_, this.errorBranch);
                            return object;
                        }
                    }
                    if (JSGuards.isJSObject(targetNodeValue_)) {
                        if (this.errorBranch == null) {
                            this.errorBranch = BranchProfile.create();
                        }
                        this.exclude_ = exclude |= 1;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doFieldUncachedKey(targetNodeValue_, (HiddenKey)keyNodeValue_, valueNodeValue, this.errorBranch);
                        return object;
                    }
                }
                if (keyNodeValue instanceof Accessor) {
                    keyNodeValue_ = (Accessor)keyNodeValue;
                    if (JSGuards.isJSObject(targetNodeValue_)) {
                        this.accessor_callNode_ = (JSFunctionCallNode)super.insert((Node)JSFunctionCallNode.createCall());
                        if (this.errorBranch == null) {
                            this.errorBranch = BranchProfile.create();
                        }
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doAccessor(targetNodeValue_, (Accessor)keyNodeValue_, valueNodeValue, this.accessor_callNode_, this.errorBranch);
                        return object;
                    }
                }
            }
            this.state_ = state |= 8;
            lock.unlock();
            hasLock = false;
            Object object = this.missing(targetNodeValue, keyNodeValue, valueNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Cloneable>> cached;
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doFieldCachedKey";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Cloneable>>();
            cached.add(Arrays.asList(new Cloneable[]{this.fieldCachedKey_hasNode_, this.fieldCachedKey_setNode_, this.errorBranch}));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doFieldUncachedKey";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.errorBranch));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doAccessor";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.accessor_callNode_, this.errorBranch));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "missing";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(Object targetNodeValue, Object keyNodeValue, Object valueNodeValue) {
        if (JSTypes.isDynamicObject(targetNodeValue)) {
            DynamicObject targetNodeValue_;
            if (keyNodeValue instanceof HiddenKey && JSGuards.isJSObject(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                return false;
            }
            if (keyNodeValue instanceof Accessor && JSGuards.isJSObject(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                return false;
            }
        }
        return true;
    }

    public static PrivateFieldSetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        return new PrivateFieldSetNodeGen(targetNode, keyNode, valueNode, context);
    }
}

