/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public final class ZeroBasedObjectArray
extends AbstractObjectArray {
    private static final ZeroBasedObjectArray ZERO_BASED_OBJECT_ARRAY = new ZeroBasedObjectArray(0, ZeroBasedObjectArray.createCache());

    public static ZeroBasedObjectArray makeZeroBasedObjectArray(DynamicObject object, int length, int usedLength, Object[] array, int integrityLevel) {
        ZeroBasedObjectArray arrayType = (ZeroBasedObjectArray)ZeroBasedObjectArray.createZeroBasedObjectArray().setIntegrityLevel(integrityLevel);
        JSAbstractArray.arraySetLength(object, length);
        JSAbstractArray.arraySetUsedLength(object, usedLength);
        JSAbstractArray.arraySetArray(object, array);
        return arrayType;
    }

    public static ZeroBasedObjectArray createZeroBasedObjectArray() {
        return ZERO_BASED_OBJECT_ARRAY;
    }

    private ZeroBasedObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index, boolean condition) {
        return ZeroBasedObjectArray.isSupportedZeroBased(object, (int)index, condition);
    }

    @Override
    public Object getInBoundsFastObject(DynamicObject object, int index, boolean condition) {
        return this.castNonNull(ZeroBasedObjectArray.getArray(object, condition)[index]);
    }

    @Override
    public void setInBoundsFast(DynamicObject object, int index, Object value, boolean condition) {
        ZeroBasedObjectArray.getArray((DynamicObject)object, (boolean)condition)[index] = ZeroBasedObjectArray.checkNonNull(value);
    }

    @Override
    protected int prepareInBoundsFast(DynamicObject object, long index, boolean condition) {
        return (int)index;
    }

    @Override
    protected int prepareInBounds(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        ZeroBasedObjectArray.prepareInBoundsZeroBased(object, index, condition, profile);
        return index;
    }

    @Override
    protected int prepareSupported(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        this.prepareSupportedZeroBased(object, index, condition, profile);
        return index;
    }

    @Override
    protected void setLengthLess(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        this.setLengthLessZeroBased(object, length, condition, profile);
    }

    @Override
    public ContiguousObjectArray toContiguous(DynamicObject object, long index, Object value, boolean condition) {
        Object[] array = ZeroBasedObjectArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedObjectArray.getUsedLength(object, condition);
        ContiguousObjectArray newArray = ContiguousObjectArray.makeContiguousObjectArray(object, length, array, 0L, 0, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public HolesObjectArray toHoles(DynamicObject object, long index, Object value, boolean condition) {
        Object[] array = ZeroBasedObjectArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedObjectArray.getUsedLength(object, condition);
        HolesObjectArray newArray = HolesObjectArray.makeHolesObjectArray(object, length, array, 0L, 0, usedLength, 0, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        return this.toArrayZeroBased(object);
    }

    @Override
    public long firstElementIndex(DynamicObject object, boolean condition) {
        return 0L;
    }

    @Override
    public long lastElementIndex(DynamicObject object, boolean condition) {
        return ZeroBasedObjectArray.getUsedLength(object, condition) - 1;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        Object[] array = ZeroBasedObjectArray.getArray(object);
        int usedLength = ZeroBasedObjectArray.getUsedLength(object);
        System.arraycopy(array, (int)end, array, (int)start, Math.max(0, (int)((long)usedLength - end)));
        return this;
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        return this.addRangeImplZeroBased(object, offset, size);
    }

    @Override
    public boolean hasHoles(DynamicObject object, boolean condition) {
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedObjectArray.getUsedLength(object, condition);
        return usedLength < length;
    }

    @Override
    protected ZeroBasedObjectArray withIntegrityLevel(int newIntegrityLevel) {
        return new ZeroBasedObjectArray(newIntegrityLevel, this.cache);
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index, boolean condition) {
        return this.nextElementIndexZeroBased(object, index, condition);
    }
}

