/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.intl.CreateOptionsObjectNode;
import com.oracle.truffle.js.nodes.intl.CreateOptionsObjectNodeGen;
import com.oracle.truffle.js.nodes.intl.DefaultNumberOptionNode;
import com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import com.oracle.truffle.js.nodes.intl.GetNumberOptionNode;
import com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import com.oracle.truffle.js.nodes.intl.InitializeNumberFormatNodeGen;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSNumberFormat;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.MissingResourceException;

public abstract class InitializeNumberFormatNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CreateOptionsObjectNode createOptionsNode;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getNumberingSystemOption;
    @Node.Child
    GetNumberOptionNode getMinIntDigitsOption;
    @Node.Child
    GetNumberOptionNode getMinFracDigitsOption;
    @Node.Child
    GetNumberOptionNode getMaxFracDigitsOption;
    @Node.Child
    PropertyGetNode getMinSignificantDigitsOption;
    @Node.Child
    PropertyGetNode getMaxSignificantDigitsOption;
    @Node.Child
    DefaultNumberOptionNode getMnsdDNO;
    @Node.Child
    DefaultNumberOptionNode getMxsdDNO;
    @Node.Child
    GetStringOptionNode getStyleOption;
    @Node.Child
    GetStringOptionNode getCurrencyOption;
    @Node.Child
    GetStringOptionNode getCurrencyDisplayOption;
    @Node.Child
    GetBooleanOptionNode getUseGroupingOption;

    protected InitializeNumberFormatNode(JSContext context) {
        this.context = context;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.createOptionsNode = CreateOptionsObjectNodeGen.create(context);
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, "localeMatcher", new String[]{"lookup", "best fit"}, "best fit");
        this.getNumberingSystemOption = GetStringOptionNode.create(context, "numberingSystem", null, null);
        this.getStyleOption = GetStringOptionNode.create(context, "style", new String[]{"decimal", "percent", "currency"}, "decimal");
        this.getCurrencyOption = GetStringOptionNode.create(context, "currency", null, null);
        this.getCurrencyDisplayOption = GetStringOptionNode.create(context, "currencyDisplay", new String[]{"code", "symbol", "name"}, "symbol");
        this.getUseGroupingOption = GetBooleanOptionNode.create(context, "useGrouping", true);
        this.getMinIntDigitsOption = GetNumberOptionNode.create(context, "minimumIntegerDigits", 21);
        this.getMinSignificantDigitsOption = PropertyGetNode.create("minimumSignificantDigits", false, context);
        this.getMaxSignificantDigitsOption = PropertyGetNode.create("maximumSignificantDigits", false, context);
        this.getMinFracDigitsOption = GetNumberOptionNode.create(context, "minimumFractionDigits", 21);
        this.getMaxFracDigitsOption = GetNumberOptionNode.create(context, "maximumFractionDigits", 20);
        this.getMnsdDNO = DefaultNumberOptionNode.create(21, 1);
        this.getMxsdDNO = DefaultNumberOptionNode.create(21, 21);
    }

    public abstract DynamicObject executeInit(DynamicObject var1, Object var2, Object var3);

    public static InitializeNumberFormatNode createInitalizeNumberFormatNode(JSContext context) {
        return InitializeNumberFormatNodeGen.create(context);
    }

    @Specialization
    public DynamicObject initializeNumberFormat(DynamicObject numberFormatObj, Object localesArg, Object optionsArg) {
        try {
            int cDigits;
            JSNumberFormat.InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            DynamicObject options = this.createOptionsNode.execute(optionsArg);
            this.getLocaleMatcherOption.executeValue(options);
            String numberingSystemOpt = this.getNumberingSystemOption.executeValue(options);
            if (numberingSystemOpt != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(numberingSystemOpt);
                numberingSystemOpt = IntlUtil.normalizeUnicodeLocaleIdentifierType(numberingSystemOpt);
            }
            String optStyle = this.getStyleOption.executeValue(options);
            String optCurrency = this.getCurrencyOption.executeValue(options);
            String optCurrencyDisplay = this.getCurrencyDisplayOption.executeValue(options);
            state.setInitialized(true);
            JSNumberFormat.setLocaleAndNumberingSystem(this.context, state, locales, numberingSystemOpt);
            state.setStyle(optStyle);
            String currencyCode = optCurrency;
            if (currencyCode != null) {
                IntlUtil.ensureIsWellFormedCurrencyCode(currencyCode);
            }
            if (optStyle.equals("currency")) {
                if (currencyCode == null) {
                    throw Errors.createTypeErrorFormat("Currency can not be undefined when style is \"%s\"", "currency");
                }
                state.setCurrency(IntlUtil.toUpperCase(currencyCode));
            }
            int mnfdDefault = cDigits = JSNumberFormat.currencyDigits(state.getCurrency());
            int mxfdDefault = cDigits;
            if (state.getStyle().equals("currency")) {
                state.setCurrencyDisplay(optCurrencyDisplay);
            } else {
                mnfdDefault = 0;
                mxfdDefault = state.getStyle().equals("percent") ? 0 : 3;
            }
            JSNumberFormat.setupInternalNumberFormat(state);
            this.setNumberFormatDigitOptions(state, options, mnfdDefault, mxfdDefault);
            state.setGroupingUsed(this.getUseGroupingOption.executeValue(options));
        }
        catch (MissingResourceException e) {
            throw Errors.createICU4JDataError(e);
        }
        return numberFormatObj;
    }

    private void setNumberFormatDigitOptions(JSNumberFormat.BasicInternalState state, DynamicObject options, int mnfdDefault, int mxfdDefault) {
        Number mnid = this.getMinIntDigitsOption.executeValue(options, 1, 1);
        Number mnfd = this.getMinFracDigitsOption.executeValue(options, 0, mnfdDefault);
        int mxfdActualDefault = Math.max(mnfd.intValue(), mxfdDefault);
        Number mxfd = this.getMaxFracDigitsOption.executeValue(options, mnfd, mxfdActualDefault);
        state.setIntegerAndFractionsDigits(mnid.intValue(), mnfd.intValue(), mxfd.intValue());
        Object mnsd = this.getMinSignificantDigitsOption.getValue(options);
        Object mxsd = this.getMaxSignificantDigitsOption.getValue(options);
        if (!JSGuards.isUndefined(mnsd) || !JSGuards.isUndefined(mxsd)) {
            Number mnsdNumber = this.getMnsdDNO.executeValue(mnsd, 1);
            Number mxsdNumber = this.getMxsdDNO.executeValue(mxsd, mnsdNumber.intValue());
            state.setSignificantDigits(mnsdNumber.intValue(), mxsdNumber.intValue());
        }
    }
}

