/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.CommandListener;
import org.apache.maven.surefire.booter.CommandReader;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.common.junit4.JUnitTestFailureListener;
import org.apache.maven.surefire.common.junit4.Notifier;
import org.apache.maven.surefire.junit4.TestResolverFilter;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.apache.maven.surefire.util.internal.ObjectUtils;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

public class JUnit4Provider
extends AbstractProvider {
    private static final String UNDETERMINED_TESTS_DESCRIPTION = "cannot determine test in forked JVM with surefire";
    private final ClassLoader testClassLoader;
    private final String customRunListeners;
    private final JUnit4TestChecker jUnit4TestChecker;
    private final TestListResolver testResolver;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private final ScanResult scanResult;
    private final int rerunFailingTestsCount;
    private final CommandReader commandsReader;
    private TestsToRun testsToRun;

    public JUnit4Provider(ProviderParameters bootParams) {
        this.commandsReader = bootParams.isInsideFork() ? CommandReader.getReader().setShutdown(bootParams.getShutdown()) : null;
        this.providerParameters = bootParams;
        this.testClassLoader = bootParams.getTestClassLoader();
        this.scanResult = bootParams.getScanResult();
        this.runOrderCalculator = bootParams.getRunOrderCalculator();
        this.customRunListeners = (String)bootParams.getProviderProperties().get("listener");
        this.jUnit4TestChecker = new JUnit4TestChecker(this.testClassLoader);
        TestRequest testRequest = bootParams.getTestRequest();
        this.testResolver = testRequest.getTestListResolver();
        this.rerunFailingTestsCount = testRequest.getRerunFailingTestsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        RunResult runResult;
        this.upgradeCheck();
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        try {
            RunListener reporter = reporterFactory.createReporter();
            ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
            if (this.testsToRun == null) {
                this.setTestsToRun(forkTestSet);
            }
            Notifier notifier = new Notifier(new JUnit4RunListener(reporter), this.getSkipAfterFailureCount());
            Result result = new Result();
            notifier.addListeners((Collection)JUnit4RunListenerFactory.createCustomListeners((String)this.customRunListeners)).addListener(result.createListener());
            if (this.isFailFast() && this.commandsReader != null) {
                this.registerPleaseStopJUnitListener(notifier);
            }
            try {
                notifier.fireTestRunStarted(this.testsToRun.allowEagerReading() ? JUnit4Provider.createTestsDescription(this.testsToRun) : JUnit4Reflector.createDescription((String)UNDETERMINED_TESTS_DESCRIPTION));
                if (this.commandsReader != null) {
                    this.registerShutdownListener(this.testsToRun);
                    this.commandsReader.awaitStarted();
                }
                for (Class testToRun : this.testsToRun) {
                    this.executeTestSet(testToRun, reporter, notifier);
                }
            }
            finally {
                notifier.fireTestRunFinished(result);
                notifier.removeListeners();
            }
            JUnit4RunListener.rethrowAnyTestMechanismFailures((Result)result);
        }
        finally {
            runResult = reporterFactory.close();
        }
        return runResult;
    }

    private void setTestsToRun(Object forkTestSet) throws TestSetFailedException {
        this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.scanClassPath());
    }

    private boolean isRerunFailingTests() {
        return this.rerunFailingTestsCount > 0;
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void registerShutdownListener(final TestsToRun testsToRun) {
        this.commandsReader.addShutdownListener(new CommandListener(){

            public void update(Command command) {
                testsToRun.markTestSetFinished();
            }
        });
    }

    private void registerPleaseStopJUnitListener(final Notifier notifier) {
        this.commandsReader.addSkipNextTestsListener(new CommandListener(){

            public void update(Command command) {
                notifier.pleaseStop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestSet(Class<?> clazz, RunListener reporter, Notifier notifier) {
        SimpleReportEntry report = new SimpleReportEntry(clazz.getName(), null, null, null, ObjectUtils.systemProps());
        reporter.testSetStarting((TestSetReportEntry)report);
        try {
            this.executeWithRerun(clazz, notifier);
        }
        catch (Throwable e) {
            if (this.isFailFast() && e instanceof StoppedByUserException) {
                String reason = e.getClass().getName();
                Description skippedTest = JUnit4Reflector.createDescription((String)clazz.getName(), (Annotation[])new Annotation[]{JUnit4Reflector.createIgnored((String)reason)});
                notifier.fireTestIgnored(skippedTest);
            } else {
                String reportName = report.getName();
                String reportSourceName = report.getSourceName();
                PojoStackTraceWriter stackWriter = new PojoStackTraceWriter(reportSourceName, reportName, e);
                reporter.testError((ReportEntry)SimpleReportEntry.withException((String)reportSourceName, null, (String)reportName, null, (StackTraceWriter)stackWriter));
            }
        }
        finally {
            reporter.testSetCompleted((TestSetReportEntry)report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithRerun(Class<?> clazz, Notifier notifier) {
        JUnitTestFailureListener failureListener = new JUnitTestFailureListener();
        notifier.addListener((org.junit.runner.notification.RunListener)failureListener);
        boolean hasMethodFilter = this.testResolver != null && this.testResolver.hasMethodPatterns();
        try {
            try {
                notifier.asFailFast(this.isFailFast());
                JUnit4Provider.execute(clazz, notifier, hasMethodFilter ? this.createMethodFilter() : null);
            }
            finally {
                notifier.asFailFast(false);
            }
            if (this.isRerunFailingTests()) {
                Notifier rerunNotifier = Notifier.pureNotifier();
                notifier.copyListenersTo(rerunNotifier);
                for (int i = 0; i < this.rerunFailingTestsCount && !failureListener.getAllFailures().isEmpty(); ++i) {
                    Set failures = JUnit4ProviderUtil.generateFailingTestDescriptions((List)failureListener.getAllFailures());
                    failureListener.reset();
                    Filter failureDescriptionFilter = JUnit4ProviderUtil.createMatchAnyDescriptionFilter((Iterable)failures);
                    JUnit4Provider.execute(clazz, rerunNotifier, failureDescriptionFilter);
                }
            }
        }
        finally {
            notifier.removeListener((org.junit.runner.notification.RunListener)failureListener);
        }
    }

    public Iterable<Class<?>> getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun;
    }

    private TestsToRun scanClassPath() {
        TestsToRun scannedClasses = this.scanResult.applyFilter((ScannerFilter)this.jUnit4TestChecker, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scannedClasses);
    }

    private void upgradeCheck() throws TestSetFailedException {
        List classesSkippedByValidation;
        if (JUnit4Provider.isJUnit4UpgradeCheck() && !(classesSkippedByValidation = this.scanResult.getClassesSkippedByValidation((ScannerFilter)this.jUnit4TestChecker, this.testClassLoader)).isEmpty()) {
            StringBuilder reason = new StringBuilder();
            reason.append("Updated check failed\n");
            reason.append("There are tests that would be run with junit4 / surefire 2.6 but not with [2.7,):\n");
            for (Class testClass : classesSkippedByValidation) {
                reason.append("   ");
                reason.append(testClass.getName());
                reason.append("\n");
            }
            throw new TestSetFailedException(reason.toString());
        }
    }

    static Description createTestsDescription(Iterable<Class<?>> classes) {
        Description description = JUnit4Reflector.createDescription((String)"null");
        for (Class<?> clazz : classes) {
            description.addChild(JUnit4Reflector.createDescription((String)clazz.getName()));
        }
        return description;
    }

    private static boolean isJUnit4UpgradeCheck() {
        return System.getProperty("surefire.junit4.upgradecheck") != null;
    }

    private static void execute(Class<?> testClass, Notifier notifier, Filter filter) {
        int classModifiers = testClass.getModifiers();
        if (!Modifier.isAbstract(classModifiers) && !Modifier.isInterface(classModifiers)) {
            Runner runner;
            Request request = Request.aClass(testClass);
            if (filter != null) {
                request = request.filterWith(filter);
            }
            if (JUnit4Provider.countTestsInRunner((runner = request.getRunner()).getDescription()) != 0) {
                runner.run((RunNotifier)notifier);
            }
        }
    }

    private static int countTestsInRunner(Description description) {
        if (description.isSuite()) {
            int count = 0;
            for (Description child : description.getChildren()) {
                if (JUnit4Provider.hasFilteredOutAllChildren(child)) continue;
                count += JUnit4Provider.countTestsInRunner(child);
            }
            return count;
        }
        if (description.isTest()) {
            return JUnit4Provider.hasFilteredOutAllChildren(description) ? 0 : 1;
        }
        return 0;
    }

    private static boolean hasFilteredOutAllChildren(Description description) {
        if (JUnit4ProviderUtil.isFailureInsideJUnitItself((Description)description)) {
            return true;
        }
        String name = description.getDisplayName();
        if (name == null) {
            return true;
        }
        return (name = name.trim()).startsWith("initializationError0(org.junit.runner.manipulation.Filter)") || name.startsWith("initializationError(org.junit.runner.manipulation.Filter)");
    }

    private Filter createMethodFilter() {
        TestListResolver methodFilter = TestListResolver.optionallyWildcardFilter((TestListResolver)this.testResolver);
        return methodFilter.isEmpty() || methodFilter.isWildcard() ? null : new TestResolverFilter(methodFilter);
    }
}

