/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.function.SpecializedNewObjectNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;

@ReportPolymorphism
public abstract class SpecializedNewObjectNode
extends JavaScriptBaseNode {
    protected final JSContext context;
    protected final boolean isBuiltin;
    protected final boolean isConstructor;
    protected final boolean isGenerator;
    protected final boolean isAsyncGenerator;
    @Node.Child
    private JSTargetableNode getPrototypeNode;

    public SpecializedNewObjectNode(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator) {
        this.context = context;
        this.isBuiltin = isBuiltin;
        this.isConstructor = isConstructor;
        this.isGenerator = isGenerator;
        this.isAsyncGenerator = isAsyncGenerator;
        this.getPrototypeNode = !isBuiltin && isConstructor ? PropertyNode.createProperty(context, null, "prototype") : null;
    }

    public static SpecializedNewObjectNode create(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator) {
        return SpecializedNewObjectNodeGen.create(context, isBuiltin, isConstructor, isGenerator, isAsyncGenerator);
    }

    public static SpecializedNewObjectNode create(JSFunctionData functionData) {
        return SpecializedNewObjectNode.create(functionData.getContext(), functionData.isBuiltin(), functionData.isConstructor(), functionData.isGenerator(), functionData.isAsyncGenerator());
    }

    public final DynamicObject execute(VirtualFrame frame, DynamicObject newTarget) {
        DynamicObject prototype = this.getPrototypeNode != null ? this.getPrototypeNode.executeWithTarget(frame, newTarget) : Undefined.instance;
        return this.execute(newTarget, (Object)prototype);
    }

    protected abstract DynamicObject execute(DynamicObject var1, Object var2);

    protected Shape getProtoChildShape(Object prototype) {
        CompilerAsserts.neverPartOfCompilation();
        if (JSGuards.isJSObject(prototype)) {
            return JSObjectUtil.getProtoChildShape((DynamicObject)prototype, JSUserObject.INSTANCE, this.context);
        }
        return null;
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "!context.isMultiContext()", "isJSObject(cachedPrototype)", "prototype == cachedPrototype"}, limit="context.getPropertyCacheLimit()")
    public DynamicObject doCachedProto(DynamicObject target, DynamicObject prototype, @Cached(value="prototype") DynamicObject cachedPrototype, @Cached(value="getProtoChildShape(prototype)") Shape shape) {
        return JSObject.create(this.context, shape);
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "!context.isMultiContext()", "isJSObject(prototype)"}, replaces={"doCachedProto"})
    public DynamicObject doUncachedProto(DynamicObject target, DynamicObject prototype, @Cached(value="create()") BranchProfile slowBranch) {
        return JSObject.createBoundary(this.context, JSObjectUtil.getProtoChildShape(prototype, JSUserObject.INSTANCE, this.context, slowBranch));
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "context.isMultiContext()", "isJSObject(prototype)"})
    public DynamicObject createWithProto(DynamicObject target, DynamicObject prototype) {
        return JSUserObject.createWithPrototypeInObject(prototype, this.context);
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "!isJSObject(prototype)"})
    public DynamicObject createDefaultProto(DynamicObject target, Object prototype) {
        JSRealm realm = JSRuntime.getFunctionRealm((Object)target, this.context);
        if (this.isAsyncGenerator) {
            return JSObject.createWithRealm(this.context, this.context.getAsyncGeneratorObjectFactory(), realm, new Object[0]);
        }
        if (this.isGenerator) {
            return JSObject.createWithRealm(this.context, this.context.getGeneratorObjectFactory(), realm, new Object[0]);
        }
        return JSUserObject.create(this.context, realm);
    }

    @Specialization(guards={"isBuiltin", "isConstructor"})
    static DynamicObject builtinConstructor(DynamicObject target, Object proto) {
        return JSFunction.CONSTRUCT;
    }

    @Specialization(guards={"!isConstructor"})
    public DynamicObject throwNotConstructorFunctionTypeError(DynamicObject target, Object proto) {
        throw Errors.createTypeErrorNotAConstructor(target, this.context);
    }
}

