/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.DelegatingNodeRendererFactoryWrapper;
import com.vladsch.flexmark.html.Disposable;
import com.vladsch.flexmark.html.EmbeddedAttributeProvider;
import com.vladsch.flexmark.html.HtmlRendererOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.NodeRendererSubContext;
import com.vladsch.flexmark.html.NodeRenderingHandlerWrapper;
import com.vladsch.flexmark.html.RendererBuilder;
import com.vladsch.flexmark.html.RendererExtension;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.CoreNodeRenderer;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.IRender;
import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.builder.BuilderBase;
import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.collection.DataValueFactory;
import com.vladsch.flexmark.util.collection.DynamicDefaultKey;
import com.vladsch.flexmark.util.dependency.DependencyHandler;
import com.vladsch.flexmark.util.dependency.FlatDependencyHandler;
import com.vladsch.flexmark.util.dependency.ResolvedDependencies;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.DataSet;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.ScopedDataSet;
import com.vladsch.flexmark.util.sequence.TagRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HtmlRenderer
implements IRender {
    public static final DataKey<String> SOFT_BREAK = new DataKey("SOFT_BREAK", (Object)"\n");
    public static final DataKey<String> HARD_BREAK = new DataKey("HARD_BREAK", (Object)"<br />\n");
    public static final DataKey<String> STRONG_EMPHASIS_STYLE_HTML_OPEN = new DataKey("STRONG_EMPHASIS_STYLE_HTML_OPEN", (Object)null);
    public static final DataKey<String> STRONG_EMPHASIS_STYLE_HTML_CLOSE = new DataKey("STRONG_EMPHASIS_STYLE_HTML_CLOSE", (Object)null);
    public static final DataKey<String> EMPHASIS_STYLE_HTML_OPEN = new DataKey("EMPHASIS_STYLE_HTML_OPEN", (Object)null);
    public static final DataKey<String> EMPHASIS_STYLE_HTML_CLOSE = new DataKey("EMPHASIS_STYLE_HTML_CLOSE", (Object)null);
    public static final DataKey<String> CODE_STYLE_HTML_OPEN = new DataKey("CODE_STYLE_HTML_OPEN", (Object)null);
    public static final DataKey<String> CODE_STYLE_HTML_CLOSE = new DataKey("CODE_STYLE_HTML_CLOSE", (Object)null);
    public static final DataKey<String> INLINE_CODE_SPLICE_CLASS = new DataKey("INLINE_CODE_SPLICE_CLASS", (Object)null);
    public static final DataKey<Boolean> PERCENT_ENCODE_URLS = new DataKey("PERCENT_ENCODE_URLS", (Object)false);
    public static final DataKey<Integer> INDENT_SIZE = new DataKey("INDENT_SIZE", (Object)0);
    public static final DataKey<Boolean> ESCAPE_HTML = new DataKey("ESCAPE_HTML", (Object)false);
    public static final DataKey<Boolean> ESCAPE_HTML_BLOCKS = new DynamicDefaultKey("ESCAPE_HTML_BLOCKS", ESCAPE_HTML);
    public static final DataKey<Boolean> ESCAPE_HTML_COMMENT_BLOCKS = new DynamicDefaultKey("ESCAPE_HTML_COMMENT_BLOCKS", ESCAPE_HTML_BLOCKS);
    public static final DataKey<Boolean> ESCAPE_INLINE_HTML = new DynamicDefaultKey("ESCAPE_HTML_BLOCKS", ESCAPE_HTML);
    public static final DataKey<Boolean> ESCAPE_INLINE_HTML_COMMENTS = new DynamicDefaultKey("ESCAPE_INLINE_HTML_COMMENTS", ESCAPE_INLINE_HTML);
    public static final DataKey<Boolean> SUPPRESS_HTML = new DataKey("SUPPRESS_HTML", (Object)false);
    public static final DataKey<Boolean> SUPPRESS_HTML_BLOCKS = new DynamicDefaultKey("SUPPRESS_HTML_BLOCKS", SUPPRESS_HTML);
    public static final DataKey<Boolean> SUPPRESS_HTML_COMMENT_BLOCKS = new DynamicDefaultKey("SUPPRESS_HTML_COMMENT_BLOCKS", SUPPRESS_HTML_BLOCKS);
    public static final DataKey<Boolean> SUPPRESS_INLINE_HTML = new DynamicDefaultKey("SUPPRESS_INLINE_HTML", SUPPRESS_HTML);
    public static final DataKey<Boolean> SUPPRESS_INLINE_HTML_COMMENTS = new DynamicDefaultKey("SUPPRESS_INLINE_HTML_COMMENTS", SUPPRESS_INLINE_HTML);
    public static final DataKey<Boolean> SOURCE_WRAP_HTML = new DataKey("SOURCE_WRAP_HTML", (Object)false);
    public static final DataKey<Boolean> SOURCE_WRAP_HTML_BLOCKS = new DynamicDefaultKey("SOURCE_WRAP_HTML_BLOCKS", SOURCE_WRAP_HTML);
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_RESOLVE_DUPES = new DataKey("HEADER_ID_GENERATOR_RESOLVE_DUPES", (Object)true);
    public static final DataKey<String> HEADER_ID_GENERATOR_TO_DASH_CHARS = new DataKey("HEADER_ID_GENERATOR_TO_DASH_CHARS", (Object)" -_");
    public static final DataKey<String> HEADER_ID_GENERATOR_NON_DASH_CHARS = new DataKey("HEADER_ID_GENERATOR_NON_DASH_CHARS", (Object)"");
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_NO_DUPED_DASHES = new DataKey("HEADER_ID_GENERATOR_NO_DUPED_DASHES", (Object)false);
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_NON_ASCII_TO_LOWERCASE = new DataKey("HEADER_ID_GENERATOR_NON_ASCII_TO_LOWERCASE", (Object)true);
    public static final DataKey<Boolean> RENDER_HEADER_ID = new DataKey("RENDER_HEADER_ID", (Object)false);
    public static final DataKey<Boolean> GENERATE_HEADER_ID = new DataKey("GENERATE_HEADER_ID", (Object)true);
    public static final DataKey<Boolean> DO_NOT_RENDER_LINKS = new DataKey("DO_NOT_RENDER_LINKS", (Object)false);
    public static final DataKey<String> FENCED_CODE_LANGUAGE_CLASS_PREFIX = new DataKey("FENCED_CODE_LANGUAGE_CLASS_PREFIX", (Object)"language-");
    public static final DataKey<String> FENCED_CODE_NO_LANGUAGE_CLASS = new DataKey("FENCED_CODE_NO_LANGUAGE_CLASS", (Object)"");
    public static final DataKey<String> SOURCE_POSITION_ATTRIBUTE = new DataKey("SOURCE_POSITION_ATTRIBUTE", (Object)"");
    public static final DataKey<Boolean> SOURCE_POSITION_PARAGRAPH_LINES = new DataKey("SOURCE_POSITION_PARAGRAPH_LINES", (Object)false);
    public static final DataKey<String> TYPE = new DataKey("TYPE", (Object)"HTML");
    public static final DataKey<ArrayList<TagRange>> TAG_RANGES = new DataKey("TAG_RANGES", (DataValueFactory)new DataValueFactory<ArrayList<TagRange>>(){

        public ArrayList<TagRange> create(DataHolder value) {
            return new ArrayList<TagRange>();
        }
    });
    public static final DataKey<Boolean> RECHECK_UNDEFINED_REFERENCES = new DataKey("RECHECK_UNDEFINED_REFERENCES", (Object)false);
    public static final DataKey<Boolean> OBFUSCATE_EMAIL = new DataKey("OBFUSCATE_EMAIL", (Object)false);
    public static final DataKey<Boolean> OBFUSCATE_EMAIL_RANDOM = new DataKey("OBFUSCATE_EMAIL_RANDOM", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_OPEN_TAG_EOL = new DataKey("HTML_BLOCK_OPEN_TAG_EOL", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_CLOSE_TAG_EOL = new DataKey("HTML_BLOCK_CLOSE_TAG_EOL", (Object)true);
    public static final DataKey<Boolean> UNESCAPE_HTML_ENTITIES = new DataKey("UNESCAPE_HTML_ENTITIES", (Object)true);
    public static final DataKey<String> AUTOLINK_WWW_PREFIX = new DataKey("AUTOLINK_WWW_PREFIX", (Object)"http://");
    public static final DataKey<String> SUPPRESSED_LINKS = new DataKey("SUPPRESSED_LINKS", (Object)"javascript:.*");
    public static final DataKey<Boolean> NO_P_TAGS_USE_BR = new DataKey("NO_P_TAGS_USE_BR", (Object)false);
    public static final DataKey<Boolean> EMBEDDED_ATTRIBUTE_PROVIDER = new DataKey("EMBEDDED_ATTRIBUTE_PROVIDER", (Object)true);
    public static final DataKey<Integer> FORMAT_FLAGS = new DataKey("FORMAT_FLAGS", (Object)0);
    public static final DataKey<Integer> MAX_TRAILING_BLANK_LINES = new DataKey("MAX_TRAILING_BLANK_LINES", (Object)1);
    public static final int CONVERT_TABS = 1;
    public static final int COLLAPSE_WHITESPACE = 2;
    public static final int SUPPRESS_TRAILING_WHITESPACE = 4;
    public static final int PREFIX_AFTER_PENDING_EOL = 8;
    public static final int PASS_THROUGH = 16;
    public static final int ALLOW_LEADING_WHITESPACE = 32;
    public static final int FORMAT_ALL = 7;
    public static final DataKey<List<Pair<String, String>>> RENDERER_TYPE_EQUIVALENCE = new DataKey("RENDERER_TYPE_EQUIVALENCE", Collections.emptyList());
    public static final int FORMAT_CONVERT_TABS = 1;
    public static final int FORMAT_COLLAPSE_WHITESPACE = 2;
    public static final int FORMAT_SUPPRESS_TRAILING_WHITESPACE = 4;
    public static final int FORMAT_ALL_OPTIONS = 7;
    private final List<AttributeProviderFactory> attributeProviderFactories;
    private final List<DelegatingNodeRendererFactoryWrapper> nodeRendererFactories;
    private final List<LinkResolverFactory> linkResolverFactories;
    private final HeaderIdGeneratorFactory htmlIdGeneratorFactory;
    private final HtmlRendererOptions htmlOptions;
    private final DataHolder options;
    private final Builder builder;

    HtmlRenderer(Builder builder) {
        this.builder = new Builder(builder);
        this.options = new DataSet((DataHolder)builder);
        this.htmlOptions = new HtmlRendererOptions(this.options);
        this.htmlIdGeneratorFactory = builder.htmlIdGeneratorFactory;
        ArrayList<DelegatingNodeRendererFactoryWrapper> nodeRenderers = new ArrayList<DelegatingNodeRendererFactoryWrapper>(builder.nodeRendererFactories.size());
        for (int i = builder.nodeRendererFactories.size() - 1; i >= 0; --i) {
            NodeRendererFactory nodeRendererFactory = builder.nodeRendererFactories.get(i);
            Set[] myDelegates = new Set[]{null};
            nodeRenderers.add(new DelegatingNodeRendererFactoryWrapper(nodeRenderers, nodeRendererFactory));
        }
        CoreNodeRenderer.Factory nodeRendererFactory = new CoreNodeRenderer.Factory();
        nodeRenderers.add(new DelegatingNodeRendererFactoryWrapper(nodeRenderers, nodeRendererFactory));
        RendererDependencyHandler resolver = new RendererDependencyHandler();
        this.nodeRendererFactories = ((RendererDependencies)resolver.resolveDependencies(nodeRenderers)).getNodeRendererFactories();
        boolean addEmbedded = !builder.attributeProviderFactories.containsKey(EmbeddedAttributeProvider.Factory.getClass());
        ArrayList<AttributeProviderFactory> values = new ArrayList<AttributeProviderFactory>(builder.attributeProviderFactories.values());
        if (addEmbedded && ((Boolean)EMBEDDED_ATTRIBUTE_PROVIDER.getFrom(this.options)).booleanValue()) {
            values.add(0, EmbeddedAttributeProvider.Factory);
        }
        this.attributeProviderFactories = FlatDependencyHandler.computeDependencies(values);
        this.linkResolverFactories = FlatDependencyHandler.computeDependencies(builder.linkResolverFactories);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    public DataHolder getOptions() {
        return new DataSet((DataHolder)this.builder);
    }

    public void render(Node node, Appendable output) {
        MainNodeRenderer renderer = new MainNodeRenderer(this.options, new HtmlWriter(output, this.htmlOptions.indentSize, this.htmlOptions.formatFlags, !this.htmlOptions.htmlBlockOpenTagEol, !this.htmlOptions.htmlBlockCloseTagEol), node.getDocument());
        renderer.render(node);
        renderer.flush(this.htmlOptions.maxTrailingBlankLines);
        renderer.dispose();
    }

    public void render(Node node, Appendable output, int maxTrailingBlankLines) {
        MainNodeRenderer renderer = new MainNodeRenderer(this.options, new HtmlWriter(output, this.htmlOptions.indentSize, this.htmlOptions.formatFlags, !this.htmlOptions.htmlBlockOpenTagEol, !this.htmlOptions.htmlBlockCloseTagEol), node.getDocument());
        renderer.render(node);
        renderer.flush(maxTrailingBlankLines);
        renderer.dispose();
    }

    public String render(Node node) {
        StringBuilder sb = new StringBuilder();
        this.render(node, sb);
        return sb.toString();
    }

    public HtmlRenderer withOptions(DataHolder options) {
        return options == null ? this : new HtmlRenderer(new Builder(this.builder, options));
    }

    public static boolean isCompatibleRendererType(MutableDataHolder options, String supportedRendererType) {
        String rendererType = (String)TYPE.getFrom((DataHolder)options);
        return HtmlRenderer.isCompatibleRendererType(options, rendererType, supportedRendererType);
    }

    public static boolean isCompatibleRendererType(MutableDataHolder options, String rendererType, String supportedRendererType) {
        if (rendererType.equals(supportedRendererType)) {
            return true;
        }
        List equivalence = (List)RENDERER_TYPE_EQUIVALENCE.getFrom((DataHolder)options);
        for (Pair pair : equivalence) {
            if (!rendererType.equals(pair.getFirst()) || !supportedRendererType.equals(pair.getSecond())) continue;
            return true;
        }
        return false;
    }

    public static MutableDataHolder addRenderTypeEquivalence(MutableDataHolder options, String rendererType, String supportedRendererType) {
        if (!HtmlRenderer.isCompatibleRendererType(options, rendererType, supportedRendererType)) {
            List equivalence = (List)RENDERER_TYPE_EQUIVALENCE.getFrom((DataHolder)options);
            ArrayList<Pair> newEquivalence = new ArrayList<Pair>(equivalence);
            newEquivalence.add(new Pair((Object)rendererType, (Object)supportedRendererType));
            options.set(RENDERER_TYPE_EQUIVALENCE, newEquivalence);
        }
        return options;
    }

    private class MainNodeRenderer
    extends NodeRendererSubContext
    implements NodeRendererContext,
    Disposable {
        private Document document;
        private Map<Class<?>, NodeRenderingHandlerWrapper> renderers;
        private List<PhasedNodeRenderer> phasedRenderers;
        private LinkResolver[] myLinkResolvers;
        private Set<RenderingPhase> renderingPhases;
        private DataHolder options;
        private RenderingPhase phase;
        private HtmlIdGenerator htmlIdGenerator;
        private HashMap<LinkType, HashMap<String, ResolvedLink>> resolvedLinkMap;
        private AttributeProvider[] attributeProviders;

        @Override
        public void dispose() {
            this.document = null;
            this.renderers = null;
            this.phasedRenderers = null;
            for (LinkResolver linkResolver : this.myLinkResolvers) {
                if (!(linkResolver instanceof Disposable)) continue;
                ((Disposable)((Object)linkResolver)).dispose();
            }
            this.myLinkResolvers = null;
            this.renderingPhases = null;
            this.options = null;
            if (this.htmlIdGenerator instanceof Disposable) {
                ((Disposable)((Object)this.htmlIdGenerator)).dispose();
            }
            this.htmlIdGenerator = null;
            this.resolvedLinkMap = null;
            for (AttributeProvider attributeProvider : this.attributeProviders) {
                if (!(attributeProvider instanceof Disposable)) continue;
                ((Disposable)((Object)attributeProvider)).dispose();
            }
            this.attributeProviders = null;
        }

        MainNodeRenderer(DataHolder options, HtmlWriter htmlWriter, Document document) {
            int i;
            super(htmlWriter);
            this.resolvedLinkMap = new HashMap();
            this.options = new ScopedDataSet((DataHolder)document, options);
            this.document = document;
            this.renderers = new HashMap(32);
            this.renderingPhases = new HashSet<RenderingPhase>(RenderingPhase.values().length);
            this.phasedRenderers = new ArrayList<PhasedNodeRenderer>(HtmlRenderer.this.nodeRendererFactories.size());
            this.myLinkResolvers = new LinkResolver[HtmlRenderer.this.linkResolverFactories.size()];
            int n = this.doNotRenderLinksNesting = ((HtmlRenderer)HtmlRenderer.this).htmlOptions.doNotRenderLinksInDocument ? 0 : 1;
            this.htmlIdGenerator = HtmlRenderer.this.htmlIdGeneratorFactory != null ? HtmlRenderer.this.htmlIdGeneratorFactory.create(this) : (!((HtmlRenderer)HtmlRenderer.this).htmlOptions.renderHeaderId && !((HtmlRenderer)HtmlRenderer.this).htmlOptions.generateHeaderIds ? HtmlIdGenerator.NULL : new HeaderIdGenerator.Factory().create(this));
            htmlWriter.setContext(this);
            for (i = HtmlRenderer.this.nodeRendererFactories.size() - 1; i >= 0; --i) {
                NodeRendererFactory nodeRendererFactory = (NodeRendererFactory)HtmlRenderer.this.nodeRendererFactories.get(i);
                NodeRenderer nodeRenderer = nodeRendererFactory.create(this.getOptions());
                for (NodeRenderingHandler<?> nodeType : nodeRenderer.getNodeRenderingHandlers()) {
                    NodeRenderingHandlerWrapper handlerWrapper = new NodeRenderingHandlerWrapper(nodeType, this.renderers.get(nodeType.getNodeType()));
                    this.renderers.put(nodeType.getNodeType(), handlerWrapper);
                }
                if (!(nodeRenderer instanceof PhasedNodeRenderer)) continue;
                this.renderingPhases.addAll(((PhasedNodeRenderer)nodeRenderer).getRenderingPhases());
                this.phasedRenderers.add((PhasedNodeRenderer)nodeRenderer);
            }
            for (i = 0; i < HtmlRenderer.this.linkResolverFactories.size(); ++i) {
                this.myLinkResolvers[i] = ((LinkResolverFactory)HtmlRenderer.this.linkResolverFactories.get(i)).create(this);
            }
            this.attributeProviders = new AttributeProvider[HtmlRenderer.this.attributeProviderFactories.size()];
            for (i = 0; i < HtmlRenderer.this.attributeProviderFactories.size(); ++i) {
                this.attributeProviders[i] = ((AttributeProviderFactory)HtmlRenderer.this.attributeProviderFactories.get(i)).create(this);
            }
        }

        @Override
        public Node getCurrentNode() {
            return this.renderingNode;
        }

        @Override
        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Boolean urlEncode) {
            return this.resolveLink(linkType, url, null, urlEncode);
        }

        @Override
        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Attributes attributes, Boolean urlEncode) {
            String urlSeq;
            ResolvedLink resolvedLink;
            HashMap<String, ResolvedLink> resolvedLinks = this.resolvedLinkMap.get(linkType);
            if (resolvedLinks == null) {
                resolvedLinks = new HashMap();
                this.resolvedLinkMap.put(linkType, resolvedLinks);
            }
            if ((resolvedLink = resolvedLinks.get(urlSeq = String.valueOf(url))) == null) {
                resolvedLink = new ResolvedLink(linkType, urlSeq, attributes);
                if (!urlSeq.isEmpty()) {
                    LinkResolver linkResolver;
                    Node currentNode = this.getCurrentNode();
                    LinkResolver[] linkResolverArray = this.myLinkResolvers;
                    int n = linkResolverArray.length;
                    for (int i = 0; i < n && (resolvedLink = (linkResolver = linkResolverArray[i]).resolveLink(currentNode, this, resolvedLink)).getStatus() == LinkStatus.UNKNOWN; ++i) {
                    }
                    if (urlEncode == null && ((HtmlRenderer)HtmlRenderer.this).htmlOptions.percentEncodeUrls || urlEncode != null && urlEncode.booleanValue()) {
                        resolvedLink = resolvedLink.withUrl(Escaping.percentEncodeUrl((CharSequence)resolvedLink.getUrl()));
                    }
                }
                resolvedLinks.put(urlSeq, resolvedLink);
            }
            return resolvedLink;
        }

        @Override
        public String getNodeId(Node node) {
            String id = this.htmlIdGenerator.getId(node);
            if (HtmlRenderer.this.attributeProviderFactories.size() != 0) {
                Attributes attributes = new Attributes();
                if (id != null) {
                    attributes.replaceValue((CharSequence)"id", (CharSequence)id);
                }
                for (AttributeProvider attributeProvider : this.attributeProviders) {
                    attributeProvider.setAttributes(this.renderingNode, AttributablePart.ID, attributes);
                }
                id = attributes.getValue((CharSequence)"id");
            }
            return id;
        }

        @Override
        public DataHolder getOptions() {
            return this.options;
        }

        @Override
        public HtmlRendererOptions getHtmlOptions() {
            return HtmlRenderer.this.htmlOptions;
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public RenderingPhase getRenderingPhase() {
            return this.phase;
        }

        @Override
        public String encodeUrl(CharSequence url) {
            if (((HtmlRenderer)HtmlRenderer.this).htmlOptions.percentEncodeUrls) {
                return Escaping.percentEncodeUrl((CharSequence)url);
            }
            return String.valueOf(url);
        }

        @Override
        public Attributes extendRenderingNodeAttributes(AttributablePart part, Attributes attributes) {
            Attributes attr = attributes != null ? attributes : new Attributes();
            for (AttributeProvider attributeProvider : this.attributeProviders) {
                attributeProvider.setAttributes(this.renderingNode, part, attr);
            }
            return attr;
        }

        @Override
        public Attributes extendRenderingNodeAttributes(Node node, AttributablePart part, Attributes attributes) {
            Attributes attr = attributes != null ? attributes : new Attributes();
            for (AttributeProvider attributeProvider : this.attributeProviders) {
                attributeProvider.setAttributes(node, part, attr);
            }
            return attr;
        }

        @Override
        public void render(Node node) {
            this.renderNode(node, this);
        }

        @Override
        public void delegateRender() {
            this.renderByPreviousHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderByPreviousHandler(NodeRendererSubContext subContext) {
            if (subContext.renderingNode != null) {
                NodeRenderingHandlerWrapper nodeRenderer = subContext.renderingHandlerWrapper.myPreviousRenderingHandler;
                if (nodeRenderer != null) {
                    Node oldNode = subContext.renderingNode;
                    int oldDoNotRenderLinksNesting = subContext.doNotRenderLinksNesting;
                    NodeRenderingHandlerWrapper prevWrapper = subContext.renderingHandlerWrapper;
                    try {
                        subContext.renderingHandlerWrapper = nodeRenderer;
                        nodeRenderer.myRenderingHandler.render(oldNode, (NodeRendererContext)subContext, subContext.htmlWriter);
                    }
                    finally {
                        subContext.renderingNode = oldNode;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                        subContext.renderingHandlerWrapper = prevWrapper;
                    }
                }
            } else {
                throw new IllegalStateException("renderingByPreviousHandler called outside node rendering code");
            }
        }

        @Override
        public NodeRendererContext getSubContext(Appendable out, boolean inheritIndent) {
            HtmlWriter htmlWriter = new HtmlWriter(this.getHtmlWriter(), out, inheritIndent);
            htmlWriter.setContext(this);
            return new SubNodeRenderer(this, htmlWriter, false);
        }

        @Override
        public NodeRendererContext getDelegatedSubContext(Appendable out, boolean inheritIndent) {
            HtmlWriter htmlWriter = new HtmlWriter(this.getHtmlWriter(), out, inheritIndent);
            htmlWriter.setContext(this);
            return new SubNodeRenderer(this, htmlWriter, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderNode(Node node, NodeRendererSubContext subContext) {
            if (node instanceof Document) {
                int oldDoNotRenderLinksNesting = subContext.getDoNotRenderLinksNesting();
                int documentDoNotRenderLinksNesting = this.getHtmlOptions().doNotRenderLinksInDocument ? 1 : 0;
                this.htmlIdGenerator.generateIds(this.document);
                for (RenderingPhase phase : RenderingPhase.values()) {
                    NodeRenderingHandlerWrapper nodeRenderer;
                    if (phase != RenderingPhase.BODY && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    for (PhasedNodeRenderer phasedRenderer : this.phasedRenderers) {
                        if (!phasedRenderer.getRenderingPhases().contains((Object)phase)) continue;
                        subContext.doNotRenderLinksNesting = documentDoNotRenderLinksNesting;
                        subContext.renderingNode = node;
                        phasedRenderer.renderDocument(subContext, subContext.htmlWriter, (Document)node, phase);
                        subContext.renderingNode = null;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                    }
                    if (this.getRenderingPhase() != RenderingPhase.BODY || (nodeRenderer = this.renderers.get(node.getClass())) == null) continue;
                    subContext.doNotRenderLinksNesting = documentDoNotRenderLinksNesting;
                    NodeRenderingHandlerWrapper prevWrapper = subContext.renderingHandlerWrapper;
                    try {
                        subContext.renderingNode = node;
                        subContext.renderingHandlerWrapper = nodeRenderer;
                        nodeRenderer.myRenderingHandler.render(node, (NodeRendererContext)subContext, subContext.htmlWriter);
                    }
                    finally {
                        subContext.renderingHandlerWrapper = prevWrapper;
                        subContext.renderingNode = null;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                    }
                }
            } else {
                NodeRenderingHandlerWrapper nodeRenderer = this.renderers.get(node.getClass());
                if (nodeRenderer != null) {
                    Node oldNode = this.renderingNode;
                    int oldDoNotRenderLinksNesting = subContext.doNotRenderLinksNesting;
                    NodeRenderingHandlerWrapper prevWrapper = subContext.renderingHandlerWrapper;
                    try {
                        subContext.renderingNode = node;
                        subContext.renderingHandlerWrapper = nodeRenderer;
                        nodeRenderer.myRenderingHandler.render(node, (NodeRendererContext)subContext, subContext.htmlWriter);
                    }
                    finally {
                        subContext.renderingNode = oldNode;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                        subContext.renderingHandlerWrapper = prevWrapper;
                    }
                }
            }
        }

        @Override
        public void renderChildren(Node parent) {
            this.renderChildrenNode(parent, this);
        }

        protected void renderChildrenNode(Node parent, NodeRendererSubContext subContext) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                this.renderNode(node, subContext);
                node = next;
            }
        }

        private class SubNodeRenderer
        extends NodeRendererSubContext
        implements NodeRendererContext {
            private final MainNodeRenderer myMainNodeRenderer;

            public SubNodeRenderer(MainNodeRenderer mainNodeRenderer2, HtmlWriter htmlWriter, boolean inheritCurrentHandler) {
                super(htmlWriter);
                this.myMainNodeRenderer = mainNodeRenderer2;
                int n = this.doNotRenderLinksNesting = mainNodeRenderer2.getHtmlOptions().doNotRenderLinksInDocument ? 1 : 0;
                if (inheritCurrentHandler) {
                    this.renderingNode = mainNodeRenderer2.renderingNode;
                    this.renderingHandlerWrapper = mainNodeRenderer2.renderingHandlerWrapper;
                }
            }

            @Override
            public String getNodeId(Node node) {
                return this.myMainNodeRenderer.getNodeId(node);
            }

            @Override
            public DataHolder getOptions() {
                return this.myMainNodeRenderer.getOptions();
            }

            @Override
            public HtmlRendererOptions getHtmlOptions() {
                return this.myMainNodeRenderer.getHtmlOptions();
            }

            @Override
            public Document getDocument() {
                return this.myMainNodeRenderer.getDocument();
            }

            @Override
            public RenderingPhase getRenderingPhase() {
                return this.myMainNodeRenderer.getRenderingPhase();
            }

            @Override
            public String encodeUrl(CharSequence url) {
                return this.myMainNodeRenderer.encodeUrl(url);
            }

            @Override
            public Attributes extendRenderingNodeAttributes(AttributablePart part, Attributes attributes) {
                return this.myMainNodeRenderer.extendRenderingNodeAttributes(part, attributes);
            }

            @Override
            public Attributes extendRenderingNodeAttributes(Node node, AttributablePart part, Attributes attributes) {
                return this.myMainNodeRenderer.extendRenderingNodeAttributes(node, part, attributes);
            }

            @Override
            public void render(Node node) {
                this.myMainNodeRenderer.renderNode(node, this);
            }

            @Override
            public void delegateRender() {
                this.myMainNodeRenderer.renderByPreviousHandler(this);
            }

            @Override
            public Node getCurrentNode() {
                return this.myMainNodeRenderer.getCurrentNode();
            }

            @Override
            public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(linkType, url, urlEncode);
            }

            @Override
            public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Attributes attributes, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(linkType, url, attributes, urlEncode);
            }

            @Override
            public NodeRendererContext getSubContext(Appendable out, boolean inheritIndent) {
                HtmlWriter htmlWriter = new HtmlWriter(this.htmlWriter, out, inheritIndent);
                htmlWriter.setContext(this);
                return new SubNodeRenderer(this.myMainNodeRenderer, htmlWriter, false);
            }

            @Override
            public NodeRendererContext getDelegatedSubContext(Appendable out, boolean inheritIndent) {
                HtmlWriter htmlWriter = new HtmlWriter(this.htmlWriter, out, inheritIndent);
                htmlWriter.setContext(this);
                return new SubNodeRenderer(this.myMainNodeRenderer, htmlWriter, true);
            }

            @Override
            public void renderChildren(Node parent) {
                this.myMainNodeRenderer.renderChildrenNode(parent, this);
            }

            @Override
            public HtmlWriter getHtmlWriter() {
                return this.htmlWriter;
            }

            @Override
            protected int getDoNotRenderLinksNesting() {
                return super.getDoNotRenderLinksNesting();
            }

            @Override
            public boolean isDoNotRenderLinks() {
                return super.isDoNotRenderLinks();
            }

            @Override
            public void doNotRenderLinks(boolean doNotRenderLinks) {
                super.doNotRenderLinks(doNotRenderLinks);
            }

            @Override
            public void doNotRenderLinks() {
                super.doNotRenderLinks();
            }

            @Override
            public void doRenderLinks() {
                super.doRenderLinks();
            }
        }
    }

    private static class RendererDependencyHandler
    extends DependencyHandler<DelegatingNodeRendererFactoryWrapper, RendererDependencyStage, RendererDependencies> {
        private RendererDependencyHandler() {
        }

        protected Class getDependentClass(DelegatingNodeRendererFactoryWrapper dependent) {
            return dependent.getFactory().getClass();
        }

        protected RendererDependencies createResolvedDependencies(List<RendererDependencyStage> stages) {
            return new RendererDependencies(stages);
        }

        protected RendererDependencyStage createStage(List<DelegatingNodeRendererFactoryWrapper> dependents) {
            return new RendererDependencyStage(dependents);
        }
    }

    public static class RendererDependencies
    extends ResolvedDependencies<RendererDependencyStage> {
        private final List<DelegatingNodeRendererFactoryWrapper> nodeRendererFactories;

        public RendererDependencies(List<RendererDependencyStage> dependentStages) {
            super(dependentStages);
            ArrayList<DelegatingNodeRendererFactoryWrapper> blockPreProcessorFactories = new ArrayList<DelegatingNodeRendererFactoryWrapper>();
            for (RendererDependencyStage stage : dependentStages) {
                blockPreProcessorFactories.addAll(stage.dependents);
            }
            this.nodeRendererFactories = blockPreProcessorFactories;
        }

        public List<DelegatingNodeRendererFactoryWrapper> getNodeRendererFactories() {
            return this.nodeRendererFactories;
        }
    }

    public static class RendererDependencyStage {
        private final List<DelegatingNodeRendererFactoryWrapper> dependents;

        public RendererDependencyStage(List<DelegatingNodeRendererFactoryWrapper> dependents) {
            this.dependents = dependents;
        }
    }

    public static interface HtmlRendererExtension
    extends Extension {
        public void rendererOptions(MutableDataHolder var1);

        public void extend(Builder var1, String var2);
    }

    public static class Builder
    extends BuilderBase<Builder>
    implements RendererBuilder {
        Map<Class, AttributeProviderFactory> attributeProviderFactories = new LinkedHashMap<Class, AttributeProviderFactory>();
        List<NodeRendererFactory> nodeRendererFactories = new ArrayList<NodeRendererFactory>();
        List<LinkResolverFactory> linkResolverFactories = new ArrayList<LinkResolverFactory>();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(DataHolder options) {
            super(options);
            this.loadExtensions();
        }

        public Builder(Builder other) {
            super((BuilderBase)other);
            this.attributeProviderFactories.putAll(other.attributeProviderFactories);
            this.linkResolverFactories.addAll(other.linkResolverFactories);
            this.htmlIdGeneratorFactory = other.htmlIdGeneratorFactory;
        }

        public Builder(Builder other, DataHolder options) {
            this(other);
            this.withOptions(options);
        }

        protected void removeApiPoint(Object apiPoint) {
            if (apiPoint instanceof AttributeProviderFactory) {
                this.attributeProviderFactories.remove(apiPoint.getClass());
            } else if (apiPoint instanceof NodeRendererFactory) {
                this.nodeRendererFactories.remove(apiPoint);
            } else if (apiPoint instanceof LinkResolverFactory) {
                this.linkResolverFactories.remove(apiPoint);
            } else if (apiPoint instanceof HeaderIdGeneratorFactory) {
                this.htmlIdGeneratorFactory = null;
            } else {
                throw new IllegalStateException("Unknown data point type: " + apiPoint.getClass().getName());
            }
        }

        protected void preloadExtension(Extension extension) {
            if (extension instanceof HtmlRendererExtension) {
                HtmlRendererExtension htmlRendererExtension = (HtmlRendererExtension)extension;
                htmlRendererExtension.rendererOptions((MutableDataHolder)this);
            } else if (extension instanceof RendererExtension) {
                RendererExtension htmlRendererExtension = (RendererExtension)extension;
                htmlRendererExtension.rendererOptions((MutableDataHolder)this);
            }
        }

        protected boolean loadExtension(Extension extension) {
            if (extension instanceof HtmlRendererExtension) {
                HtmlRendererExtension htmlRendererExtension = (HtmlRendererExtension)extension;
                htmlRendererExtension.extend(this, (String)this.get(TYPE));
                return true;
            }
            if (extension instanceof RendererExtension) {
                RendererExtension htmlRendererExtension = (RendererExtension)extension;
                htmlRendererExtension.extend(this, (String)this.get(TYPE));
                return true;
            }
            return false;
        }

        public HtmlRenderer build() {
            return new HtmlRenderer(this);
        }

        public Builder softBreak(String softBreak) {
            this.set(SOFT_BREAK, softBreak);
            return this;
        }

        public Builder indentSize(int indentSize) {
            this.set(INDENT_SIZE, indentSize);
            return this;
        }

        public Builder escapeHtml(boolean escapeHtml) {
            this.set(ESCAPE_HTML, escapeHtml);
            return this;
        }

        public boolean isRendererType(String supportedRendererType) {
            String rendererType = (String)TYPE.getFrom((DataHolder)this);
            return HtmlRenderer.isCompatibleRendererType((MutableDataHolder)this, rendererType, supportedRendererType);
        }

        public Builder percentEncodeUrls(boolean percentEncodeUrls) {
            this.set(PERCENT_ENCODE_URLS, percentEncodeUrls);
            return this;
        }

        @Override
        public Builder attributeProviderFactory(AttributeProviderFactory attributeProviderFactory) {
            this.attributeProviderFactories.put(attributeProviderFactory.getClass(), attributeProviderFactory);
            this.addExtensionApiPoint(attributeProviderFactory);
            return this;
        }

        public Builder nodeRendererFactory(NodeRendererFactory nodeRendererFactory) {
            this.nodeRendererFactories.add(nodeRendererFactory);
            this.addExtensionApiPoint(nodeRendererFactory);
            return this;
        }

        @Override
        public Builder linkResolverFactory(LinkResolverFactory linkResolverFactory) {
            this.linkResolverFactories.add(linkResolverFactory);
            this.addExtensionApiPoint(linkResolverFactory);
            return this;
        }

        @Override
        public Builder htmlIdGeneratorFactory(HeaderIdGeneratorFactory htmlIdGeneratorFactory) {
            if (this.htmlIdGeneratorFactory != null) {
                throw new IllegalStateException("custom header id factory is already set to " + htmlIdGeneratorFactory.getClass().getName());
            }
            this.htmlIdGeneratorFactory = htmlIdGeneratorFactory;
            this.addExtensionApiPoint(htmlIdGeneratorFactory);
            return this;
        }
    }
}

