/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.ModuleInfoParser;

public abstract class AbstractBinaryModuleInfoParser
implements ModuleInfoParser {
    private static final Pattern MRJAR_DESCRIPTOR = Pattern.compile("META-INF/versions/[^/]+/module-info.class");

    @Override
    public JavaModuleDescriptor getModuleDescriptor(Path modulePath) throws IOException {
        JavaModuleDescriptor descriptor;
        if (Files.isDirectory(modulePath, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(modulePath.resolve("module-info.class"), new OpenOption[0]);){
                descriptor = this.parse(in);
            }
        }
        try (JarFile jarFile = new JarFile(modulePath.toFile());){
            JarEntry moduleInfo;
            if (modulePath.toString().toLowerCase().endsWith(".jmod")) {
                moduleInfo = jarFile.getJarEntry("classes/module-info.class");
            } else {
                Manifest manifest;
                moduleInfo = jarFile.getJarEntry("module-info.class");
                if (moduleInfo == null && (manifest = jarFile.getManifest()) != null && "true".equalsIgnoreCase(manifest.getMainAttributes().getValue("Multi-Release"))) {
                    Enumeration<JarEntry> entryIter = jarFile.entries();
                    while (entryIter.hasMoreElements()) {
                        JarEntry entry = entryIter.nextElement();
                        if (!MRJAR_DESCRIPTOR.matcher(entry.getName()).matches()) continue;
                        moduleInfo = entry;
                        break;
                    }
                }
            }
            descriptor = moduleInfo != null ? this.parse(jarFile.getInputStream(moduleInfo)) : null;
        }
        return descriptor;
    }

    abstract JavaModuleDescriptor parse(InputStream var1) throws IOException;
}

