/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantEmptyArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedIntArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public final class ConstantIntArray
extends AbstractConstantArray {
    private static final ConstantIntArray CONSTANT_INT_ARRAY = new ConstantIntArray(0, ConstantIntArray.createCache());

    public static ConstantIntArray createConstantIntArray() {
        return CONSTANT_INT_ARRAY;
    }

    private ConstantIntArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public Object getElementInBounds(DynamicObject object, int index, boolean condition) {
        return ConstantIntArray.getElementInt(object, index, condition);
    }

    public static int getElementInt(DynamicObject object, int index, boolean condition) {
        return ConstantIntArray.getArray(object, condition)[index];
    }

    private static int[] getArray(DynamicObject object) {
        return (int[])JSAbstractArray.arrayGetArray(object);
    }

    public static int[] getArray(DynamicObject object, boolean condition) {
        return (int[])JSAbstractArray.arrayGetArray(object, condition);
    }

    @Override
    public int lengthInt(DynamicObject object, boolean condition) {
        return ConstantIntArray.getArray(object, condition).length;
    }

    @Override
    public boolean hasElement(DynamicObject object, long index, boolean condition) {
        return index >= 0L && index < (long)ConstantIntArray.getArray(object, condition).length;
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        return ArrayCopy.intToObject(ConstantIntArray.getArray(object));
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.createWriteableInt(object, index, Integer.MIN_VALUE, condition, ScriptArray.ProfileHolder.empty()).deleteElementImpl(object, index, strict, condition);
    }

    @Override
    public ScriptArray setLengthImpl(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableInt(object, length - 1L, Integer.MIN_VALUE, condition, ScriptArray.ProfileHolder.empty()).setLengthImpl(object, length, condition, profile);
    }

    @Override
    public AbstractIntArray createWriteableInt(DynamicObject object, long index, int value, boolean condition, ScriptArray.ProfileHolder profile) {
        int[] copyArray = ArrayCopy.intToInt(ConstantIntArray.getArray(object, condition));
        ZeroBasedIntArray newArray = ZeroBasedIntArray.makeZeroBasedIntArray(object, copyArray.length, copyArray.length, copyArray, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ConstantIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray createWriteableDouble(DynamicObject object, long index, double value, boolean condition, ScriptArray.ProfileHolder profile) {
        double[] copyArray = ArrayCopy.intToDouble(ConstantIntArray.getArray(object, condition));
        ZeroBasedDoubleArray newArray = ZeroBasedDoubleArray.makeZeroBasedDoubleArray(object, copyArray.length, copyArray.length, copyArray, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ConstantIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray createWriteableJSObject(DynamicObject object, long index, DynamicObject value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, condition, ScriptArray.ProfileHolder.empty());
    }

    @Override
    public AbstractWritableArray createWriteableObject(DynamicObject object, long index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        Object[] copyArray = ArrayCopy.intToObject(ConstantIntArray.getArray(object, condition));
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, copyArray.length, copyArray.length, copyArray, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ConstantIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        int[] array = ConstantIntArray.getArray(object);
        if ((long)array.length - (end - start) == 0L) {
            AbstractConstantEmptyArray.setCapacity(object, 0L);
        } else {
            int[] newArray = new int[array.length - (int)(end - start)];
            System.arraycopy(array, 0, newArray, 0, (int)start);
            System.arraycopy(array, (int)end, newArray, (int)start, (int)((long)array.length - end));
            JSAbstractArray.arraySetArray(object, newArray);
        }
        return this;
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        int[] array = ConstantIntArray.getArray(object);
        if (array.length == 0) {
            AbstractConstantEmptyArray.setCapacity(object, size);
            return this;
        }
        int[] newArray = new int[array.length + size];
        System.arraycopy(array, 0, newArray, 0, (int)offset);
        System.arraycopy(array, (int)offset, newArray, (int)offset + size, (int)((long)array.length - offset));
        JSAbstractArray.arraySetArray(object, newArray);
        return this;
    }

    @Override
    protected DynamicArray withIntegrityLevel(int newIntegrityLevel) {
        return new ConstantIntArray(newIntegrityLevel, this.cache);
    }
}

