/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.polyglot.DefaultScope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

@ExportLibrary(value=InteropLibrary.class)
final class PolyglotLanguageBindings
implements TruffleObject {
    final Object[] scopes;

    private PolyglotLanguageBindings(Object[] scopes) {
        this.scopes = scopes;
    }

    static Object create(Iterable<Scope> scopes) {
        Iterator<Scope> scope = scopes.iterator();
        Object firstScope = null;
        ArrayList<Object> otherScopes = null;
        while (scope.hasNext()) {
            Object variables = scope.next().getVariables();
            assert (InteropLibrary.getFactory().getUncached().hasMembers(variables)) : "Variables object must return true for isObject().";
            if (firstScope == null) {
                firstScope = variables;
                continue;
            }
            if (otherScopes == null) {
                otherScopes = new ArrayList<Object>(4);
                otherScopes.add(firstScope);
            }
            otherScopes.add(variables);
        }
        if (otherScopes == null) {
            return firstScope;
        }
        return new PolyglotLanguageBindings(otherScopes.toArray());
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
        assert (this.scopes.length != 1) : "should be handled by create()";
        HashSet<String> keySet = new HashSet<String>();
        InteropLibrary interopDispatch = InteropLibrary.getFactory().getUncached();
        for (Object scope : this.scopes) {
            Object members = interopDispatch.getMembers(scope, includeInternal);
            InteropLibrary membersLibrary = InteropLibrary.getFactory().getUncached(members);
            long size = membersLibrary.getArraySize(members);
            for (long i = 0L; i < size; ++i) {
                try {
                    keySet.add(interopDispatch.asString(membersLibrary.readArrayElement(members, i)));
                    continue;
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException interopException) {
                    // empty catch block
                }
            }
        }
        return new DefaultScope.VariableNamesObject(keySet);
    }

    @ExportMessage
    boolean isMemberReadable(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
        int length = lengthProfile.profile(this.scopes.length);
        for (int i = 0; i < length; ++i) {
            Object scope = this.scopes[i];
            if (!interop.isMemberReadable(scope, member)) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    Object readMember(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) throws UnknownIdentifierException {
        int length = lengthProfile.profile(this.scopes.length);
        for (int i = 0; i < length; ++i) {
            Object scope = this.scopes[i];
            if (!interop.isMemberReadable(scope, member)) continue;
            try {
                return interop.readMember(scope, member);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException interopException) {
                // empty catch block
            }
        }
        throw UnknownIdentifierException.create(member);
    }

    @ExportMessage
    boolean isMemberModifiable(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
        int length = lengthProfile.profile(this.scopes.length);
        for (int i = 0; i < length; ++i) {
            Object scope = this.scopes[i];
            if (!interop.isMemberModifiable(scope, member)) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    boolean isMemberInsertable(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
        int length = lengthProfile.profile(this.scopes.length);
        boolean wasInsertable = false;
        for (int i = 0; i < length; ++i) {
            Object scope = this.scopes[i];
            if (interop.isMemberExisting(scope, member)) {
                return false;
            }
            if (!interop.isMemberInsertable(scope, member)) continue;
            wasInsertable = true;
        }
        return wasInsertable;
    }

    @ExportMessage
    void writeMember(String member, Object value, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
        int length = lengthProfile.profile(this.scopes.length);
        Object firstInsertableScope = null;
        for (int i = 0; i < length; ++i) {
            Object scope = this.scopes[i];
            if (interop.isMemberExisting(scope, member)) {
                if (interop.isMemberModifiable(scope, member)) {
                    interop.writeMember(scope, member, value);
                    return;
                }
                throw UnsupportedMessageException.create();
            }
            if (!interop.isMemberInsertable(scope, member) || firstInsertableScope != null) continue;
            firstInsertableScope = scope;
        }
        if (firstInsertableScope != null) {
            interop.writeMember(firstInsertableScope, member, value);
            return;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    void removeMember(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) throws UnsupportedMessageException, UnknownIdentifierException {
        int length = lengthProfile.profile(this.scopes.length);
        for (int i = 0; i < length; ++i) {
            Object scope = this.scopes[i];
            if (interop.isMemberRemovable(scope, member)) {
                interop.removeMember(scope, member);
                return;
            }
            if (!interop.isMemberExisting(scope, member)) continue;
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    boolean isMemberRemovable(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
        int length = lengthProfile.profile(this.scopes.length);
        for (int i = 0; i < length; ++i) {
            Object scope = this.scopes[i];
            if (interop.isMemberRemovable(scope, member)) {
                return true;
            }
            if (!interop.isMemberExisting(scope, member)) continue;
            return false;
        }
        return false;
    }
}

