.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP SEQUENCE" "" "2013-02-04" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP SEQUENCE \- remove a sequence

.SH SYNOPSIS
.sp
.nf
DROP SEQUENCE [ IF EXISTS ] \fIname\fR [, ...] [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP SEQUENCE\fR removes sequence number
generators. A sequence can only be dropped by its owner or a superuser.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the sequence does not exist. A notice is issued 
in this case.
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of a sequence.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the sequence.
.TP
\fBRESTRICT\fR
Refuse to drop the sequence if any objects depend on it. This
is the default.
.SH "EXAMPLES"
.PP
To remove the sequence serial:
.sp
.nf
DROP SEQUENCE serial;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBDROP SEQUENCE\fR conforms to the SQL
standard, except that the standard only allows one
sequence to be dropped per command, and apart from the 
IF EXISTS option, which is a PostgreSQL 
extension. 
.SH "SEE ALSO"
CREATE SEQUENCE [\fBcreate_sequence\fR(l)], ALTER SEQUENCE [\fBalter_sequence\fR(l)]
