#!/bin/sh

# This script is used for running Bison & Flex because it does some more
# processing by replacing an include in Flex & Bison generated source files
# and by moving Bison includes to the include directory.

# Parameters for the script
INCLUDEDIR="include/pgscript"
BASEDIR="pgscript"
FILESTOMOVE=( "location.hh" "parser.tab.hh" "position.hh" "stack.hh" )

LEXER="pgscript/lex.pgs.cc"
AUX="auxfile"
PARSER="pgscript/parser.tab.cc"

# Generates Bison file
echo -n "Generating Bison output... "
bison -o"$PARSER" $BASEDIR/pgsParser.yy
echo "done"
echo ""

# Generates Flex file
echo -n "Generating Flex output... "
flex -o"$LEXER" $BASEDIR/pgsScanner.ll
echo "done"
echo ""

# Changes <FlexLexer.h> to "pgscript/FlexLexer.h"
# Add pgAdmin3.h include at the beginning
echo -n "Processing Flex output... "
cat $LEXER | awk 'BEGIN {print "#include \"pgAdmin3.h\"\n\n"}{print $0}' | sed -e 's/<FlexLexer\.h>/"pgscript\/FlexLexer\.h"/g' > $AUX
rm $LEXER
mv $AUX $LEXER
echo "done"
echo ""

# Changes "parser.tab.hh" to "pgscript/parser.tab.hh"
# Add pgAdmin3.h include at the beginning
echo -n "Processing Bison output... "
cat $PARSER | awk 'BEGIN {print "#include \"pgAdmin3.h\"\n#if _MSC_VER > 1000\n#pragma warning(disable: 4800)\n#endif\n"}{print $0}' | \
	sed -e 's/"parser.tab.hh"/"pgscript\/parser\.tab\.hh"/g' > $AUX
rm $PARSER
mv $AUX $PARSER
echo "done"
echo ""

# Move Bison include files to the include directory
echo "Moving Bison header files... "
for file in ${FILESTOMOVE[@]}
do
	echo "  mv $BASEDIR/$file $INCLUDEDIR/$file"
	mv "$BASEDIR/$file" "$INCLUDEDIR/$file"
done
echo "done"
