/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitExpr;
import uk.me.nxg.unity.UnitParserException;
import uk.me.nxg.unity.UnitWriter;

class UnitWriterOgip
extends UnitWriter {
    public UnitWriterOgip(UnitExpr unitExpr) {
        super(unitExpr);
    }

    @Override
    public String write() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        try {
            if (this.ue.getLogFactor() != 0.0) {
                stringBuilder.append("10**");
                this.writeNumber(stringBuilder, this.ue.getLogFactor());
                bl = false;
            }
            for (OneUnit oneUnit : this.ue) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(' ');
                }
                double d = oneUnit.getExponent();
                if (d == 1.0) {
                    stringBuilder.append(oneUnit.unitString(Syntax.OGIP));
                    continue;
                }
                if (d < 0.0) {
                    stringBuilder.append('/').append(oneUnit.unitString(Syntax.OGIP));
                    if (d == -1.0) continue;
                    stringBuilder.append("**");
                    this.writeNumber(stringBuilder, -d);
                    continue;
                }
                stringBuilder.append(oneUnit.unitString(Syntax.OGIP)).append("**");
                this.writeNumber(stringBuilder, d);
            }
            return stringBuilder.toString();
        }
        catch (UnitParserException unitParserException) {
            throw new AssertionError((Object)("units system failed to recognise built-in syntax OGIP: " + unitParserException));
        }
    }

    void writeNumber(StringBuilder stringBuilder, double d) {
        this.writeNumber(stringBuilder, d, true, true, true, false);
    }
}

