<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# G for Lanczos Approximation

> Arbitrary constant `g` to be used in Lanczos approximation functions.

<section class="intro">

</section>

<!-- /.intro -->

<section class="usage">

## Usage

```javascript
var FLOAT64_GAMMA_LANCZOS_G = require( '@stdlib/constants/float64/gamma-lanczos-g' );
```

#### FLOAT64_GAMMA_LANCZOS_G

Arbitrary constant `g` to be used in [Lanczos approximation][lanczos-approximation] functions.

```javascript
var bool = ( FLOAT64_GAMMA_LANCZOS_G === 10.900511 );
// returns true
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- eslint no-undef: "error" -->

```javascript
var FLOAT64_GAMMA_LANCZOS_G = require( '@stdlib/constants/float64/gamma-lanczos-g' );

console.log( FLOAT64_GAMMA_LANCZOS_G );
// => 10.900511
```

</section>

<!-- /.examples -->

* * *

<section class="references">

## References

-   Pugh, Glendon R. 2004. "An analysis of the Lanczos gamma approximation." PhD thesis, University of British Columbia. [&lt;https://web.viu.ca/pughg/phdThesis/phdThesis.pdf>][@pugh:2004a].

</section>

<!-- /.references -->

<section class="links">

[lanczos-approximation]: https://en.wikipedia.org/wiki/Lanczos_approximation

[@pugh:2004a]: https://web.viu.ca/pughg/phdThesis/phdThesis.pdf

</section>

<!-- /.links -->
