/*
 * Copyright (C) Mellanox Technologies Ltd. 2019. ALL RIGHTS RESERVED.
 * See file LICENSE for terms.
 */

#include "org_openucx_jucx_ucs_UcsConstants.h"
#include "jucx_common_def.h"

#include <ucs/type/thread_mode.h>

JNIEXPORT void JNICALL
Java_org_openucx_jucx_ucs_UcsConstants_loadConstants(JNIEnv *env, jclass ucs_class)
{
    jclass thread_mode = env->FindClass("org/openucx/jucx/ucs/UcsConstants$ThreadMode");
    jfieldID field = env->GetStaticFieldID(thread_mode, "UCS_THREAD_MODE_MULTI", "I");
    env->SetStaticIntField(thread_mode, field, UCS_THREAD_MODE_MULTI);

    jclass cls = env->FindClass("org/openucx/jucx/ucs/UcsConstants$STATUS");

    /* Operation completed successfully */
    JUCX_DEFINE_INT_CONSTANT(UCS_OK);

    /* Operation is queued and stil in progress */
    JUCX_DEFINE_INT_CONSTANT(UCS_INPROGRESS);
    /* Failure codes */
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_NO_MESSAGE);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_NO_RESOURCE);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_IO_ERROR);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_NO_MEMORY);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_INVALID_PARAM);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_UNREACHABLE);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_INVALID_ADDR);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_NOT_IMPLEMENTED);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_MESSAGE_TRUNCATED);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_NO_PROGRESS);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_BUFFER_TOO_SMALL);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_NO_ELEM);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_SOME_CONNECTS_FAILED);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_NO_DEVICE);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_BUSY);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_CANCELED);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_SHMEM_SEGMENT);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_ALREADY_EXISTS);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_OUT_OF_RANGE);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_TIMED_OUT);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_EXCEEDS_LIMIT);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_UNSUPPORTED);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_REJECTED);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_NOT_CONNECTED);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_CONNECTION_RESET);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_FIRST_LINK_FAILURE);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_LAST_LINK_FAILURE);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_FIRST_ENDPOINT_FAILURE);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_ENDPOINT_TIMEOUT);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_LAST_ENDPOINT_FAILURE);
    JUCX_DEFINE_INT_CONSTANT(UCS_ERR_LAST);

    // Memory type
    cls = env->FindClass("org/openucx/jucx/ucs/UcsConstants$MEMORY_TYPE");
    JUCX_DEFINE_INT_CONSTANT(UCS_MEMORY_TYPE_HOST);
    JUCX_DEFINE_INT_CONSTANT(UCS_MEMORY_TYPE_CUDA);
    JUCX_DEFINE_INT_CONSTANT(UCS_MEMORY_TYPE_CUDA_MANAGED);
    JUCX_DEFINE_INT_CONSTANT(UCS_MEMORY_TYPE_ROCM);
    JUCX_DEFINE_INT_CONSTANT(UCS_MEMORY_TYPE_ROCM_MANAGED);
    JUCX_DEFINE_INT_CONSTANT(UCS_MEMORY_TYPE_LAST);
    JUCX_DEFINE_INT_CONSTANT(UCS_MEMORY_TYPE_UNKNOWN);
}
