/*
 * libkysdk-qtwidgets's Library
 *
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhen Sun <sunzhen1@kylinos.cn>
 *
 */

#include "ksecuritylevelbar.h"
#include "themeController.h"
#include <QBoxLayout>
#include <QDebug>
#include <QLabel>
#include <QPainter>
#include <QPalette>
#include "accessinfohelper.h"

namespace kdk
{
class KSecurityLevelBarPrivate : public QObject
{
    Q_OBJECT
    Q_DECLARE_PUBLIC(KSecurityLevelBar)
public:
    KSecurityLevelBarPrivate(KSecurityLevelBar *parent);

private:
    KSecurityLevelBar *q_ptr;
    SecurityLevel m_level;
    QLabel *m_pLabel;
    int m_contentMargin = 5;
    int m_textWidth = 0;
    int m_space = 5;
};

KSecurityLevelBar::KSecurityLevelBar(QWidget *parent)
    : QWidget(parent)
    , d_ptr(new KSecurityLevelBarPrivate(this))
{
    Q_D(KSecurityLevelBar);
    setFixedSize(300, 30);
}

void KSecurityLevelBar::setSecurityLevel(SecurityLevel level)
{
    Q_D(KSecurityLevelBar);
    d->m_level = level;
    switch (level) {
    case Low:
        d->m_pLabel->setText(tr("Low"));
        break;
    case Medium:
        d->m_pLabel->setText(tr("Medium"));
        break;
    case High:
        d->m_pLabel->setText(tr("High"));
        break;
    default:
        break;
    }
    repaint();
}

SecurityLevel KSecurityLevelBar::securityLevel()
{
    Q_D(KSecurityLevelBar);
    return d->m_level;
}

void KSecurityLevelBar::paintEvent(QPaintEvent *event)
{
    Q_D(KSecurityLevelBar);
    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing);
    painter.setPen(Qt::NoPen);
    d->m_pLabel->adjustSize();
    d->m_textWidth = this->fontMetrics().horizontalAdvance(d->m_pLabel->text()) + d->m_space;
    int rectWitdth = 32; //(rect().width() - d->m_textWidth - d->m_contentMargin * 2) / 3 - d->m_space;
    int rectHeight = 8; /*height() > 6 ? 6 : height();*/
    int currentPos = d->m_contentMargin + d->m_textWidth + d->m_space;
    switch (d->m_level) {
    case Low:
        painter.setBrush(ThemeController::getCustomColorFromDT("kerror-normal"));
        painter.drawRoundedRect(currentPos, (rect().height() - rectHeight) / 2, rectWitdth, rectHeight, rectHeight / 2, rectHeight / 2);
        currentPos = currentPos + d->m_space + rectWitdth;
        painter.setBrush(ThemeController::getCustomColorFromDT("kcomponent-normal"));
        painter.drawRoundedRect(currentPos, (rect().height() - rectHeight) / 2, rectWitdth, rectHeight, rectHeight / 2, rectHeight / 2);
        currentPos = currentPos + d->m_space + rectWitdth;
        painter.drawRoundedRect(currentPos, (rect().height() - rectHeight) / 2, rectWitdth, rectHeight, rectHeight / 2, rectHeight / 2);
        break;
    case Medium:
        painter.setBrush(ThemeController::getCustomColorFromDT("kwarning-normal"));
        painter.drawRoundedRect(currentPos, (rect().height() - rectHeight) / 2, rectWitdth, rectHeight, rectHeight / 2, rectHeight / 2);
        currentPos = currentPos + d->m_space + rectWitdth;
        painter.drawRoundedRect(currentPos, (rect().height() - rectHeight) / 2, rectWitdth, rectHeight, rectHeight / 2, rectHeight / 2);
        currentPos = currentPos + d->m_space + rectWitdth;
        painter.setBrush(ThemeController::getCustomColorFromDT("kcomponent-normal"));
        painter.drawRoundedRect(currentPos, (rect().height() - rectHeight) / 2, rectWitdth, rectHeight, rectHeight / 2, rectHeight / 2);
        break;
    case High:
        painter.setBrush(ThemeController::getCustomColorFromDT("ksuccess-normal"));
        painter.drawRoundedRect(currentPos, (rect().height() - rectHeight) / 2, rectWitdth, rectHeight, rectHeight / 2, rectHeight / 2);
        currentPos = currentPos + d->m_space + rectWitdth;
        painter.drawRoundedRect(currentPos, (rect().height() - rectHeight) / 2, rectWitdth, rectHeight, rectHeight / 2, rectHeight / 2);
        currentPos = currentPos + d->m_space + rectWitdth;
        painter.drawRoundedRect(currentPos, (rect().height() - rectHeight) / 2, rectWitdth, rectHeight, rectHeight / 2, rectHeight / 2);
        break;
    default:
        break;
    }
}

KSecurityLevelBarPrivate::KSecurityLevelBarPrivate(KSecurityLevelBar *parent)
    : q_ptr(parent)
{
    Q_Q(KSecurityLevelBar);
    m_pLabel = new QLabel(q);
    m_pLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
    int textHeight = q->fontMetrics().height();
    int yPos = (q->height() - textHeight) / 2;
    m_pLabel->setGeometry(q->rect().left(), yPos, m_textWidth, textHeight);
    m_level = Low;
    m_pLabel->setText(tr("Low"));
    setParent(parent);

    KDK_ALL_INFO_FORMAT(m_pLabel,"");
}
}
#include "ksecuritylevelbar.moc"
#include "moc_ksecuritylevelbar.cpp"
