# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network vnet-gateway update",
)
class Update(AAZCommand):
    """Update a virtual network gateway.

    :example: Change the SKU of a virtual network gateway.
        az network vnet-gateway update -g MyResourceGroup -n MyVnetGateway --sku VpnGw2

    :example: Update a virtual network gateway.
        az network vnet-gateway update --address-prefixes 40.1.0.0/24 --client-protocol IkeV2 --name MyVnetGateway --resource-group MyResourceGroup
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/virtualnetworkgateways/{}", "2022-01-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the VNet gateway.",
            required=True,
            id_part="name",
        )
        _args_schema.gateway_default_site = AAZStrArg(
            options=["--gateway-default-site"],
            help="Name or ID of a local network gateway representing a local network site with default routes.",
            nullable=True,
        )
        _args_schema.gateway_type = AAZStrArg(
            options=["--gateway-type"],
            help="The gateway type.",
            nullable=True,
            enum={"ExpressRoute": "ExpressRoute", "LocalGateway": "LocalGateway", "Vpn": "Vpn"},
        )
        _args_schema.sku = AAZStrArg(
            options=["--sku"],
            help="VNet gateway SKU.",
            nullable=True,
            enum={"Basic": "Basic", "ErGw1AZ": "ErGw1AZ", "ErGw2AZ": "ErGw2AZ", "ErGw3AZ": "ErGw3AZ", "HighPerformance": "HighPerformance", "Standard": "Standard", "UltraPerformance": "UltraPerformance", "VpnGw1": "VpnGw1", "VpnGw1AZ": "VpnGw1AZ", "VpnGw2": "VpnGw2", "VpnGw2AZ": "VpnGw2AZ", "VpnGw3": "VpnGw3", "VpnGw3AZ": "VpnGw3AZ", "VpnGw4": "VpnGw4", "VpnGw4AZ": "VpnGw4AZ", "VpnGw5": "VpnGw5", "VpnGw5AZ": "VpnGw5AZ"},
        )
        _args_schema.vpn_auth_type = AAZListArg(
            options=["--vpn-auth-type"],
            help="VPN authentication types enabled for the virtual network gateway.",
            nullable=True,
        )
        _args_schema.vpn_type = AAZStrArg(
            options=["--vpn-type"],
            help="VPN routing type.",
            nullable=True,
            enum={"PolicyBased": "PolicyBased", "RouteBased": "RouteBased"},
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...]. Use \"\" to clear existing tags.",
            nullable=True,
        )

        vpn_auth_type = cls._args_schema.vpn_auth_type
        vpn_auth_type.Element = AAZStrArg(
            nullable=True,
            enum={"AAD": "AAD", "Certificate": "Certificate", "Radius": "Radius"},
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "AAD Authentication"

        _args_schema = cls._args_schema
        _args_schema.aad_audience = AAZStrArg(
            options=["--aad-audience"],
            arg_group="AAD Authentication",
            help="The AADAudience ID of the VirtualNetworkGateway.",
            nullable=True,
        )
        _args_schema.aad_issuer = AAZStrArg(
            options=["--aad-issuer"],
            arg_group="AAD Authentication",
            help="The AAD Issuer URI of the VirtualNetworkGateway.",
            nullable=True,
        )
        _args_schema.aad_tenant = AAZStrArg(
            options=["--aad-tenant"],
            arg_group="AAD Authentication",
            help="The AAD Tenant URI of the VirtualNetworkGateway.",
            nullable=True,
        )

        # define Arg Group "BGP Peering"

        _args_schema = cls._args_schema
        _args_schema.asn = AAZIntArg(
            options=["--asn"],
            arg_group="BGP Peering",
            help="Autonomous System Number to use for the BGP settings.",
            nullable=True,
            fmt=AAZIntArgFormat(
                maximum=4294967295,
                minimum=0,
            ),
        )
        _args_schema.bgp_peering_address = AAZStrArg(
            options=["--bgp-peering-address"],
            arg_group="BGP Peering",
            help="IP address to use for BGP peering.",
            nullable=True,
        )
        _args_schema.peer_weight = AAZIntArg(
            options=["--peer-weight"],
            arg_group="BGP Peering",
            help="Weight (0-100) added to routes learned through BGP peering.",
            nullable=True,
        )
        _args_schema.enable_bgp = AAZBoolArg(
            options=["--enable-bgp"],
            arg_group="BGP Peering",
            help="Enable BGP (Border Gateway Protocol).",
            nullable=True,
        )

        # define Arg Group "BgpSettings"

        # define Arg Group "Parameters"

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.active = AAZBoolArg(
            options=["--active"],
            arg_group="Properties",
            help="ActiveActive flag.",
            nullable=True,
        )
        _args_schema.ip_configurations = AAZListArg(
            options=["--ip-configurations"],
            arg_group="Properties",
            help="IP configurations for virtual network gateway.",
            nullable=True,
        )
        _args_schema.sku_tier = AAZStrArg(
            options=["--sku-tier"],
            arg_group="Properties",
            help="Gateway SKU tier.",
            nullable=True,
            enum={"Basic": "Basic", "ErGw1AZ": "ErGw1AZ", "ErGw2AZ": "ErGw2AZ", "ErGw3AZ": "ErGw3AZ", "HighPerformance": "HighPerformance", "Standard": "Standard", "UltraPerformance": "UltraPerformance", "VpnGw1": "VpnGw1", "VpnGw1AZ": "VpnGw1AZ", "VpnGw2": "VpnGw2", "VpnGw2AZ": "VpnGw2AZ", "VpnGw3": "VpnGw3", "VpnGw3AZ": "VpnGw3AZ", "VpnGw4": "VpnGw4", "VpnGw4AZ": "VpnGw4AZ", "VpnGw5": "VpnGw5", "VpnGw5AZ": "VpnGw5AZ"},
        )

        ip_configurations = cls._args_schema.ip_configurations
        ip_configurations.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.ip_configurations.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
            nullable=True,
        )
        _element.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="The private IP address allocation method.",
            nullable=True,
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        _element.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="The reference to the public IP resource.",
            nullable=True,
        )
        cls._build_args_sub_resource_update(_element.public_ip_address)
        _element.subnet = AAZStrArg(
            options=["subnet"],
            help="test",
            nullable=True,
        )

        # define Arg Group "Root Cert Authentication"

        _args_schema = cls._args_schema
        _args_schema.vpn_client_root_certificates = AAZListArg(
            options=["--vpn-client-root-certificates"],
            arg_group="Root Cert Authentication",
            help="VpnClientRootCertificate for virtual network gateway.",
            nullable=True,
        )

        vpn_client_root_certificates = cls._args_schema.vpn_client_root_certificates
        vpn_client_root_certificates.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.vpn_client_root_certificates.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
            nullable=True,
        )
        _element.public_cert_data = AAZStrArg(
            options=["public-cert-data"],
            help="The certificate public data.",
        )

        # define Arg Group "VPN Client"

        _args_schema = cls._args_schema
        _args_schema.custom_routes = AAZListArg(
            options=["--custom-routes"],
            arg_group="VPN Client",
            help="Space-separated list of CIDR prefixes representing the custom routes address space specified by the customer for VpnClient.",
            nullable=True,
        )
        _args_schema.radius_server = AAZStrArg(
            options=["--radius-server"],
            arg_group="VPN Client",
            help="Radius server address to connect to.",
            nullable=True,
        )
        _args_schema.radius_secret = AAZStrArg(
            options=["--radius-secret"],
            arg_group="VPN Client",
            help="Radius secret to use for authentication.",
            nullable=True,
        )
        _args_schema.address_prefixes = AAZListArg(
            options=["--address-prefixes"],
            singular_options=["--address-prefix"],
            arg_group="VPN Client",
            help="Space-separated list of CIDR prefixes representing the address space for the P2S Vpnclient.",
            nullable=True,
        )
        _args_schema.client_protocol = AAZListArg(
            options=["--client-protocol"],
            arg_group="VPN Client",
            help="Protocols to use for connecting.  Allowed values: IkeV2, OpenVPN, SSTP.",
            nullable=True,
        )

        custom_routes = cls._args_schema.custom_routes
        custom_routes.Element = AAZStrArg(
            nullable=True,
        )

        address_prefixes = cls._args_schema.address_prefixes
        address_prefixes.Element = AAZStrArg(
            nullable=True,
        )

        client_protocol = cls._args_schema.client_protocol
        client_protocol.Element = AAZStrArg(
            nullable=True,
            enum={"IkeV2": "IkeV2", "OpenVPN": "OpenVPN", "SSTP": "SSTP"},
        )

        # define Arg Group "VpnClientConfiguration"
        return cls._args_schema

    _args_sub_resource_update = None

    @classmethod
    def _build_args_sub_resource_update(cls, _schema):
        if cls._args_sub_resource_update is not None:
            _schema.id = cls._args_sub_resource_update.id
            return

        cls._args_sub_resource_update = AAZObjectArg(
            nullable=True,
        )

        sub_resource_update = cls._args_sub_resource_update
        sub_resource_update.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
        )

        _schema.id = cls._args_sub_resource_update.id

    _args_vpn_nat_rule_mapping_update = None

    @classmethod
    def _build_args_vpn_nat_rule_mapping_update(cls, _schema):
        if cls._args_vpn_nat_rule_mapping_update is not None:
            _schema.address_space = cls._args_vpn_nat_rule_mapping_update.address_space
            return

        cls._args_vpn_nat_rule_mapping_update = AAZObjectArg(
            nullable=True,
        )

        vpn_nat_rule_mapping_update = cls._args_vpn_nat_rule_mapping_update
        vpn_nat_rule_mapping_update.address_space = AAZStrArg(
            options=["address-space"],
            help="Address space for Vpn NatRule mapping.",
            nullable=True,
        )

        _schema.address_space = cls._args_vpn_nat_rule_mapping_update.address_space

    def _execute_operations(self):
        self.pre_operations()
        self.VirtualNetworkGatewaysGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.VirtualNetworkGatewaysCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualNetworkGatewaysGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "virtualNetworkGatewayName", self.ctx.args.name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_virtual_network_gateway_read(cls._schema_on_200)

            return cls._schema_on_200

    class VirtualNetworkGatewaysCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "virtualNetworkGatewayName", self.ctx.args.name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_virtual_network_gateway_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("extendedLocation", AAZObjectType)
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("activeActive", AAZBoolType, ".active")
                properties.set_prop("bgpSettings", AAZObjectType)
                properties.set_prop("customRoutes", AAZObjectType)
                properties.set_prop("enableBgp", AAZBoolType, ".enable_bgp")
                properties.set_prop("gatewayDefaultSite", AAZObjectType)
                properties.set_prop("gatewayType", AAZStrType, ".gateway_type")
                properties.set_prop("ipConfigurations", AAZListType, ".ip_configurations")
                properties.set_prop("sku", AAZObjectType)
                properties.set_prop("vpnClientConfiguration", AAZObjectType)
                properties.set_prop("vpnType", AAZStrType, ".vpn_type")

            bgp_settings = _builder.get(".properties.bgpSettings")
            if bgp_settings is not None:
                bgp_settings.set_prop("asn", AAZIntType, ".asn")
                bgp_settings.set_prop("bgpPeeringAddress", AAZStrType, ".bgp_peering_address")
                bgp_settings.set_prop("peerWeight", AAZIntType, ".peer_weight")

            custom_routes = _builder.get(".properties.customRoutes")
            if custom_routes is not None:
                custom_routes.set_prop("addressPrefixes", AAZListType, ".custom_routes")

            address_prefixes = _builder.get(".properties.customRoutes.addressPrefixes")
            if address_prefixes is not None:
                address_prefixes.set_elements(AAZStrType, ".")

            gateway_default_site = _builder.get(".properties.gatewayDefaultSite")
            if gateway_default_site is not None:
                gateway_default_site.set_prop("id", AAZStrType, ".gateway_default_site")

            ip_configurations = _builder.get(".properties.ipConfigurations")
            if ip_configurations is not None:
                ip_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.ipConfigurations[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.ipConfigurations[].properties")
            if properties is not None:
                properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
                _UpdateHelper._build_schema_sub_resource_update(properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address"))
                properties.set_prop("subnet", AAZObjectType)

            subnet = _builder.get(".properties.ipConfigurations[].properties.subnet")
            if subnet is not None:
                subnet.set_prop("id", AAZStrType, ".subnet")

            sku = _builder.get(".properties.sku")
            if sku is not None:
                sku.set_prop("name", AAZStrType, ".sku")
                sku.set_prop("tier", AAZStrType, ".sku_tier")

            vpn_client_configuration = _builder.get(".properties.vpnClientConfiguration")
            if vpn_client_configuration is not None:
                vpn_client_configuration.set_prop("aadAudience", AAZStrType, ".aad_audience")
                vpn_client_configuration.set_prop("aadIssuer", AAZStrType, ".aad_issuer")
                vpn_client_configuration.set_prop("aadTenant", AAZStrType, ".aad_tenant")
                vpn_client_configuration.set_prop("radiusServerAddress", AAZStrType, ".radius_server")
                vpn_client_configuration.set_prop("radiusServerSecret", AAZStrType, ".radius_secret")
                vpn_client_configuration.set_prop("vpnAuthenticationTypes", AAZListType, ".vpn_auth_type")
                vpn_client_configuration.set_prop("vpnClientAddressPool", AAZObjectType)
                vpn_client_configuration.set_prop("vpnClientProtocols", AAZListType, ".client_protocol")
                vpn_client_configuration.set_prop("vpnClientRootCertificates", AAZListType, ".vpn_client_root_certificates")

            vpn_authentication_types = _builder.get(".properties.vpnClientConfiguration.vpnAuthenticationTypes")
            if vpn_authentication_types is not None:
                vpn_authentication_types.set_elements(AAZStrType, ".")

            vpn_client_address_pool = _builder.get(".properties.vpnClientConfiguration.vpnClientAddressPool")
            if vpn_client_address_pool is not None:
                vpn_client_address_pool.set_prop("addressPrefixes", AAZListType, ".address_prefixes")

            address_prefixes = _builder.get(".properties.vpnClientConfiguration.vpnClientAddressPool.addressPrefixes")
            if address_prefixes is not None:
                address_prefixes.set_elements(AAZStrType, ".")

            vpn_client_protocols = _builder.get(".properties.vpnClientConfiguration.vpnClientProtocols")
            if vpn_client_protocols is not None:
                vpn_client_protocols.set_elements(AAZStrType, ".")

            vpn_client_root_certificates = _builder.get(".properties.vpnClientConfiguration.vpnClientRootCertificates")
            if vpn_client_root_certificates is not None:
                vpn_client_root_certificates.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.vpnClientConfiguration.vpnClientRootCertificates[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})

            properties = _builder.get(".properties.vpnClientConfiguration.vpnClientRootCertificates[].properties")
            if properties is not None:
                properties.set_prop("publicCertData", AAZStrType, ".public_cert_data", typ_kwargs={"flags": {"required": True}})

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    @classmethod
    def _build_schema_sub_resource_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_vpn_nat_rule_mapping_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("addressSpace", AAZStrType, ".address_space")

    _schema_address_space_read = None

    @classmethod
    def _build_schema_address_space_read(cls, _schema):
        if cls._schema_address_space_read is not None:
            _schema.address_prefixes = cls._schema_address_space_read.address_prefixes
            return

        cls._schema_address_space_read = _schema_address_space_read = AAZObjectType()

        address_space_read = _schema_address_space_read
        address_space_read.address_prefixes = AAZListType(
            serialized_name="addressPrefixes",
        )

        address_prefixes = _schema_address_space_read.address_prefixes
        address_prefixes.Element = AAZStrType()

        _schema.address_prefixes = cls._schema_address_space_read.address_prefixes

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_virtual_network_gateway_read = None

    @classmethod
    def _build_schema_virtual_network_gateway_read(cls, _schema):
        if cls._schema_virtual_network_gateway_read is not None:
            _schema.etag = cls._schema_virtual_network_gateway_read.etag
            _schema.extended_location = cls._schema_virtual_network_gateway_read.extended_location
            _schema.id = cls._schema_virtual_network_gateway_read.id
            _schema.location = cls._schema_virtual_network_gateway_read.location
            _schema.name = cls._schema_virtual_network_gateway_read.name
            _schema.properties = cls._schema_virtual_network_gateway_read.properties
            _schema.tags = cls._schema_virtual_network_gateway_read.tags
            _schema.type = cls._schema_virtual_network_gateway_read.type
            return

        cls._schema_virtual_network_gateway_read = _schema_virtual_network_gateway_read = AAZObjectType()

        virtual_network_gateway_read = _schema_virtual_network_gateway_read
        virtual_network_gateway_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_gateway_read.extended_location = AAZObjectType(
            serialized_name="extendedLocation",
        )
        virtual_network_gateway_read.id = AAZStrType()
        virtual_network_gateway_read.location = AAZStrType()
        virtual_network_gateway_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_gateway_read.properties = AAZObjectType(
            flags={"required": True, "client_flatten": True},
        )
        virtual_network_gateway_read.tags = AAZDictType()
        virtual_network_gateway_read.type = AAZStrType(
            flags={"read_only": True},
        )

        extended_location = _schema_virtual_network_gateway_read.extended_location
        extended_location.name = AAZStrType()
        extended_location.type = AAZStrType()

        properties = _schema_virtual_network_gateway_read.properties
        properties.active_active = AAZBoolType(
            serialized_name="activeActive",
        )
        properties.bgp_settings = AAZObjectType(
            serialized_name="bgpSettings",
        )
        properties.custom_routes = AAZObjectType(
            serialized_name="customRoutes",
        )
        cls._build_schema_address_space_read(properties.custom_routes)
        properties.disable_ip_sec_replay_protection = AAZBoolType(
            serialized_name="disableIPSecReplayProtection",
        )
        properties.enable_bgp = AAZBoolType(
            serialized_name="enableBgp",
        )
        properties.enable_bgp_route_translation_for_nat = AAZBoolType(
            serialized_name="enableBgpRouteTranslationForNat",
        )
        properties.enable_dns_forwarding = AAZBoolType(
            serialized_name="enableDnsForwarding",
        )
        properties.enable_private_ip_address = AAZBoolType(
            serialized_name="enablePrivateIpAddress",
        )
        properties.gateway_default_site = AAZObjectType(
            serialized_name="gatewayDefaultSite",
        )
        cls._build_schema_sub_resource_read(properties.gateway_default_site)
        properties.gateway_type = AAZStrType(
            serialized_name="gatewayType",
        )
        properties.inbound_dns_forwarding_endpoint = AAZStrType(
            serialized_name="inboundDnsForwardingEndpoint",
            flags={"read_only": True},
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.nat_rules = AAZListType(
            serialized_name="natRules",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.sku = AAZObjectType()
        properties.v_net_extended_location_resource_id = AAZStrType(
            serialized_name="vNetExtendedLocationResourceId",
        )
        properties.vpn_client_configuration = AAZObjectType(
            serialized_name="vpnClientConfiguration",
        )
        properties.vpn_gateway_generation = AAZStrType(
            serialized_name="vpnGatewayGeneration",
        )
        properties.vpn_type = AAZStrType(
            serialized_name="vpnType",
        )

        bgp_settings = _schema_virtual_network_gateway_read.properties.bgp_settings
        bgp_settings.asn = AAZIntType()
        bgp_settings.bgp_peering_address = AAZStrType(
            serialized_name="bgpPeeringAddress",
        )
        bgp_settings.bgp_peering_addresses = AAZListType(
            serialized_name="bgpPeeringAddresses",
        )
        bgp_settings.peer_weight = AAZIntType(
            serialized_name="peerWeight",
        )

        bgp_peering_addresses = _schema_virtual_network_gateway_read.properties.bgp_settings.bgp_peering_addresses
        bgp_peering_addresses.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.bgp_settings.bgp_peering_addresses.Element
        _element.custom_bgp_ip_addresses = AAZListType(
            serialized_name="customBgpIpAddresses",
        )
        _element.default_bgp_ip_addresses = AAZListType(
            serialized_name="defaultBgpIpAddresses",
            flags={"read_only": True},
        )
        _element.ipconfiguration_id = AAZStrType(
            serialized_name="ipconfigurationId",
        )
        _element.tunnel_ip_addresses = AAZListType(
            serialized_name="tunnelIpAddresses",
            flags={"read_only": True},
        )

        custom_bgp_ip_addresses = _schema_virtual_network_gateway_read.properties.bgp_settings.bgp_peering_addresses.Element.custom_bgp_ip_addresses
        custom_bgp_ip_addresses.Element = AAZStrType()

        default_bgp_ip_addresses = _schema_virtual_network_gateway_read.properties.bgp_settings.bgp_peering_addresses.Element.default_bgp_ip_addresses
        default_bgp_ip_addresses.Element = AAZStrType()

        tunnel_ip_addresses = _schema_virtual_network_gateway_read.properties.bgp_settings.bgp_peering_addresses.Element.tunnel_ip_addresses
        tunnel_ip_addresses.Element = AAZStrType()

        ip_configurations = _schema_virtual_network_gateway_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.ip_configurations.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.ip_configurations.Element.properties
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
            flags={"read_only": True},
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_sub_resource_read(properties.subnet)

        nat_rules = _schema_virtual_network_gateway_read.properties.nat_rules
        nat_rules.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.nat_rules.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.nat_rules.Element.properties
        properties.external_mappings = AAZListType(
            serialized_name="externalMappings",
        )
        properties.internal_mappings = AAZListType(
            serialized_name="internalMappings",
        )
        properties.ip_configuration_id = AAZStrType(
            serialized_name="ipConfigurationId",
        )
        properties.mode = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.type = AAZStrType()

        external_mappings = _schema_virtual_network_gateway_read.properties.nat_rules.Element.properties.external_mappings
        external_mappings.Element = AAZObjectType()
        cls._build_schema_vpn_nat_rule_mapping_read(external_mappings.Element)

        internal_mappings = _schema_virtual_network_gateway_read.properties.nat_rules.Element.properties.internal_mappings
        internal_mappings.Element = AAZObjectType()
        cls._build_schema_vpn_nat_rule_mapping_read(internal_mappings.Element)

        sku = _schema_virtual_network_gateway_read.properties.sku
        sku.capacity = AAZIntType(
            flags={"read_only": True},
        )
        sku.name = AAZStrType()
        sku.tier = AAZStrType()

        vpn_client_configuration = _schema_virtual_network_gateway_read.properties.vpn_client_configuration
        vpn_client_configuration.aad_audience = AAZStrType(
            serialized_name="aadAudience",
        )
        vpn_client_configuration.aad_issuer = AAZStrType(
            serialized_name="aadIssuer",
        )
        vpn_client_configuration.aad_tenant = AAZStrType(
            serialized_name="aadTenant",
        )
        vpn_client_configuration.radius_server_address = AAZStrType(
            serialized_name="radiusServerAddress",
        )
        vpn_client_configuration.radius_server_secret = AAZStrType(
            serialized_name="radiusServerSecret",
        )
        vpn_client_configuration.radius_servers = AAZListType(
            serialized_name="radiusServers",
        )
        vpn_client_configuration.vpn_authentication_types = AAZListType(
            serialized_name="vpnAuthenticationTypes",
        )
        vpn_client_configuration.vpn_client_address_pool = AAZObjectType(
            serialized_name="vpnClientAddressPool",
        )
        cls._build_schema_address_space_read(vpn_client_configuration.vpn_client_address_pool)
        vpn_client_configuration.vpn_client_ipsec_policies = AAZListType(
            serialized_name="vpnClientIpsecPolicies",
        )
        vpn_client_configuration.vpn_client_protocols = AAZListType(
            serialized_name="vpnClientProtocols",
        )
        vpn_client_configuration.vpn_client_revoked_certificates = AAZListType(
            serialized_name="vpnClientRevokedCertificates",
        )
        vpn_client_configuration.vpn_client_root_certificates = AAZListType(
            serialized_name="vpnClientRootCertificates",
        )

        radius_servers = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.radius_servers
        radius_servers.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.radius_servers.Element
        _element.radius_server_address = AAZStrType(
            serialized_name="radiusServerAddress",
            flags={"required": True},
        )
        _element.radius_server_score = AAZIntType(
            serialized_name="radiusServerScore",
        )
        _element.radius_server_secret = AAZStrType(
            serialized_name="radiusServerSecret",
        )

        vpn_authentication_types = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_authentication_types
        vpn_authentication_types.Element = AAZStrType()

        vpn_client_ipsec_policies = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_ipsec_policies
        vpn_client_ipsec_policies.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_ipsec_policies.Element
        _element.dh_group = AAZStrType(
            serialized_name="dhGroup",
            flags={"required": True},
        )
        _element.ike_encryption = AAZStrType(
            serialized_name="ikeEncryption",
            flags={"required": True},
        )
        _element.ike_integrity = AAZStrType(
            serialized_name="ikeIntegrity",
            flags={"required": True},
        )
        _element.ipsec_encryption = AAZStrType(
            serialized_name="ipsecEncryption",
            flags={"required": True},
        )
        _element.ipsec_integrity = AAZStrType(
            serialized_name="ipsecIntegrity",
            flags={"required": True},
        )
        _element.pfs_group = AAZStrType(
            serialized_name="pfsGroup",
            flags={"required": True},
        )
        _element.sa_data_size_kilobytes = AAZIntType(
            serialized_name="saDataSizeKilobytes",
            flags={"required": True},
        )
        _element.sa_life_time_seconds = AAZIntType(
            serialized_name="saLifeTimeSeconds",
            flags={"required": True},
        )

        vpn_client_protocols = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_protocols
        vpn_client_protocols.Element = AAZStrType()

        vpn_client_revoked_certificates = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_revoked_certificates
        vpn_client_revoked_certificates.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_revoked_certificates.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_revoked_certificates.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.thumbprint = AAZStrType()

        vpn_client_root_certificates = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_root_certificates
        vpn_client_root_certificates.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_root_certificates.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"required": True, "client_flatten": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_root_certificates.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_cert_data = AAZStrType(
            serialized_name="publicCertData",
            flags={"required": True},
        )

        tags = _schema_virtual_network_gateway_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_network_gateway_read.etag
        _schema.extended_location = cls._schema_virtual_network_gateway_read.extended_location
        _schema.id = cls._schema_virtual_network_gateway_read.id
        _schema.location = cls._schema_virtual_network_gateway_read.location
        _schema.name = cls._schema_virtual_network_gateway_read.name
        _schema.properties = cls._schema_virtual_network_gateway_read.properties
        _schema.tags = cls._schema_virtual_network_gateway_read.tags
        _schema.type = cls._schema_virtual_network_gateway_read.type

    _schema_vpn_nat_rule_mapping_read = None

    @classmethod
    def _build_schema_vpn_nat_rule_mapping_read(cls, _schema):
        if cls._schema_vpn_nat_rule_mapping_read is not None:
            _schema.address_space = cls._schema_vpn_nat_rule_mapping_read.address_space
            _schema.port_range = cls._schema_vpn_nat_rule_mapping_read.port_range
            return

        cls._schema_vpn_nat_rule_mapping_read = _schema_vpn_nat_rule_mapping_read = AAZObjectType()

        vpn_nat_rule_mapping_read = _schema_vpn_nat_rule_mapping_read
        vpn_nat_rule_mapping_read.address_space = AAZStrType(
            serialized_name="addressSpace",
        )
        vpn_nat_rule_mapping_read.port_range = AAZStrType(
            serialized_name="portRange",
        )

        _schema.address_space = cls._schema_vpn_nat_rule_mapping_read.address_space
        _schema.port_range = cls._schema_vpn_nat_rule_mapping_read.port_range


__all__ = ["Update"]
