#!/bin/sh 
#
# This should be done at initial booting after installation.
#
export PATH=/bin:/usr/bin:/sbin:/usr/sbin
export LANG=C

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

APACI_DIR=$ROOT/opt/httpd

if ! fgrep "LoadModule auth_kerb_module" $APACI_DIR/conf/httpd.conf 1> /dev/null 2>&1; then
  $APACI_DIR/bin/apxs -e -a -n auth_kerb $APACI_DIR/modules/mod_auth_kerb.so
fi

chown www:apache $APACI_DIR/modules/mod_auth_kerb.so  $APACI_DIR/conf/conf.d/auth_kerb.conf-sample

if [ "$ROOT" = "" ]; then
  $APACI_DIR/bin/apachectl stop
  sleep 1
  $APACI_DIR/bin/apachectl startssl
fi


#
# ( DONOT CHANGE THE NEXT ONE LINE )
# Add mod_auth_kerb Entry to Apache document index.
#
if [ -f $ROOT/opt/httpd/htdocs/contents.list ]; then
  if ! fgrep "mod_auth_kerb" $ROOT/opt/httpd/htdocs/contents.list 1> /dev/null 2>&1; then
    cat >> $ROOT/opt/httpd/htdocs/contents.list <<EOL

    <P ALIGN="CENTER">
    mod_auth_kerb
    (
      <A
        HREF="http://modauthkerb.sourceforge.net/"
      > http://modauthkerb.sourceforge.net/ </A>
    )<BR>
     (Kerberos Module for Apache)<BR>
    <A
     HREF="/mod_auth_kerb"
    >document</A>
    </P>
EOL
  fi
  if [ ! -f $ROOT/opt/httpd/htdocs/mod_auth_kerb ]; then 
    ln -sf $ROOT//usr/share/doc/mod_auth_kerb-5.0rc7 $ROOT/opt/httpd/htdocs/mod_auth_kerb
  fi
else
  awk '/Add mod_auth_kerb Entry/,EOF' $ROOT/install/doinst.sh >> /tmp/add_apache_test.sh
fi
