/*
 *  Emi Clock $B!=(B $B%a%K%e!<=hM}(B
 */

/*
 *  Copyright (c) 1994, 1995, 1997, 1999 Masayuki Koba
 *
 *  $BK\%=%U%H%&%'%"$N%=!<%9$d%P%$%J%j$r:FG[I[$9$k>l9g$O!"<!$N>r7o$r=e<i$7$F(B
 *  $B2<$5$$!#(B
 *
 *  1. $BK\%=%U%H%&%'%"$rF~<j$7$?J}$K$O!"(BX11$BHG(B Emi Clock $B$N;HMQ8"$H!"Bh;0<T(B
 *     $B$X$N:FG[I[8"$,G'$a$i$l$^$9!#$?$@$7!":FG[I[$K4X$7$F$O!"F~<j;~$N%*%j(B
 *     $B%8%J%k$N$^$^2~JQ$;$:$K9T$&$3$H$,>r7o$G$9!#(B
 *  2. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$G2~JQ$7$FG[I[$9$k$3(B
 *     $B$H$O$G$-$^$;$s!#(B
 *  3. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$GFs<!MxMQ$9$k$3$H$O(B
 *     $B$G$-$^$;$s!#(B
 *  4. $BK\%=%U%H%&%'%"$r%7%9%F%`$K%P%s%I%k$7$?$j!"%7%9%F%`$NDI2C%Q%C%1!<%8(B
 *     $B$H$7$FBh;0<T$K:FG[I[$7$?$j$9$k>l9g$O!";vA0$KCx:n8"<T$K5v2D$,I,MW$G(B
 *     $B$9!#(B
 *  5. $BK\%=%U%H%&%'%"$r>&MQ$K;HMQ$9$k>l9g(B($B6bA,E*Mx1W$rF@$k>l9g(B)$B$O!";vA0$K(B
 *     $BCx:n8"<T$K5v2D$,I,MW$G$9!#$3$N>l9g!"4pK\E*$KM-=~$H$J$j$^$9!#(B
 *  6. $BK\%=%U%H%&%'%"$rMxMQ$9$k$3$H$K$h$C$FH/@8$7$?$$$+$J$kB;32$b!"Cx:n8"(B
 *     $B<T$OIi$o$J$$$b$N$H$7$^$9!#$3$l$K9g0U$G$-$J$$>l9g$O!";HMQ8"$,$J$$$b(B
 *     $B$N$H$7$^$9!#(B
 *  7. $B!H(BEmi Clock$B!I$N>&I8$*$h$SK\%=%U%H%&%'%"$N2hA|$d%G%6%$%s$K4X$9$kCx:n(B
 *     $B8"$O!"(BMotosoft $B$3$H!HK\(B $B=SLi!I;a$,M-$7$^$9!#(B
 *  8. $B!H(BEmi Clock$B!I$N>&I8$*$h$S2hA|$d%G%6%$%s$O!"(BX11$BHG(B Emi Clock $B3+H/$N$?(B
 *     $B$a!"(BMotosoft $B$h$j!H8E>l(B $B@59T!I$X8D?ME*$K%i%$%;%s%96!M?$5$l$F$^$9!#(B
 *     $BBh;0<T$XFs<!%i%$%;%s%96!M?$9$k$3$H$OG'$a$i$l$F$*$j$^$;$s!#(B
 *  9. Motosoft $B$H8E>l$KL5CG$G!"K\%=%U%H%&%'%"$N2hA|%G!<%?$rFs<!MxMQ$9$k$3(B
 *     $B$H$r6X;_$7$^$9!#(B
 * 10. $B$3$3$K5-=R$7$?0J30$N8"Mx$K$D$$$F$O!"F|K\9q$NCx:n8"K!$K$h$k$b$N$H$7(B
 *     $B$^$9!#(B
 */


/* $B#X%D!<%k%-%C%H%W%m%0%i%_%s%0$KI,MW$J%X%C%@!<(B */
#include <X11/Intrinsic.h>		/* $B%$%s%H%j%s%7%C%/$NDj5A(B */
#include <X11/StringDefs.h>		/* $BI8=`%j%=!<%9J8;zNs$NDj5A(B */

/* X11 $B$=$NB>(B */
#include <X11/cursorfont.h>		/* X11 $BI8=`%+!<%=%k(B */

/* $B#C8@8l%i%$%V%i%j(B */
#include <stdio.h>			/* $BI8=`F~=PNO%i%$%V%i%j(B */
#include <stdlib.h>			/* $BI8=`%i%$%V%i%j(B */

/* Emi Clock $BFH<+$N%X%C%@!<(B */
#include "config.h"			/* $B%3%s%Q%$%k4D6-$NDj5A(B */
#include "include/system.h"		/* $B%7%9%F%`4D6-$N:9J,5[<}(B */
#include "include/const.h"		/* $BDj?tDj5A(B */
#include "include/types.h"		/* $BFC<l$J7?$NDj5A(B */
#include "include/public.h"		/* $BHFMQ4X?t!?30ItDj5A%G!<%?$N@k8@(B */
#include "include/util.h"		/* $B%^%/%mDj5A(B */

/* Widgets */
#include "EmiClock.h"			/* EmiClock Widget */
#ifndef	USE_XAW3D
#include <X11/Xaw/SimpleMenu.h>		/* Xaw SimpleMenu Widget */
#include <X11/Xaw/SmeBSB.h>		/* Xaw SmeBSB */
#include <X11/Xaw/SmeLine.h>		/* Xaw SmeLine */
#include <X11/Xaw/Dialog.h>		/* Xaw Dialog Widget */
#include <X11/Xaw/Toggle.h>		/* Xaw Toggle Widget */
#include <X11/Xaw/Form.h>		/* Xaw Form Widget */
#include <X11/Xaw/Label.h>		/* Xaw Label Widget */
#include <X11/Xaw/Command.h>		/* Xaw Command Widget */
#include <X11/Xaw/AsciiText.h>		/* Xaw AsciiText Widget */
#else	/* USE_XAW3D */
#include <X11/Xaw3d/SimpleMenu.h>	/* Xaw3d SimpleMenu Widget */
#include <X11/Xaw3d/SmeBSB.h>		/* Xaw3d SmeBSB */
#include <X11/Xaw3d/SmeLine.h>		/* Xaw3d SmeLine */
#include <X11/Xaw3d/Dialog.h>		/* Xaw3d Dialog Widget */
#include <X11/Xaw3d/Toggle.h>		/* Xaw3d Toggle Widget */
#include <X11/Xaw3d/Form.h>		/* Xaw3d Form Widget */
#include <X11/Xaw3d/Label.h>		/* Xaw3d Label Widget */
#include <X11/Xaw3d/Command.h>		/* Xaw3d Command Widget */
#include <X11/Xaw3d/AsciiText.h>	/* Xaw3d AsciiText Widget */
#endif	/* !USE_XAW3D */
#include "CascadeMenu.h"		/* CascadeMenu Widget */

/* $B%S%C%H%^%C%W(B */
#include "graphics/misc/check.xbm"	/* $B%A%'%C%/%^!<%/(B */
#include "graphics/misc/submenu.xbm"	/* $B%5%V%a%K%e!<%^!<%/(B */
#include "graphics/misc/notice.xbm"	/* $BCmL\%^!<%/(B */
#include "graphics/misc/box.xbm"	/* $B%A%'%C%/%\%C%/%9(B */

#ifdef	USE_XAWI18N
#include <X11/Xaw/Xawi18n.h>
#endif	/* USE_XAWI18N */

/* RCS ID */
rcsId(menuId, "$Id: menu.c,v 1.7 1999/09/02 14:33:49 koba Exp $")

/* $B%m!<%+%k4X?t$N%W%m%H%?%$%W@k8@(B */
static Widget CreateMainMenu __P((Widget));
static void MainMenuSelect __P((Widget, XtPointer, XtPointer));
static Widget CreateOptionSubMenu __P((Widget));
static void OptionSubMenuSelect __P((Widget, XtPointer, XtPointer));
static Widget CreateChimeSubMenu __P((Widget));
static Widget CreateHourlyChimeDialog __P((Widget, Widget *, Widget *));
static void HourlyChimeDialogCancel __P((Widget, XtPointer, XtPointer));
static void HourlyChimeDialogToggle __P((Widget, XtPointer, XtPointer));
static void HourlyChimeDialogSound __P((Widget, XtPointer, XtPointer));
static Widget CreateHalfHourChimeDialog __P((Widget, Widget *, Widget *));
static void HalfHourChimeDialogCancel __P((Widget, XtPointer, XtPointer));
static void HalfHourChimeDialogToggle __P((Widget, XtPointer, XtPointer));
static void HalfHourChimeDialogSound __P((Widget, XtPointer, XtPointer));
static Widget CreateNoteAlarmDialog __P((Widget, Widget *, Widget *));
static void NoteAlarmDialogCancel __P((Widget, XtPointer, XtPointer));
static void NoteAlarmDialogToggle __P((Widget, XtPointer, XtPointer));
static void NoteAlarmDialogSound __P((Widget, XtPointer, XtPointer));
static Widget CreateAlarmSettingsDialog __P((Widget));
static void OneTimeToggle __P((Widget, XtPointer, XtPointer));
static void OneTimeButton __P((Widget, XtPointer, XtPointer));
static void ResetDailyAlarmToggle __P((void));
static void DailyAlarmToggle __P((Widget, XtPointer, XtPointer));
static void DailyAlarmButton __P((Widget, XtPointer, XtPointer));
static void ResetOneTimeToggle __P((void));
static void AlarmTimeDateTextSet __P((void));
static void AlarmSettingsDialogCancel __P((Widget, XtPointer, XtPointer));
static void ChimeSubMenuSelect __P((Widget, XtPointer, XtPointer));
static Widget CreateCostumesSubMenu __P((Widget));
static void CharMenuCheckItemClear __P((Widget, XtPointer, XtPointer));
static void CharMenuCheckItemSet __P((Widget, XtPointer, XtPointer));
static void CanTransparent __P((Widget, XtPointer, XtPointer));
static void CostumesSubMenuSelect __P((Widget, XtPointer, XtPointer));
static Widget CreateFaceSubMenu __P((Widget));
static void FaceSubMenuSelect __P((Widget, XtPointer, XtPointer));
static Widget CreateAboutDialog __P((Widget));
static void PlaceMenu __P((Widget));
static void AdjustRoot __P((Widget));
static Pixmap CreateCreditPixmap __P((Widget, int));
static void FileNotFoundDialog __P((Widget));
static void FileNotFoundDialogOk __P((Widget, XtPointer, XtPointer));
static void DialogSoundTest __P((Widget, XtPointer, XtPointer));
static void AlarmDialogOk __P((Widget, XtPointer, XtPointer));
static void CenterMenu __P((Widget));

/* $B%H%i%s%9%l!<%7%g%s(B */
static String	trans = "#override\n\
    <BtnUp>: setNeko1Curs() cascade_select() XtMenuPopdown() unhighlight()";

/* $B%a%$%s%a%K%e!<$N%$%s%9%?%s%9L>$r<}$a$?%F!<%V%k(B */
static String mainMenuEntryNames[] = {
    OPTION_STR,			/* $B%*%W%7%g%s(B */
    CHIME_STR,			/* $B%A%c%$%`(B */
    COSTUMES_STR,		/* $BCe$;BX$((B */
    FACE_STR,			/* $BJ8;zHW(B */
    ABOUT_STR,			/* Emi Clock$B$K$D$$$F(B... */
    LINE_STR,			/* ($B@~(B) */
    EXIT_STR,			/* $B=*N;(B */
};

/* $B!H%*%W%7%g%s!I%5%V%a%K%e!<$N%$%s%9%?%s%9L>$r<}$a$?%F!<%V%k(B */
static String optionSubMenuEntryNames[] = {
    DISPLAY_SEC_STR,		/* $BIC?KI=<((B */
    STARTUP_SOUND_STR,		/* $B5/F02;!V$_$e$C!*!W(B */
};

/* $B!H%A%c%$%`!I%5%V%a%K%e!<$N%$%s%9%?%s%9L>$r<}$a$?%F!<%V%k(B */
static String chimeSubMenuEntryNames[] = {
    HOURKY_CHIME_STR,		/* 0$BJ,%A%c%$%`%5%&%s%I(B... */
    HALF_HOUR_CHIME_STR,	/* 30$BJ,%A%c%$%`%5%&%s%I(B... */
    LINE_STR,			/* ($B@~(B) */
    NOTE_ALARM_STR,		/* $B%"%i!<%`%5%&%s%I(B... */
    ALARM_SETTINGS_STR,		/* $B%"%i!<%`;~9o@_Dj(B... */
};

/* $B!HJ8;zHW!I%5%V%a%K%e!<$N%$%s%9%?%s%9L>$r<}$a$?%F!<%V%k(B */
static String faceSubMenuEntryNames[] = {
    PICTURE_STR,		/* $B%T%/%A%c!J@D!K(B */
    NUMBER_STR,			/* $B?t;z!J@V!K(B */
    REVERSE_STR,		/* $B5U2sE>!JNP!K(B */
};

/* $B%0%m!<%P%k(B */
static Pixmap checkMark;		/* $B%A%'%C%/%^!<%/$N(B Pixmap */
static Pixmap submenuMark;		/* $B%5%V%a%K%e!<%^!<%/$N(B Pixmap */
static Pixmap noticeMark;		/* $BCmL\%^!<%/$N(B Pixmap */
static Pixmap checkBox;			/* $B%A%'%C%/%\%C%/%9$N(B Pixmap */
static Cursor arrowCurs;		/* $BLp0u%+!<%=%k(B */
static Widget mainMenu;			/* $B%a%$%s%a%K%e!<(B */
static Widget optionSubMenu;		/* $B!H%*%W%7%g%s!I%5%V%a%K%e!<(B */
static Widget chimeSubMenu;		/* $B!H%A%c%$%`!I%5%V%a%K%e!<(B */
static Widget hourlyChimePopup;		/* $B!H(B0$BJ,%A%c%$%`%5%&%s%I(B...$B!I(B */
static Widget hourlyChimeDialog;
static Widget hourlyChimeToggle;
static Boolean hourlyChimeToggleState;
static Widget halfHourChimePopup;	/* $B!H(B30$BJ,%A%c%$%`%5%&%s%I(B...$B!I(B */
static Widget halfHourChimeDialog;
static Widget halfHourChimeToggle;
static Boolean halfHourChimeToggleState;
static Widget noteAlarmPopup;		/* $B!H%"%i!<%`%5%&%s%I(B...$B!I(B */
static Widget noteAlarmDialog;
static Widget noteAlarmToggle;
static Boolean noteAlarmToggleState;
static Widget alarmSettingsPopup;	/* $B!H%"%i!<%`;~9o@_Dj(B...$B!I(B */
static Widget hourText, minuteText;
static Widget yearText, monthText, dateText;
static Widget oneTimeToggle;
static Widget dailyAlarmToggle;
static Boolean oneTimeToggleState;
static Boolean dailyAlarmToggleState;
static Widget costumesSubMenu;		/* $B!HCe$;BX$(!I%5%V%a%K%e!<(B */
static Widget faceSubMenu;		/* $B!HJ8;zHW!I%5%V%a%K%e!<(B */
static Widget aboutPopup;		/* $B!H(BAbout Emi Clock...$B!I%@%$%"%m%0(B */
static Widget aboutPicture;		/* $B%/%l%8%C%H$N3($rI=<($9$k(B Widget */
static Widget charItem[NUM_OF_CHAR];	/* $B!HCe$;BX$(!I%5%V%a%K%e!<%"%$%F%`(B */
static Widget cbaseItem[NUM_OF_CBASE];	/* $B!HJ8;zHW!I%5%V%a%K%e!<%"%$%F%`(B */

static int	creditNo;		/* $B8=:_I=<($7$F$$$k%/%l%8%C%H$NHV9f(B */
static Pixmap	creditPixmap = (Pixmap)NULL;	/* $B%/%l%8%C%H$N(B Pixmap */

static AllocPixel creditPixels[PIXELS_8];
static int numOfcreditPixels;
static GC copyGC;


/*
 *  $B%]%C%W%"%C%W%a%K%e!<$N@8@.(B
 */
void
CreatePopupMenu(w)
    Widget	w;
{
    /* $B%A%'%C%/%^!<%/$N(B Pixmap $B$r@8@.$9$k(B */
    checkMark = XCreateBitmapFromData(XtDisplay(w),
			RootWindowOfScreen(XtScreen(w)),
			check_bits, check_width, check_height);

    /* $B%5%V%a%K%e!<%^!<%/$N(B Pixmap $B$r@8@.$9$k(B */
    submenuMark = XCreateBitmapFromData(XtDisplay(w),
			RootWindowOfScreen(XtScreen(w)),
			submenu_bits, submenu_width, submenu_height);

    /* $BCmL\%^!<%/$N(B Pixmap $B$r@8@.$9$k(B */
    noticeMark = XCreateBitmapFromData(XtDisplay(w),
			RootWindowOfScreen(XtScreen(w)),
			notice_bits, notice_width, notice_height);

    /* $B%A%'%C%/%\%C%/%9$N(B Pixmap $B$r@8@.$9$k(B */
    checkBox = XCreateBitmapFromData(XtDisplay(w),
			RootWindowOfScreen(XtScreen(w)),
				box_bits, box_width, box_height);

    /* $BLp0u%+!<%=%k$r@8@.$9$k(B */
    arrowCurs = XCreateFontCursor(XtDisplay(w), XC_left_ptr);

    /* $B%a%K%e!<@8@.(B */
    mainMenu = CreateMainMenu(w);
    optionSubMenu = CreateOptionSubMenu(w);
    chimeSubMenu = CreateChimeSubMenu(w);
    costumesSubMenu = CreateCostumesSubMenu(w);
    faceSubMenu = CreateFaceSubMenu(w);
    aboutPopup = CreateAboutDialog(w);
}


/*
 *  $B%a%$%s%a%K%e!<$N:n@.(B
 */
static Widget
CreateMainMenu(w)
    Widget	w;
{
    Widget	popup;
    int		i;
    Widget	entry;

    popup = XtVaCreatePopupShell(
		"mainMenu",		/* Widget $BL>(B */
		cascadeMenuWidgetClass,	/* Widget $B%/%i%9(B */
		w,			/* $B?F$H$J$k(B Widget */
		XtNtranslations,	XtParseTranslationTable(trans),
		NULL);			/* $B2DJQD90z?t$N=*C<(B */

    /* $B%a%K%e!<%"%$%F%`$N@8@.(B */
    for (i = 0; i < XtNumber(mainMenuEntryNames); i++) {
	String	menuItem = mainMenuEntryNames[i];

	if (strcmp(menuItem, LINE_STR) == 0) {	/* $B%a%K%e!<$K@~$r0z$/(B */
	    entry = XtCreateManagedWidget(menuItem, smeLineObjectClass,
							popup, NULL, 0);
	} else {
	    entry = XtCreateManagedWidget(menuItem, smeBSBObjectClass,
							popup, NULL, 0);
	    XtAddCallback(entry, XtNcallback, MainMenuSelect, (XtPointer)i);
	}

	/* $B>e$+$i#4$D$N%a%K%e!<%"%$%F%`$K%5%V%a%K%e!<%^!<%/$r$D$1$k(B */
	if (i < 4) {
	    XtVaSetValues(entry, XtNrightBitmap, submenuMark, NULL);
	}
    }

    return(popup);
}


/*
 *  $B%a%$%s%a%K%e!<$N%3!<%k%P%C%/(B
 */
static void
MainMenuSelect(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    if (strcmp(XtName(w), OPTION_STR) == 0) {
	/* $B!H%*%W%7%g%s!I$N=hM}(B */
	PlaceMenu(optionSubMenu);
	XtPopup(optionSubMenu, XtGrabNonexclusive);
    } else if (strcmp(XtName(w), CHIME_STR) == 0) {
	/* $B!H%A%c%$%`!I$N=hM}(B */
	PlaceMenu(chimeSubMenu);
	XtPopup(chimeSubMenu, XtGrabNonexclusive);
    } else if (strcmp(XtName(w), COSTUMES_STR) == 0) {
	/* $B!HCe$;BX$(!I$N=hM}(B */
	PlaceMenu(costumesSubMenu);
	XtPopup(costumesSubMenu, XtGrabNonexclusive);
    } else if (strcmp(XtName(w), FACE_STR) == 0) {
	/* $B!HJ8;zHW!I$N=hM}(B */
	PlaceMenu(faceSubMenu);
	XtPopup(faceSubMenu, XtGrabNonexclusive);
    } else if (strcmp(XtName(w), ABOUT_STR) == 0) {
	/* $B!H(BEmi Clock$B$K$D$$$F(B...$B!I$N=hM}(B */
	creditNo = 0;
	creditPixmap = CreateCreditPixmap(aboutPicture, creditNo);
	if (XtIsRealized(aboutPopup)) {
	    XCopyArea(XtDisplay(aboutPopup), creditPixmap,
			XtWindow(aboutPicture), copyGC, 0, 0,
			CREDIT_WIDTH, CREDIT_HEIGHT, 0, 0);
	}
	PlaceMenu(aboutPopup);
	XtPopup(aboutPopup, XtGrabNone);
    } else if (strcmp(XtName(w), EXIT_STR) == 0) {
	ProgramExit(0);
    }
}


/*
 *  $B!H%*%W%7%g%s!I%5%V%a%K%e!<$N:n@.(B
 */
static Widget
CreateOptionSubMenu(w)
    Widget	w;
{
    Widget	popup;
    int		i;
    Widget	entry;
    Boolean	isNoSecond;

    popup = XtVaCreatePopupShell(
		"optionSubMenu",	/* Widget $BL>(B */
		cascadeMenuWidgetClass,	/* Widget $B%/%i%9(B */
		w,			/* $B?F$H$J$k(B Widget */
		XtNtranslations,	XtParseTranslationTable(trans),
		NULL);			/* $B2DJQD90z?t$N=*C<(B */

    XtVaGetValues(emiclock,
		XtNnoSecond,		&isNoSecond,
		NULL);

    /* $B%a%K%e!<%"%$%F%`$N@8@.(B */
    for (i = 0; i < XtNumber(optionSubMenuEntryNames); i++) {
	String	menuItem = optionSubMenuEntryNames[i];

	entry = XtCreateManagedWidget(menuItem, smeBSBObjectClass,
							popup, NULL, 0);
	XtAddCallback(entry,
			XtNcallback, OptionSubMenuSelect, (XtPointer)i);

	if (i == 0) {
	    /* $B!HIC?KI=<(!I$N%A%'%C%/%^!<%/(B */
	    if (isNoSecond) {
		XtVaSetValues(entry, XtNleftBitmap, None, NULL);
	    } else {
		XtVaSetValues(entry, XtNleftBitmap, checkMark, NULL);
	    }
	} else if (i == 1) {
	    /* $B!H5/F02;!V$_$e$C!*!W!I$N%A%'%C%/%^!<%/(B */
	    if (IsSoundAvailable()) {
		if (app_data.isNoStartupSound) {
		    XtVaSetValues(entry, XtNleftBitmap, None, NULL);
		} else {
		    XtVaSetValues(entry, XtNleftBitmap, checkMark, NULL);
		}
	    } else {
		XtSetSensitive(entry, False);
		XtVaSetValues(entry, XtNleftBitmap, None, NULL);
	    }
	}
    }

    return(popup);
}


/*
 *  $B!H%*%W%7%g%s!I%5%V%a%K%e!<$N%3!<%k%P%C%/(B
 */
static void
OptionSubMenuSelect(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    Boolean	isNoSecond;

    XtVaGetValues(emiclock,
		XtNnoSecond,		&isNoSecond,
		NULL);

    if (strcmp(XtName(w), DISPLAY_SEC_STR) == 0) {
	/* $B!HIC?KI=<(!I$N=hM}(B */
	isNoSecond = !isNoSecond;
	XtVaSetValues(emiclock, XtNnoSecond, isNoSecond, NULL);
	if (isNoSecond) {
	    XtVaSetValues(w, XtNleftBitmap, None, NULL);
	} else {
	    XtVaSetValues(w, XtNleftBitmap, checkMark, NULL);
	}
    } else if (strcmp(XtName(w), STARTUP_SOUND_STR) == 0) {
	/* $B!H5/F02;!V$_$e$C!*!W!I$N=hM}(B */
	app_data.isNoStartupSound = !app_data.isNoStartupSound;
	if (app_data.isNoStartupSound) {
	    XtVaSetValues(w, XtNleftBitmap, None, NULL);
	} else {
	    XtVaSetValues(w, XtNleftBitmap, checkMark, NULL);
	}
    }
}


/*
 *  $B!H%A%c%$%`!I%5%V%a%K%e!<$N:n@.(B
 */
static Widget
CreateChimeSubMenu(w)
    Widget	w;
{
    Widget	popup;
    int		i;
    Widget	entry;

    popup = XtVaCreatePopupShell(
		"chimeSubMenu",		/* Widget $BL>(B */
		cascadeMenuWidgetClass,	/* Widget $B%/%i%9(B */
		w,			/* $B?F$H$J$k(B Widget */
		XtNtranslations,	XtParseTranslationTable(trans),
		NULL);			/* $B2DJQD90z?t$N=*C<(B */

    /* $B%a%K%e!<%"%$%F%`$N@8@.(B */
    for (i = 0; i < XtNumber(chimeSubMenuEntryNames); i++) {
	String	menuItem = chimeSubMenuEntryNames[i];

	if (strcmp(menuItem, LINE_STR) == 0) {	/* $B%a%K%e!<$K@~$r0z$/(B */
	    entry = XtCreateManagedWidget(menuItem, smeLineObjectClass,
							popup, NULL, 0);
	} else {
	    entry = XtCreateManagedWidget(menuItem, smeBSBObjectClass,
							popup, NULL, 0);
	    XtAddCallback(entry,
			XtNcallback, ChimeSubMenuSelect, (XtPointer)i);

	    if (strcmp(menuItem, ALARM_SETTINGS_STR) != 0) {
		if (!IsSoundAvailable()) {
		    XtSetSensitive(entry, False);
		}
	    }
	}
    }

    hourlyChimePopup = CreateHourlyChimeDialog(w,
				&hourlyChimeDialog, &hourlyChimeToggle);
    halfHourChimePopup = CreateHalfHourChimeDialog(w,
				&halfHourChimeDialog, &halfHourChimeToggle);
    noteAlarmPopup = CreateNoteAlarmDialog(w,
				&noteAlarmDialog, &noteAlarmToggle);
    alarmSettingsPopup = CreateAlarmSettingsDialog(w);

    return(popup);
}


/*
 *  $B!H(B0$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N@8@.(B
 */
static Widget
CreateHourlyChimeDialog(w, dialog, toggle)
    Widget	w;
    Widget	*dialog;
    Widget	*toggle;
{
    Widget	popup;

    popup = XtVaCreatePopupShell(
		"hourlyChimePopup",		/* Widget $BL>(B */
		transientShellWidgetClass,	/* Widget $B%/%i%9(B */
		w,				/* $B?F$H$J$k(B Widget */
		NULL);

    *dialog = XtCreateManagedWidget("hourlyChimeDialog",
					dialogWidgetClass, popup, NULL, 0);

    *toggle = XtCreateManagedWidget("soundToggle", toggleWidgetClass,
							*dialog, NULL, 0);
    XtVaSetValues(*toggle, XtNbitmap, checkBox, NULL);

    XtVaGetValues(emiclock, XtNhourlyChime, &hourlyChimeToggleState, NULL);
    if (hourlyChimeToggleState) {
	XtVaSetValues(*toggle, XtNstate, True, NULL);
    } else {
	XtVaSetValues(*toggle, XtNstate, False, NULL);
    }
    XtAddCallback(*toggle, XtNcallback, HourlyChimeDialogToggle, NULL);

    XawDialogAddButton(*dialog, "soundLabel", HourlyChimeDialogSound, NULL);

    XawDialogAddButton(*dialog, "test", DialogSoundTest, (XtPointer)(*dialog));

    XawDialogAddButton(*dialog, "ok", HourlyChimeDialogOk, NULL);
    XawDialogAddButton(*dialog, "cancel", HourlyChimeDialogCancel, NULL);

    return(popup);
}


/*
 *  $B!H(B0$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H(BOK$B!I%\%?%s=hM}(B
 */
void
HourlyChimeDialogOk(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    String	filename;

    XtVaSetValues(emiclock, XtNhourlyChime, hourlyChimeToggleState, NULL);

    filename = XawDialogGetValueString(hourlyChimeDialog);

    if (IsSoundFileExist(filename)) {
	StoreHourlyChimeFileName(filename);
	XtPopdown(hourlyChimePopup);
    } else {
	FileNotFoundDialog(w);
    }
}


/*
 *  $B!H(B0$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H(BCancel$B!I%\%?%s=hM}(B
 */
static void
HourlyChimeDialogCancel(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    XtVaGetValues(emiclock, XtNhourlyChime, &hourlyChimeToggleState, NULL);
    if (hourlyChimeToggleState) {
	XtVaSetValues(hourlyChimeToggle, XtNstate, True, NULL);
    } else {
	XtVaSetValues(hourlyChimeToggle, XtNstate, False, NULL);
    }

    XtPopdown(hourlyChimePopup);
}


/*
 *  $B!H(B0$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H%5%&%s%I!I%H%0%k%\%?%s=hM}(B
 */
static void
HourlyChimeDialogToggle(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    XtVaGetValues(w, XtNstate, &hourlyChimeToggleState, NULL);
}


/*
 *  $B!H(B0$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H%5%&%s%I!I%i%Y%k%\%?%s=hM}(B
 */
static void
HourlyChimeDialogSound(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    hourlyChimeToggleState = hourlyChimeToggleState ? False : True;
    XtVaSetValues(hourlyChimeToggle, XtNstate, hourlyChimeToggleState, NULL);
}


/*
 *  $B!H(B30$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N@8@.(B
 */
static Widget
CreateHalfHourChimeDialog(w, dialog, toggle)
    Widget	w;
    Widget	*dialog;
    Widget	*toggle;
{
    Widget	popup;

    popup = XtVaCreatePopupShell(
		"halfHourChimePopup",		/* Widget $BL>(B */
		transientShellWidgetClass,	/* Widget $B%/%i%9(B */
		w,				/* $B?F$H$J$k(B Widget */
		NULL);

    *dialog = XtCreateManagedWidget("halfHourChimeDialog",
					dialogWidgetClass, popup, NULL, 0);

    *toggle = XtCreateManagedWidget("soundToggle", toggleWidgetClass,
							*dialog, NULL, 0);
    XtVaSetValues(*toggle, XtNbitmap, checkBox, NULL);

    XtVaGetValues(emiclock, XtNhalfHourChime, &halfHourChimeToggleState, NULL);
    if (halfHourChimeToggleState) {
	XtVaSetValues(*toggle, XtNstate, True, NULL);
    } else {
	XtVaSetValues(*toggle, XtNstate, False, NULL);
    }
    XtAddCallback(*toggle, XtNcallback, HalfHourChimeDialogToggle, NULL);

    XawDialogAddButton(*dialog, "soundLabel", HalfHourChimeDialogSound, NULL);

    XawDialogAddButton(*dialog, "test", DialogSoundTest, (XtPointer)(*dialog));

    XawDialogAddButton(*dialog, "ok", HalfHourChimeDialogOk, NULL);
    XawDialogAddButton(*dialog, "cancel", HalfHourChimeDialogCancel, NULL);

    return(popup);
}


/*
 *  $B!H(B30$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H(BOK$B!I%\%?%s=hM}(B
 */
void
HalfHourChimeDialogOk(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    String	filename;

    XtVaSetValues(emiclock, XtNhalfHourChime, halfHourChimeToggleState, NULL);

    filename = XawDialogGetValueString(halfHourChimeDialog);

    if (IsSoundFileExist(filename)) {
	StoreHalfHourChimeFileName(filename);
	XtPopdown(halfHourChimePopup);
    } else {
	FileNotFoundDialog(w);
    }
}


/*
 *  $B!H(B30$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H(BCancel$B!I%\%?%s=hM}(B
 */
static void
HalfHourChimeDialogCancel(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    XtVaGetValues(emiclock, XtNhalfHourChime, &halfHourChimeToggleState, NULL);
    if (halfHourChimeToggleState) {
	XtVaSetValues(halfHourChimeToggle, XtNstate, True, NULL);
    } else {
	XtVaSetValues(halfHourChimeToggle, XtNstate, False, NULL);
    }

    XtPopdown(halfHourChimePopup);
}


/*
 *  $B!H(B30$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H%5%&%s%I!I%H%0%k%\%?%s=hM}(B
 */
static void
HalfHourChimeDialogToggle(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    XtVaGetValues(w, XtNstate, &halfHourChimeToggleState, NULL);
}


/*
 *  $B!H(B30$BJ,%A%c%$%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H%5%&%s%I!I%i%Y%k%\%?%s=hM}(B
 */
static void
HalfHourChimeDialogSound(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    halfHourChimeToggleState = halfHourChimeToggleState ? False : True;
    XtVaSetValues(halfHourChimeToggle,
				XtNstate, halfHourChimeToggleState, NULL);
}


/*
 *  $B!H%"%i!<%`%5%&%s%I(B...$B!I%@%$%"%m%0$N@8@.(B
 */
static Widget
CreateNoteAlarmDialog(w, dialog, toggle)
    Widget	w;
    Widget	*dialog;
    Widget	*toggle;
{
    Widget	popup;

    popup = XtVaCreatePopupShell(
		"noteAlarmPopup",		/* Widget $BL>(B */
		transientShellWidgetClass,	/* Widget $B%/%i%9(B */
		w,				/* $B?F$H$J$k(B Widget */
		NULL);

    *dialog = XtCreateManagedWidget("noteAlarmDialog",
					dialogWidgetClass, popup, NULL, 0);

    *toggle = XtCreateManagedWidget("soundToggle", toggleWidgetClass,
							*dialog, NULL, 0);
    XtVaSetValues(*toggle, XtNbitmap, checkBox, NULL);

    XtVaGetValues(emiclock, XtNplayAlarm, &noteAlarmToggleState, NULL);
    if (noteAlarmToggleState) {
	XtVaSetValues(*toggle, XtNstate, True, NULL);
    } else {
	XtVaSetValues(*toggle, XtNstate, False, NULL);
    }
    XtAddCallback(*toggle, XtNcallback, NoteAlarmDialogToggle, NULL);

    XawDialogAddButton(*dialog, "soundLabel", NoteAlarmDialogSound, NULL);

    XawDialogAddButton(*dialog, "test", DialogSoundTest, (XtPointer)(*dialog));

    XawDialogAddButton(*dialog, "ok", NoteAlarmDialogOk, NULL);
    XawDialogAddButton(*dialog, "cancel", NoteAlarmDialogCancel, NULL);

    return(popup);
}


/*
 *  $B!H%"%i!<%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H(BOK$B!I%\%?%s=hM}(B
 */
void
NoteAlarmDialogOk(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    String	filename;

    XtVaSetValues(emiclock, XtNplayAlarm, noteAlarmToggleState, NULL);

    filename = XawDialogGetValueString(noteAlarmDialog);

    if (IsSoundFileExist(filename)) {
	StoreAlarmFileName(filename);
	XtPopdown(noteAlarmPopup);
    } else {
	FileNotFoundDialog(w);
    }
}


/*
 *  $B!H%"%i!<%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H(BCancel$B!I%\%?%s=hM}(B
 */
static void
NoteAlarmDialogCancel(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    XtVaGetValues(emiclock, XtNplayAlarm, &noteAlarmToggleState, NULL);
    if (noteAlarmToggleState) {
	XtVaSetValues(noteAlarmToggle, XtNstate, True, NULL);
    } else {
	XtVaSetValues(noteAlarmToggle, XtNstate, False, NULL);
    }

    XtPopdown(noteAlarmPopup);
}


/*
 *  $B!H%"%i!<%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H%5%&%s%I!I%H%0%k%\%?%s=hM}(B
 */
static void
NoteAlarmDialogToggle(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    XtVaGetValues(w, XtNstate, &noteAlarmToggleState, NULL);
}


/*
 *  $B!H%"%i!<%`%5%&%s%I(B...$B!I%@%$%"%m%0$N!H%5%&%s%I!I%i%Y%k%\%?%s=hM}(B
 */
static void
NoteAlarmDialogSound(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    noteAlarmToggleState = noteAlarmToggleState ? False : True;
    XtVaSetValues(noteAlarmToggle, XtNstate, noteAlarmToggleState, NULL);
}


/*
 *  $B!H%"%i!<%`;~9o@_Dj(B...$B!I%@%$%"%m%0$N@8@.(B
 */
static Widget
CreateAlarmSettingsDialog(w)
    Widget	w;
{
    Widget	popup, form, title;
    Widget	alarmTimeLabel, timeSeparateLabel;
    Widget	alarmDateLabel;
    Widget	yearMonthSeparateLabel, monthDateSeparateLabel;
    Widget	oneTimeButton, dailyAlarmButton;
    Widget	ok, cancel;

    popup = XtVaCreatePopupShell(
		"alarmSettingsPopup",		/* Widget $BL>(B */
		transientShellWidgetClass,	/* Widget $B%/%i%9(B */
		w,				/* $B?F$H$J$k(B Widget */
		NULL);

    form = XtCreateManagedWidget("alarmSettingsForm",
					formWidgetClass, popup, NULL, 0);

    title = XtCreateManagedWidget("title", labelWidgetClass, form, NULL, 0);

    alarmTimeLabel = XtVaCreateManagedWidget("alarmTimeLabel",
    			labelWidgetClass,	form,
    			XtNfromVert,		title,
    			XtNleft,		XtChainLeft,
    			NULL);

    hourText = XtVaCreateManagedWidget("hourText",
    			asciiTextWidgetClass,	form,
    			XtNfromVert,		title,
			XtNfromHoriz,		alarmTimeLabel,
			XtNeditType,		XawtextEdit,
    			NULL);

    timeSeparateLabel = XtVaCreateManagedWidget("timeSeparateLabel",
    			labelWidgetClass,	form,
    			XtNfromVert,		title,
			XtNfromHoriz,		hourText,
    			NULL);

    minuteText = XtVaCreateManagedWidget("minuteText",
    			asciiTextWidgetClass,	form,
    			XtNfromVert,		title,
			XtNfromHoriz,		timeSeparateLabel,
			XtNeditType,		XawtextEdit,
    			NULL);

    alarmDateLabel = XtVaCreateManagedWidget("alarmDateLabel",
    			labelWidgetClass,	form,
    			XtNfromVert,		alarmTimeLabel,
    			XtNleft,		XtChainLeft,
    			NULL);

    yearText = XtVaCreateManagedWidget("yearText",
    			asciiTextWidgetClass,	form,
    			XtNfromVert,		alarmTimeLabel,
			XtNfromHoriz,		alarmDateLabel,
			XtNeditType,		XawtextEdit,
    			NULL);

    yearMonthSeparateLabel = XtVaCreateManagedWidget("yearMonthSeparateLabel",
    			labelWidgetClass,	form,
    			XtNfromVert,		alarmTimeLabel,
			XtNfromHoriz,		yearText,
    			NULL);

    monthText = XtVaCreateManagedWidget("monthText",
    			asciiTextWidgetClass,	form,
    			XtNfromVert,		alarmTimeLabel,
			XtNfromHoriz,		yearMonthSeparateLabel,
			XtNeditType,		XawtextEdit,
    			NULL);

    monthDateSeparateLabel = XtVaCreateManagedWidget("monthDateSeparateLabel",
    			labelWidgetClass,	form,
    			XtNfromVert,		alarmTimeLabel,
			XtNfromHoriz,		monthText,
    			NULL);

    dateText = XtVaCreateManagedWidget("dateText",
    			asciiTextWidgetClass,	form,
    			XtNfromVert,		alarmTimeLabel,
			XtNfromHoriz,		monthDateSeparateLabel,
			XtNeditType,		XawtextEdit,
    			NULL);

    oneTimeToggle = XtVaCreateManagedWidget("oneTimeToggle",
			toggleWidgetClass,	form,
			XtNbitmap,		checkBox,
			XtNfromVert,		alarmDateLabel,
			XtNleft,		XtChainLeft,
			NULL);
    XtVaGetValues(emiclock, XtNoneTime, &oneTimeToggleState, NULL);
    if (oneTimeToggleState) {
	XtVaSetValues(oneTimeToggle, XtNstate, True, NULL);
    } else{
	XtVaSetValues(oneTimeToggle, XtNstate, False, NULL);
    }
    XtAddCallback(oneTimeToggle, XtNcallback, OneTimeToggle, NULL);

    oneTimeButton = XtVaCreateManagedWidget("oneTimeButton",
			commandWidgetClass,	form,
			XtNfromVert,		alarmDateLabel,
			XtNfromHoriz,		oneTimeToggle,
			NULL);
    XtAddCallback(oneTimeButton, XtNcallback, OneTimeButton, NULL);

    dailyAlarmToggle = XtVaCreateManagedWidget("dailyAlarmToggle",
			toggleWidgetClass,	form,
			XtNbitmap,		checkBox,
			XtNfromVert,		oneTimeToggle,
			XtNleft,		XtChainLeft,
			NULL);
    XtVaGetValues(emiclock, XtNdailyAlarm, &dailyAlarmToggleState, NULL);
    if (dailyAlarmToggleState) {
	XtVaSetValues(dailyAlarmToggle, XtNstate, True, NULL);
    } else{
	XtVaSetValues(dailyAlarmToggle, XtNstate, False, NULL);
    }
    XtAddCallback(dailyAlarmToggle, XtNcallback, DailyAlarmToggle, NULL);

    dailyAlarmButton = XtVaCreateManagedWidget("dailyAlarmButton",
			commandWidgetClass,	form,
			XtNfromVert,		oneTimeToggle,
			XtNfromHoriz,		dailyAlarmToggle,
			NULL);
    XtAddCallback(dailyAlarmButton, XtNcallback, DailyAlarmButton, NULL);

    ok = XtVaCreateManagedWidget("ok",
			commandWidgetClass,	form,
			XtNfromVert,		dailyAlarmToggle,
			XtNleft,		XtChainLeft,
			XtNbottom,		XtChainBottom,
			NULL);
    XtAddCallback(ok, XtNcallback, AlarmSettingsDialogOk, NULL);

    cancel = XtVaCreateManagedWidget("cancel",
			commandWidgetClass,	form,
			XtNfromVert,		dailyAlarmToggle,
			XtNfromHoriz,		ok,
			XtNbottom,		XtChainBottom,
			NULL);
    XtAddCallback(cancel, XtNcallback, AlarmSettingsDialogCancel, NULL);

    AlarmTimeDateTextSet();

    return(popup);
}


/*
 *  $B!H%"%i!<%`;~9o@_Dj(B...$B!I%@%$%"%m%0$N!H#12s$@$1DLCN$9$k!I%H%0%k%\%?%s=hM}(B
 */
static void
OneTimeToggle(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    XtVaGetValues(w, XtNstate, &oneTimeToggleState, NULL);

    ResetDailyAlarmToggle();
}


/*
 *  $B!H%"%i!<%`;~9o@_Dj(B...$B!I%@%$%"%m%0$N!H#12s$@$1DLCN$9$k!I%i%Y%k%\%?%s=hM}(B
 */
static void
OneTimeButton(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    oneTimeToggleState = oneTimeToggleState ? False : True;
    XtVaSetValues(oneTimeToggle, XtNstate, oneTimeToggleState, NULL);

    ResetDailyAlarmToggle();
}


/*
 *  $B!H%"%i!<%`;~9o@_Dj(B...$B!I%@%$%"%m%0$N!HKhF|DLCN$9$k!I%H%0%k%\%?%s%j%;%C%H(B
 */
static void
ResetDailyAlarmToggle()
{
    if (oneTimeToggleState && dailyAlarmToggleState) {
	dailyAlarmToggleState = False;
	XtVaSetValues(dailyAlarmToggle, XtNstate, dailyAlarmToggleState, NULL);
    }
}


/*
 *  $B!H%"%i!<%`;~9o@_Dj(B...$B!I%@%$%"%m%0$N!HKhF|DLCN$9$k!I%H%0%k%\%?%s=hM}(B
 */
static void
DailyAlarmToggle(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    XtVaGetValues(w, XtNstate, &dailyAlarmToggleState, NULL);

    ResetOneTimeToggle();
}


/*
 *  $B!H%"%i!<%`;~9o@_Dj(B...$B!I%@%$%"%m%0$N!HKhF|DLCN$9$k!I%i%Y%k%\%?%s=hM}(B
 */
static void
DailyAlarmButton(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    dailyAlarmToggleState = dailyAlarmToggleState ? False : True;
    XtVaSetValues(dailyAlarmToggle, XtNstate, dailyAlarmToggleState, NULL);

    ResetOneTimeToggle();
}


/*
 *  $B!H%"%i!<%`;~9o@_Dj(B...$B!I%@%$%"%m%0$N!H#12s$@$1DLCN$9$k!I%H%0%k%\%?%s%j%;%C%H(B
 */
static void
ResetOneTimeToggle()
{
    if (oneTimeToggleState && dailyAlarmToggleState) {
	oneTimeToggleState = False;
	XtVaSetValues(oneTimeToggle, XtNstate, oneTimeToggleState, NULL);
    }
}


/*
 *  $B%"%i!<%`;~9o$r4IM}$9$k(B AsciiText Widget $B$N(B XtNstring $B@_Dj(B
 */
static void
AlarmTimeDateTextSet()
{
    AlarmTime	*alarmTime;
    char	buffer[BUFSIZ];

    XtVaGetValues(emiclock, XtNalarmTime, &alarmTime, NULL);

    sprintf(buffer, "%02d", alarmTime->hour);
    XtVaSetValues(hourText, XtNstring, XtNewString(buffer), NULL);
    sprintf(buffer, "%02d", alarmTime->minute);
    XtVaSetValues(minuteText, XtNstring, XtNewString(buffer), NULL);
    sprintf(buffer, "%04d", alarmTime->year);
    XtVaSetValues(yearText, XtNstring, XtNewString(buffer), NULL);
    sprintf(buffer, "%02d", alarmTime->month);
    XtVaSetValues(monthText, XtNstring, XtNewString(buffer), NULL);
    sprintf(buffer, "%02d", alarmTime->date);
    XtVaSetValues(dateText, XtNstring, XtNewString(buffer), NULL);

    XtVaSetValues(hourText, XtNinsertPosition, 2, NULL);
    XtVaSetValues(minuteText, XtNinsertPosition, 2, NULL);
    XtVaSetValues(yearText, XtNinsertPosition, 4, NULL);
    XtVaSetValues(monthText, XtNinsertPosition, 2, NULL);
    XtVaSetValues(dateText, XtNinsertPosition, 2, NULL);
}


/*
 *  $B!H%"%i!<%`;~9o@_Dj(B...$B!I%@%$%"%m%0$N!H(BOK$B!I%\%?%s=hM}(B
 */
void
AlarmSettingsDialogOk(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    AlarmTime	*alarmTime;
    String	str;

    XtVaGetValues(emiclock, XtNalarmTime, &alarmTime, NULL);

    XtVaGetValues(hourText, XtNstring, &str, NULL);
    alarmTime->hour = atoi(str);
    XtVaGetValues(minuteText, XtNstring, &str, NULL);
    alarmTime->minute = atoi(str);
    XtVaGetValues(yearText, XtNstring, &str, NULL);
    alarmTime->year = atoi(str);
    XtVaGetValues(monthText, XtNstring, &str, NULL);
    alarmTime->month = atoi(str);
    XtVaGetValues(dateText, XtNstring, &str, NULL);
    alarmTime->date = atoi(str);

    /* $B%"%i!<%`;~9o$N@5Ev@-$N%A%'%C%/(B */
    if (alarmTime->hour < 0) {
	alarmTime->hour = 0;
    } else if (alarmTime->hour > 23) {
	alarmTime->hour = 23;
    }
    if (alarmTime->minute < 0) {
	alarmTime->minute = 0;
    } else if (alarmTime->minute > 59) {
	alarmTime->minute = 59;
    }
    if (alarmTime->year < 0) {
	alarmTime->year = 0;
    }
    if (alarmTime->month < 1) {
	alarmTime->month = 1;
    } else if (alarmTime->month > 12) {
	alarmTime->month = 12;
    }
    if (alarmTime->date < 1) {
	alarmTime->date = 1;
    } else if (alarmTime->date > 31) {
	alarmTime->date = 31;
    }

    AlarmTimeDateTextSet();

    XtVaSetValues(emiclock, XtNoneTime, oneTimeToggleState, NULL);
    XtVaSetValues(emiclock, XtNdailyAlarm, dailyAlarmToggleState, NULL);

    XtPopdown(alarmSettingsPopup);
}


/*
 *  $B!H%"%i!<%`;~9o@_Dj(B...$B!I%@%$%"%m%0$N!H(BCancel$B!I%\%?%s=hM}(B
 */
static void
AlarmSettingsDialogCancel(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    AlarmTimeDateTextSet();

    XtVaGetValues(emiclock, XtNoneTime, &oneTimeToggleState, NULL);
    if (oneTimeToggleState) {
	XtVaSetValues(oneTimeToggle, XtNstate, True, NULL);
    } else {
	XtVaSetValues(oneTimeToggle, XtNstate, False, NULL);
    }

    XtVaGetValues(emiclock, XtNdailyAlarm, &dailyAlarmToggleState, NULL);
    if (dailyAlarmToggleState) {
	XtVaSetValues(dailyAlarmToggle, XtNstate, True, NULL);
    } else {
	XtVaSetValues(dailyAlarmToggle, XtNstate, False, NULL);
    }

    XtPopdown(alarmSettingsPopup);
}


/*
 *  $B!H%A%c%$%`!I%5%V%a%K%e!<$N%3!<%k%P%C%/(B
 */
static void
ChimeSubMenuSelect(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    int	menuNo = (int)client_data;

    if (((menuNo >= 0) && (menuNo <= 1)) ||
		((menuNo >= 3) && (menuNo <= 4))) {
	switch (menuNo) {
	case 0:
	    /* Hourly chime... */
	    XtVaSetValues(hourlyChimeDialog,
	    	XtNvalue,	GetHourlyChimeFileName(),
	    	NULL);
	    PlaceMenu(hourlyChimePopup);
	    XtPopup(hourlyChimePopup, XtGrabNone);
	    break;
	case 1:
	    /* Half hour chime... */
	    XtVaSetValues(halfHourChimeDialog,
	    	XtNvalue,	GetHalfHourChimeFileName(),
	    	NULL);
	    PlaceMenu(halfHourChimePopup);
	    XtPopup(halfHourChimePopup, XtGrabNone);
	    break;
	case 3:
	    /* Note Alarm... */
	    XtVaSetValues(noteAlarmDialog,
	    	XtNvalue,	GetAlarmFileName(),
	    	NULL);
	    PlaceMenu(noteAlarmPopup);
	    XtPopup(noteAlarmPopup, XtGrabNone);
	    break;
	case 4:
	    /* Alarm settings... */
	    PlaceMenu(alarmSettingsPopup);
	    XtPopup(alarmSettingsPopup, XtGrabNone);
	    break;
	}
    }
}


/*
 *  $B!HCe$;BX$(!I%5%V%a%K%e!<$N:n@.(B
 */
static Widget
CreateCostumesSubMenu(w)
    Widget	w;
{
    Widget	popup;
    int		i;
    char	instanceStrBuf[COSTUME_STR_LEN];
    Widget	entry;
    int		charNo;
    Boolean	isTransparent, isHourlyCharChange, isAnimateCharacter;

    popup = XtVaCreatePopupShell(
		"costumesSubMenu",	/* Widget $BL>(B */
		cascadeMenuWidgetClass,	/* Widget $B%/%i%9(B */
		w,			/* $B?F$H$J$k(B Widget */
		XtNtranslations,	XtParseTranslationTable(trans),
		NULL);			/* $B2DJQD90z?t$N=*C<(B */

    XtVaGetValues(emiclock,
		XtNcharNo,			&charNo,
		XtNtransparent,			&isTransparent,
		XtNhourlyCharacterChange,	&isHourlyCharChange,
		XtNanimateCharacter,		&isAnimateCharacter,
		NULL);

    /* $B%a%K%e!<%"%$%F%`$N@8@.(B */
    for (i = 0; i < NUM_OF_CHAR; i++) {
	sprintf(instanceStrBuf, "%s%d", COSTUME_BASE_STR, i);
	charItem[i] = XtCreateManagedWidget(instanceStrBuf,
					smeBSBObjectClass, popup, NULL, 0);
	XtAddCallback(charItem[i],
		XtNcallback, CostumesSubMenuSelect, (XtPointer)i);

	/* $B%A%'%C%/%^!<%/$N@_Dj(B */
	if (i == charNo) {
	    XtVaSetValues(charItem[i], XtNleftBitmap, checkMark, NULL);
	}

	if (i == (NUM_OF_CHAR - 1)) {
	    /* $B$_$($J$$%I%l%9$N%a%K%e!<@_Dj(B */
	    if (!isTransparent) {
		XtSetSensitive(charItem[i], False);
	    }
	}
    }

    /* $B@~$r0z$/(B */
    entry = XtCreateManagedWidget(LINE_STR,
					smeLineObjectClass, popup, NULL, 0);

    /* $B!H#1;~4V$*$-$KJQ99!I$N%a%K%e!<(B */
    entry = XtCreateManagedWidget(HOURLY_CHAR_CHANGE_STR,
					smeBSBObjectClass, popup, NULL, 0);
    XtAddCallback(entry, XtNcallback, CostumesSubMenuSelect, NULL);

    /* $B!H#1;~4V$*$-$KJQ99!I$N%A%'%C%/%^!<%/$N@_Dj(B */
    if (isHourlyCharChange) {
	XtVaSetValues(entry, XtNleftBitmap, checkMark, NULL);
    } else {
	XtVaSetValues(entry, XtNleftBitmap, None, NULL);
    }

    /* $B!H#1J,$4$H$KH?E>%"%K%a!I$N%a%K%e!<(B */
    entry = XtCreateManagedWidget(ANIMATE_CHARACTER_STR,
					smeBSBObjectClass, popup, NULL, 0);
    XtAddCallback(entry, XtNcallback, CostumesSubMenuSelect, NULL);

    /* $B!H#1J,$4$H$KH?E>%"%K%a!I$N%A%'%C%/%^!<%/$N@_Dj(B */
    if (isAnimateCharacter) {
	XtVaSetValues(entry, XtNleftBitmap, checkMark, NULL);
    } else {
	XtVaSetValues(entry, XtNleftBitmap, None, NULL);
    }

    /* $B%a%K%e!<$N%A%'%C%/9`L\$rJQ99$9$k%3!<%k%P%C%/$N@_Dj(B */
    XtAddCallback(emiclock,
		XtNcostumesMenuClearCallback, CharMenuCheckItemClear, NULL);
    XtAddCallback(emiclock,
		XtNcostumesMenuSetCallback, CharMenuCheckItemSet, NULL);
    XtAddCallback(emiclock, XtNtransparentCallback, CanTransparent, NULL);

    return(popup);
}


/*
 *  $B%a%K%e!<$N%-%c%i%/%?%A%'%C%/9`L\$N>C5n(B
 */
static void
CharMenuCheckItemClear(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    int	charNo = (int)call_data;

    if ((charNo >= 0) && (charNo < NUM_OF_CHAR) ) {
	XtVaSetValues(charItem[charNo], XtNleftBitmap, None, NULL);
    }
}


/*
 *  $B%a%K%e!<$N%-%c%i%/%?%A%'%C%/9`L\$N@_Dj(B
 */
static void
CharMenuCheckItemSet(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    int	charNo = (int)call_data;

    if ((charNo >= 0) && (charNo < NUM_OF_CHAR) ) {
	XtVaSetValues(charItem[charNo], XtNleftBitmap, checkMark, NULL);
    }
}


/*
 *  $B$_$($J$$%I%l%9$NA*Br5v2D(B
 */
static void
CanTransparent(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    XtSetSensitive(charItem[NUM_OF_CHAR - 1], True);
}


/*
 *  $B!HCe$;BX$(!I%5%V%a%K%e!<$N%3!<%k%P%C%/(B
 */
static void
CostumesSubMenuSelect(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    if (strcmp(XtName(w), HOURLY_CHAR_CHANGE_STR) == 0) {
	/* $B!H#1;~4V$*$-$KJQ99!I$,A*$P$l$?(B */
	Boolean	isHourlyCharChange;

	XtVaGetValues(emiclock,
		XtNhourlyCharacterChange, &isHourlyCharChange, NULL);

	isHourlyCharChange = !isHourlyCharChange;
	XtVaSetValues(emiclock,
		XtNhourlyCharacterChange, isHourlyCharChange, NULL);

	if (isHourlyCharChange) {
	    XtVaSetValues(w, XtNleftBitmap, checkMark, NULL);
	} else {
	    XtVaSetValues(w, XtNleftBitmap, None, NULL);
	}
    } else if (strcmp(XtName(w), ANIMATE_CHARACTER_STR) == 0) {
	/* $B!H#1J,$4$H$KH?E>%"%K%a!I$,A*$P$l$?(B */
	Boolean	isAnimateCharacter;

	XtVaGetValues(emiclock,
		XtNanimateCharacter, &isAnimateCharacter, NULL);

	isAnimateCharacter = !isAnimateCharacter;
	XtVaSetValues(emiclock, XtNanimateCharacter, isAnimateCharacter, NULL);

	if (isAnimateCharacter) {
	    XtVaSetValues(w, XtNleftBitmap, checkMark, NULL);
	} else {
	    XtVaSetValues(w, XtNleftBitmap, None, NULL);
	    XtVaSetValues(emiclock, XtNreverseCharacter, (Boolean)False, NULL);
	}
    } else {
	/* $B%-%c%i%/%?$NJQ99(B */
	XtVaSetValues(emiclock, XtNcanUpdateTimer, (Boolean)False, NULL);
	XtVaSetValues(emiclock, XtNreverseCharacter, (Boolean)False, NULL);
	XtVaSetValues(emiclock, XtNcanUpdateTimer, (Boolean)True, NULL);
	XtVaSetValues(emiclock, XtNcharNo, (int)client_data, NULL);
    }
}


/*
 *  $B!HJ8;zHW!I%5%V%a%K%e!<$N:n@.(B
 */
static Widget
CreateFaceSubMenu(w)
    Widget	w;
{
    Widget	popup;
    int		i;
    int		cbaseNo;

    popup = XtVaCreatePopupShell(
		"faceSubMenu",		/* Widget $BL>(B */
		cascadeMenuWidgetClass,	/* Widget $B%/%i%9(B */
		w,			/* $B?F$H$J$k(B Widget */
		XtNtranslations,	XtParseTranslationTable(trans),
		NULL);			/* $B2DJQD90z?t$N=*C<(B */

    XtVaGetValues(emiclock, XtNcbaseNo, &cbaseNo, NULL);

    /* $B%a%K%e!<%"%$%F%`$N@8@.(B */
    for (i = 0; i < XtNumber(faceSubMenuEntryNames); i++) {
	String	menuItem = faceSubMenuEntryNames[i];

	cbaseItem[i] = XtCreateManagedWidget(menuItem, smeBSBObjectClass,
							popup, NULL, 0);
	XtAddCallback(cbaseItem[i],
			XtNcallback, FaceSubMenuSelect, (XtPointer)i);
    }

    /* $B%A%'%C%/%^!<%/$N@_Dj(B */
    if (cbaseNo == 0) {
	XtVaSetValues(cbaseItem[0], XtNleftBitmap, checkMark, NULL);
	XtVaSetValues(cbaseItem[1], XtNleftBitmap, None, NULL);
	XtVaSetValues(cbaseItem[2], XtNleftBitmap, None, NULL);
    } else if (cbaseNo == 1) {
	XtVaSetValues(cbaseItem[0], XtNleftBitmap, checkMark, NULL);
	XtVaSetValues(cbaseItem[1], XtNleftBitmap, None, NULL);
	XtVaSetValues(cbaseItem[2], XtNleftBitmap, None, NULL);
    } else {
	XtVaSetValues(cbaseItem[0], XtNleftBitmap, None, NULL);
	XtVaSetValues(cbaseItem[1], XtNleftBitmap, None, NULL);
	XtVaSetValues(cbaseItem[2], XtNleftBitmap, checkMark, NULL);
    }

    return(popup);
}


/*
 *  $B!HJ8;zHW!I%5%V%a%K%e!<$N%3!<%k%P%C%/(B
 */
static void
FaceSubMenuSelect(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    int		cbaseNo;

    if (strcmp(XtName(w), PICTURE_STR) == 0) {
	/* $B!H%T%/%A%c!J@D!K!I$,A*$P$l$?(B */
	cbaseNo = 0;
	XtVaSetValues(cbaseItem[0], XtNleftBitmap, checkMark, NULL);
	XtVaSetValues(cbaseItem[1], XtNleftBitmap, None, NULL);
	XtVaSetValues(cbaseItem[2], XtNleftBitmap, None, NULL);
    } else if (strcmp(XtName(w), NUMBER_STR) == 0) {
	/* $B!H?t;z!J@V!K!I$,A*$P$l$?(B */
	cbaseNo = 1;
	XtVaSetValues(cbaseItem[0], XtNleftBitmap, None, NULL);
	XtVaSetValues(cbaseItem[1], XtNleftBitmap, checkMark, NULL);
	XtVaSetValues(cbaseItem[2], XtNleftBitmap, None, NULL);
    } else {
	/* $B!H5U2sE>!JNP!K!I$,A*$P$l$?(B */
	cbaseNo = 2;
	XtVaSetValues(cbaseItem[0], XtNleftBitmap, None, NULL);
	XtVaSetValues(cbaseItem[1], XtNleftBitmap, None, NULL);
	XtVaSetValues(cbaseItem[2], XtNleftBitmap, checkMark, NULL);
    }

    XtVaSetValues(emiclock, XtNcbaseNo, cbaseNo, NULL);
}


/*
 *  $B!H(BAbout Emi Clock...$B!I%@%$%"%m%0$N:n@.(B
 */
static Widget
CreateAboutDialog(w)
    Widget	w;
{
    Widget	popup;

    static String	trans =
		"<Expose>:	redrawCreditPicture()\n\
		 <BtnDown>:	dialogButtonPress()";

    popup = XtVaCreatePopupShell(
		"aboutPopup",			/* Widget $BL>(B */
		transientShellWidgetClass,	/* Widget $B%/%i%9(B */
		w,				/* $B?F$H$J$k(B Widget */
		NULL);				/* $B2DJQD90z?t$N=*C<(B */

    aboutPicture = XtVaCreateManagedWidget(
		"aboutPicture",			/* Widget $BL>(B */
		widgetClass,			/* Widget $B%/%i%9(B */
		popup,				/* $B?F$H$J$k(B Widget */
		XtNwidth,		CREDIT_WIDTH,
		XtNheight,		CREDIT_HEIGHT,
		XtNtranslations,	XtParseTranslationTable(trans),
		NULL);				/* $B2DJQD90z?t$N=*C<(B */

    copyGC = XCreateGC(XtDisplay(w),
			RootWindowOfScreen(XtScreen(w)), 0L, NULL);

    return(popup);
}


/*
 *  $B%a%$%s%a%K%e!<0LCV$N@_Dj(B
 */
void
PlaceMainMenu(w, event, params, numParams)
    Widget		w;
    XButtonEvent	*event;
    String		*params;
    Cardinal		*numParams;
{
    PlaceMenu(mainMenu);
}


/*
 *  $B%a%K%e!<0LCV$N@_Dj(B
 */
static void
PlaceMenu(w)
    Widget		w;
{
    Dimension		width;
    Window		root_return, child_return;
    int			root_x_return, root_y_return;
    int			win_x_return, win_y_return;
    unsigned int	mask_return;
    Position		x, y;

    if (!XtIsRealized(w)) {
	/*
	 *  $B%]%C%W%"%C%W%a%K%e!<$,%j%"%i%$%:$7$F$$$J$$>l9g$O%j%"%i%$%:$9$k(B
	 *  ($B%a%K%e!<$NI}$rF@$k$?$a(B)
	 */
	XtRealizeWidget(w);
    }

    /* $BLp0u%+!<%=%k$N@_Dj(B */
    XDefineCursor(XtDisplay(w), XtWindow(w), arrowCurs);

    /* $B%]%C%W%"%C%W%a%K%e!<$NI}$rF@$k(B */
    XtVaGetValues(w, XtNwidth, &width, NULL);

    /* $B%k!<%H%&%#%s%I%&>e$N%^%&%9:BI8$rF@$k(B */
    if (XQueryPointer(XtDisplay(w), XtWindow(w),
		&root_return, &child_return,
		&root_x_return, &root_y_return,
		&win_x_return, &win_y_return, &mask_return)) {
	x = root_x_return - (width / 2);
	y = root_y_return;
    } else {
	Dimension	parentWidth, parentHeight;

	/* $B%]%C%W%"%C%W$r8F$S=P$7$?(B Widget $B$N%5%$%:$rF@$k(B */
	XtVaGetValues(w,
		XtNwidth,	&parentWidth,
		XtNheight,	&parentHeight,
		NULL);

	/* Widget $BAjBP:BI8$+$i(B root $B%&%#%s%I%&>e$N@dBP:BI8$r5a$a$k(B */
	XtTranslateCoords(w,
		(Position)((parentWidth / 2) - (width / 2)),	/* x */
		(Position)(parentHeight / 2),			/* y */
		&x, &y);
    }

    /* $B%]%C%W%"%C%W$,=P$F$/$k:BI8$r@_Dj$9$k(B */
    XtVaSetValues(w,
		XtNx,	x,
		XtNy,	y,
		NULL);

    /* $B%k!<%H%&%#%s%I%&$+$i$O$_=P$5$J$$$h$&$KD4@0$9$k(B */
    AdjustRoot(w);
}


/*
 *  Widget $B$N0LCVD4@0(B
 */
static void
AdjustRoot(w)
    Widget	w;
{
    Dimension	width, height;
    Position	x, y;
    Boolean	isRePositon = False;

    /* Widget $B$NI}$H9b$5$rF@$k(B */
    XtVaGetValues(w,
		XtNwidth,	&width,
		XtNheight,	&height,
		NULL);

    /* Widget $B$N(B root $B%&%#%s%I%&$K$*$1$k@dBP:BI8$r5a$a$k(B */
    XtTranslateCoords(w,
		(Position)0,	/* x */
		(Position)0,	/* y */
		&x, &y);

    /* $B#X:BI8$N%A%'%C%/(B */
    if (x < 0) {
	x = 0;
	isRePositon = True;
    } else if (x > (WidthOfScreen(XtScreen(w)) - width)) {
	x = WidthOfScreen(XtScreen(w)) - width;
	isRePositon = True;
    }

    /* $B#Y:BI8$N%A%'%C%/(B */
    if (y < 0) {
	y = 0;
	isRePositon = True;
    } else if (y > (HeightOfScreen(XtScreen(w)) - height)) {
	y = HeightOfScreen(XtScreen(w)) - height;
	isRePositon = True;
    }

    if (isRePositon) {
	/* $B%]%C%W%"%C%W$,=P$F$/$k:BI8$r:F@_Dj$9$k(B */
	XtVaSetValues(w,
		XtNx,	x,
		XtNy,	y,
		NULL);
    }
}


/*
 *  $B%/%l%8%C%H2hA|$N@8@.(B
 */
static Pixmap
CreateCreditPixmap(w, no)
    Widget	w;
    int		no;
{
    Boolean	isMono, isGrayscale, isGray4, isPerfect;
    Cardinal	depth;
    Pixmap	pixmap;

    XtVaGetValues(emiclock,
		XtNmono,		&isMono,
		XtNgrayscale,		&isGrayscale,
		XtNgray4,		&isGray4,
		XtNperfect,		&isPerfect,
		XtNdepth,		&depth,
		NULL);

    if (!isMono) {
	XImage	*image;

	pixmap = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
			CREDIT_WIDTH, CREDIT_HEIGHT, depth);
	image = PImage2XImage(w, DefaultColormap(XtDisplay(w),
					DefaultScreen(XtDisplay(w))),
				creditPImageTable[no],
				GetPixelTable(emiclock),
				creditPixels, &numOfcreditPixels,
				isGrayscale, isGray4, isPerfect);
	XPutImage(XtDisplay(w), pixmap, copyGC, image, 0, 0, 0, 0,
						CREDIT_WIDTH, CREDIT_HEIGHT);
	XtFree(image->data);
	XFree(image);
    } else {
	pixmap = BitmapTable2Pixmap(w, &(creditBitmapTable[no]));
    }

    return(pixmap);
}


/*
 *  $B%/%l%8%C%H$N3($NIA$-D>$7(B
 */
void
RedrawCreditPicture(w, event, params, numParams)
    Widget	w;
    XEvent	*event;
    String	*params;
    Cardinal	*numParams;
{
    if ((event->xexpose.count == 0) && (creditPixmap != (Pixmap)NULL)) {
	XCopyArea(XtDisplay(w), creditPixmap, XtWindow(aboutPicture),
			copyGC, 0, 0, CREDIT_WIDTH, CREDIT_HEIGHT, 0, 0);
    }
}


/*
 *  $B%/%l%8%C%HI=<(%@%$%"%m%0$N%\%?%s=hM}(B
 */
void
DialogButtonPress(w, event, params, numParams)
    Widget		w;
    XButtonEvent	*event;
    String		*params;
    Cardinal		*numParams;
{
    Boolean	isMono;
    Cardinal	depth;
    int		i;
    AllocPixel	prevCreditPixels[PIXELS_8];
    int		prevNumOfcreditPixels;

    XtVaGetValues(emiclock,
		XtNmono,		&isMono,
		XtNdepth,		&depth,
		NULL);

    /* $B0JA0@8@.$7$?%/%l%8%C%H$G;H$C$F$$$?%+%i!<%;%k$NB`Hr(B */
    if (!isMono && (depth <= 8)) {
	for (i = 0; i < numOfcreditPixels; i++) {
	    prevCreditPixels[i] = creditPixels[i];
	    prevNumOfcreditPixels = numOfcreditPixels;
	}
    }

    if (creditPixmap != (Pixmap)NULL) {
	XFreePixmap(XtDisplay(w), creditPixmap);
	creditPixmap = (Pixmap)NULL;
    }

    creditNo++;

    if (creditNo < NUM_OF_CREDIT) {
	creditPixmap = CreateCreditPixmap(w, creditNo);
	XCopyArea(XtDisplay(w), creditPixmap, XtWindow(aboutPicture),
			copyGC, 0, 0, CREDIT_WIDTH, CREDIT_HEIGHT, 0, 0);
    }

    /* $B%+%i!<%;%k3+J|(B */
    if (!isMono && (depth <= 8)) {
	unsigned long	unNeedPixels[PIXELS_8];
	int		numOfUnNeedPixels;
	int		i;

	for (i = 0, numOfUnNeedPixels = 0; i < prevNumOfcreditPixels; i++) {
	    if (prevCreditPixels[i].isAlloc) {
		unNeedPixels[numOfUnNeedPixels++] =
					prevCreditPixels[i].pixel;
	    }
	}
	XeFreeColors(XtDisplay(w), DefaultColormap(XtDisplay(w),
					DefaultScreen(XtDisplay(w))),
				GetPixelTable(emiclock),
				unNeedPixels, numOfUnNeedPixels, 0L);
    }

    if (creditNo >= NUM_OF_CREDIT) {
	XtPopdown(aboutPopup);
    }
}


/*
 *  EmiClock Widget $B$N%+!<%=%k:F@_Dj(B
 */
void
SetNeko1Curs(w, event, params, numParams)
    Widget		w;
    XButtonEvent	*event;
    String		*params;
    Cardinal		*numParams;
{
    XDefineCursor(XtDisplay(emiclock), XtWindow(emiclock),
						GetNeko1Curs(emiclock));
}


/*
 *  $B!H%5%&%s%I%U%!%$%k$,$_$D$+$j$^$;$s!I7Y9p%@%$%"%m%0(B
 */
static void
FileNotFoundDialog(w)
    Widget	w;
{
    Widget	popup, dialog;

    popup = XtVaCreatePopupShell(
		"fileNotFoundPopup",		/* Widget $BL>(B */
		transientShellWidgetClass,	/* Widget $B%/%i%9(B */
		w,				/* $B?F$H$J$k(B Widget */
		NULL);

    dialog = XtCreateManagedWidget("fileNotFoundDialog",
					dialogWidgetClass, popup, NULL, 0);
    XtVaSetValues(dialog, XtNicon, noticeMark, NULL);
    XawDialogAddButton(dialog, "ok", FileNotFoundDialogOk, (XtPointer)dialog);

    PlaceMenu(popup);
    XtPopup(popup, XtGrabExclusive);
}


/*
 *  $B!H%5%&%s%I%U%!%$%k$,$_$D$+$j$^$;$s!I%@%$%"%m%0$N!H(BOK$B!I%\%?%s=hM}(B
 */
static void
FileNotFoundDialogOk(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    Widget	popup = XtParent((Widget)client_data);
    XtDestroyWidget(popup);
}


/*
 *  $B%@%$%"%m%0$N!H(B($B%5%&%s%I(B)$B%F%9%H!I%\%?%s=hM}(B
 */
static void
DialogSoundTest(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    String	filename;

    filename = XawDialogGetValueString((Widget)client_data);

    if (IsSoundFileExist(filename)) {
	SoundTest((char *)filename);
    } else {
	FileNotFoundDialog(w);
    }
}


/*
 *  $B!H%"%i!<%`$G@_Dj$7$?;~9o$@$h!I%@%$%"%m%0(B
 */
void
AlarmDialogPopup(w)
    Widget	w;
{
    Widget	popup, dialog;

    popup = XtVaCreatePopupShell(
		"alarmPopup",			/* Widget $BL>(B */
		transientShellWidgetClass,	/* Widget $B%/%i%9(B */
		w,				/* $B?F$H$J$k(B Widget */
		NULL);

    dialog = XtCreateManagedWidget("alarmDialog",
					dialogWidgetClass, popup, NULL, 0);
    XtVaSetValues(dialog, XtNicon, noticeMark, NULL);
    XawDialogAddButton(dialog, "ok", AlarmDialogOk, (XtPointer)dialog);

    CenterMenu(popup);
    XtPopup(popup, XtGrabExclusive);
}


/*
 *  $B!H%"%i!<%`$G@_Dj$7$?;~9o$@$h!I%@%$%"%m%0$N!H(BOK$B!I%\%?%s=hM}(B
 */
static void
AlarmDialogOk(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    Widget	popup = XtParent((Widget)client_data);
    XtDestroyWidget(popup);
}


/*
 *  $B%a%K%e!<$NCf1{I=<((B
 */
static void
CenterMenu(w)
    Widget		w;
{
    Dimension		width, height;
    Window		root;
    int			x, y;
    unsigned int	root_width, root_height, border_width, depth;

    if (!XtIsRealized(w)) {
	/*
	 *  $B%]%C%W%"%C%W%a%K%e!<$,%j%"%i%$%:$7$F$$$J$$>l9g$O%j%"%i%$%:$9$k(B
	 *  ($B%a%K%e!<$NI}$rF@$k$?$a(B)
	 */
	XtRealizeWidget(w);
    }

    /* $BLp0u%+!<%=%k$N@_Dj(B */
    XDefineCursor(XtDisplay(w), XtWindow(w), arrowCurs);

    /* $B%]%C%W%"%C%W%a%K%e!<$NI}$H9b$5$rF@$k(B */
    XtVaGetValues(w,
		XtNwidth,	&width,
		XtNheight,	&height,
		NULL);

    /* $B%k!<%H%&%#%s%I%&$NI}$H9b$5$rF@$k(B */
    XGetGeometry(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
			&root, &x, &y, &root_width, &root_height,
			&border_width, &depth);

    /* $B%]%C%W%"%C%W$,=P$F$/$k:BI8$r:F@_Dj$9$k(B */
    x = (root_width - width) / 2;
    y = (root_height - height) / 2;
    XtVaSetValues(w,
		XtNx,	x,
		XtNy,	y,
		NULL);
}
