/* $Id: sound.h,v 1.2 1999/09/02 14:34:10 koba Exp $
 *
 *  Emi Clock $B!=(B $B%5%&%s%I4D6-$N@_Dj(B
 */

/*
 *  Copyright (c) 1994, 1995, 1997, 1999 Masayuki Koba,
 *                                       Ken, SHIBATA,
 *                                       Tomoyuki Shiraishi,
 *                                       Kazuhiko Ishii,
 *                                       Shinya Yamada,
 *                                       Kenji Nishiyama
 *
 *  $BK\%=%U%H%&%'%"$N%=!<%9$d%P%$%J%j$r:FG[I[$9$k>l9g$O!"<!$N>r7o$r=e<i$7$F(B
 *  $B2<$5$$!#(B
 *
 *  1. $BK\%=%U%H%&%'%"$rF~<j$7$?J}$K$O!"(BX11$BHG(B Emi Clock $B$N;HMQ8"$H!"Bh;0<T(B
 *     $B$X$N:FG[I[8"$,G'$a$i$l$^$9!#$?$@$7!":FG[I[$K4X$7$F$O!"F~<j;~$N%*%j(B
 *     $B%8%J%k$N$^$^2~JQ$;$:$K9T$&$3$H$,>r7o$G$9!#(B
 *  2. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$G2~JQ$7$FG[I[$9$k$3(B
 *     $B$H$O$G$-$^$;$s!#(B
 *  3. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$GFs<!MxMQ$9$k$3$H$O(B
 *     $B$G$-$^$;$s!#(B
 *  4. $BK\%=%U%H%&%'%"$r%7%9%F%`$K%P%s%I%k$7$?$j!"%7%9%F%`$NDI2C%Q%C%1!<%8(B
 *     $B$H$7$FBh;0<T$K:FG[I[$7$?$j$9$k>l9g$O!";vA0$KCx:n8"<T$K5v2D$,I,MW$G(B
 *     $B$9!#(B
 *  5. $BK\%=%U%H%&%'%"$r>&MQ$K;HMQ$9$k>l9g(B($B6bA,E*Mx1W$rF@$k>l9g(B)$B$O!";vA0$K(B
 *     $BCx:n8"<T$K5v2D$,I,MW$G$9!#$3$N>l9g!"4pK\E*$KM-=~$H$J$j$^$9!#(B
 *  6. $BK\%=%U%H%&%'%"$rMxMQ$9$k$3$H$K$h$C$FH/@8$7$?$$$+$J$kB;32$b!"Cx:n8"(B
 *     $B<T$OIi$o$J$$$b$N$H$7$^$9!#$3$l$K9g0U$G$-$J$$>l9g$O!";HMQ8"$,$J$$$b(B
 *     $B$N$H$7$^$9!#(B
 *  7. $B!H(BEmi Clock$B!I$N>&I8$*$h$SK\%=%U%H%&%'%"$N2hA|$d%G%6%$%s$K4X$9$kCx:n(B
 *     $B8"$O!"(BMotosoft $B$3$H!HK\(B $B=SLi!I;a$,M-$7$^$9!#(B
 *  8. $B!H(BEmi Clock$B!I$N>&I8$*$h$S2hA|$d%G%6%$%s$O!"(BX11$BHG(B Emi Clock $B3+H/$N$?(B
 *     $B$a!"(BMotosoft $B$h$j!H8E>l(B $B@59T!I$X8D?ME*$K%i%$%;%s%96!M?$5$l$F$^$9!#(B
 *     $BBh;0<T$XFs<!%i%$%;%s%96!M?$9$k$3$H$OG'$a$i$l$F$*$j$^$;$s!#(B
 *  9. Motosoft $B$H8E>l$KL5CG$G!"K\%=%U%H%&%'%"$N2hA|%G!<%?$rFs<!MxMQ$9$k$3(B
 *     $B$H$r6X;_$7$^$9!#(B
 * 10. $B$3$3$K5-=R$7$?0J30$N8"Mx$K$D$$$F$O!"F|K\9q$NCx:n8"K!$K$h$k$b$N$H$7(B
 *     $B$^$9!#(B
 */

#ifndef	_EMI_SOUND_H_
#define	_EMI_SOUND_H_


#ifndef	USE_NETAUDIO


/*
 *  NEWS-OS 4.x and 6.x
 */

#if defined(__sony_news) && defined(USE_SOUND)

#if NEWSOS_MAJOR == 4
# include <sys/file.h>			/* $B%U%!%$%k4X78$N7?!?Dj?tDj5A(B */
# include <newsiodev/sound.h>		/* NEWS-OS $B%5%&%s%I%G%P%$%9(B */
#else	/* NEWS-OS 6.x */
# include <sys/fcntl.h>			/* $B%U%!%$%k4X78$N7?!?Dj?tDj5A(B */
# include <sys/sound.h>			/* NEWS-OS 6.x $B%5%&%s%IDj5A(B */
#endif
#include <soundlib.h>			/* NEWS-OS $B%5%&%s%I%i%$%V%i%j(B */
#include <errno.h>			/* $B%(%i!<HV9fDj5A(B */

/* $B%5%&%s%I%-%c%C%7%e%P%C%U%!9=B$BN(B */
struct SoundCacheBufferTag {
    char		*soundCacheBuffer;	/* $B%R!<%W>e$K3NJ]$7$?%G!<%?(B */
    int			soundLength;		/* $B%5%&%s%I%G!<%?D9(B */
    struct sbparam	soundBParam;		/* $B%5%&%s%I>pJs(B */
};

#define	SoundCacheBuffer	struct SoundCacheBufferTag

#endif	/* NEWS-OS */


/*
 *  IRIX
 */

#if defined(sgi) && defined(USE_SOUND)

#include <fcntl.h>
#include <audio.h>
#include <audiofile.h>
#include <invent.h>

/* $B%5%&%s%I%-%c%C%7%e%P%C%U%!9=B$BN(B */
struct SoundCacheBufferTag {
    char	**cache;
    int		num_bufs;
    int		f_size;		/* frame size */
    int		frames;		/* frames / sample buffer */
    int		samples;	/* samples / sample buffer */
    int		l_frames;	/* leftover_frames */
    long	wordsize;    
    double	rate;		/* audio file sample rate */
};

#define	SoundCacheBuffer	struct SoundCacheBufferTag

#endif	/* IRIX */


/*
 *  HP-UX
 */

#if defined(__hpux) && defined(USE_SOUND)

#include <audio/Alib.h>

/* $B%5%&%s%I%-%c%C%7%e%P%C%U%!9=B$BN(B */
struct SoundCacheBufferTag {
  SBucket	*soundBucket;	/* sound bucket */
  SBPlayParams	playParams;	/* play parameters */
};

#define	SoundCacheBuffer	struct SoundCacheBufferTag

#endif	/* HP-UX */


/*
 *  SunOS
 */

#if defined(sun) && defined(USE_SOUND)

#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/stropts.h>
#ifndef	solaris
#include <sun/audioio.h>
#else	/* solaris */
#include <sys/audioio.h>
#endif	/* !solaris */

#define	AUDIO_DEVICE		"/dev/audio"
#define	AUDIO_CTLDEVICE		"/dev/audioctl"
#define	AUDIOMAGICNUMBER	(0x2e736e64)		/* ".snd" */
#ifndef AUDIO_ENCODING_LINEAR
#define AUDIO_ENCODING_LINEAR	(3)	/* Linear PCM encoding */
#endif

/* $B%5%&%s%I%-%c%C%7%e%P%C%U%!9=B$BN(B */
struct SoundCacheBufferTag {
    char		*soundCacheBuffer;	/* $B%R!<%W>e$K3NJ]$7$?%G!<%?(B */
    int			soundLength;		/* $B%5%&%s%I%G!<%?D9(B */
    audio_info_t	soundBParam;
};

#define	SoundCacheBuffer	struct SoundCacheBufferTag

#endif	/* SunOS */


/*
 *  BSDI BSD/OS
 */

#if defined(__bsdi__) && defined(USE_SOUND)

/* BSDI BSD/OS with SoundBlaster Pro */

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <i386/isa/sblast.h>

/* $B%5%&%s%I%-%c%C%7%e%P%C%U%!9=B$BN(B */
struct SoundCacheBufferTag {
    char	*soundCacheBuffer;	/* $B%R!<%W>e$K3NJ]$7$?%G!<%?(B */
    int		soundLength;		/* $B%5%&%s%I%G!<%?D9(B */
};

#define	SoundCacheBuffer	struct SoundCacheBufferTag
#define	AUDIO_DEVICE		"/dev/sb_dsp"
#define	DSP_SPEED		43478

#endif	/* BSDI BSD/OS */


/*
 *  Linux
 */

#if defined(linux) && defined(USE_SOUND)

/* Linux with SoundBlaster Pro */

#include <fcntl.h>
#include <sys/stat.h>
#include <linux/soundcard.h>

struct SoundCacheBufferTag {
    char	*soundCacheBuffer;
    int		soundLength;
};

#define	SoundCacheBuffer	struct SoundCacheBufferTag
#define	AUDIO_DEVICE		"/dev/audio"

#endif	/* Linux */


/*
 *  FreeBSD
 */

#if defined(__FreeBSD__) && defined(USE_SOUND)

/* FreeBSD with SoundBlaster Pro */

#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <machine/soundcard.h>

#undef	O_RDWR
#define	O_RDWR	O_WRONLY	/* audio $B%G%P%$%9$OF1;~%*!<%W%s$G$-$J$$!)(B */

struct SoundCacheBufferTag {
    char	*soundCacheBuffer;
    int		soundLength;
};

#define	SoundCacheBuffer	struct SoundCacheBufferTag
#define	AUDIO_DEVICE		"/dev/audio"

#endif	/* FreeBSD */


#else	/* USE_NETAUDIO */


/*
 *  netaudio (NCDaudio)
 */

#if defined(USE_SOUND)

/* Net Audio (NCDaudio) */

#include <audio/audiolib.h>
#include <audio/Xtutil.h>

/* $B%5%&%s%I%-%c%C%7%e%P%C%U%!9=B$BN(B */
struct SoundCacheBufferTag {
	AuBucketID	bucket;
};

#define	SoundCacheBuffer	struct SoundCacheBufferTag

#endif


#endif	/* !USE_NETAUDIO */


/*
 *  $B%5%&%s%I%-%c%C%7%e%P%C%U%!9=B$BN$,L$Dj5A$N>l9g$N7?Dj5A(B
 */

#ifndef	SoundCacheBuffer
#define	SoundCacheBuffer	void *
#endif	/* !SoundCacheBuffer */


/* $B4X?t$N%W%m%H%?%$%W@k8@(B */
#ifdef	USE_SOUND
static void	S_SoundEnvInit		__P((void));
static Boolean	S_IsSoundAvailable	__P((void));
static int	S_PlaySound		__P((char *));
static Boolean	S_IsSoundCacheAvailable	__P((void));
static int	S_CacheSound		__P((char *, SoundCacheBuffer *));
static int	S_PlayCacheSound	__P((SoundCacheBuffer *));
static void	S_FreeCacheSound	__P((SoundCacheBuffer *));
static void	S_SoundEnvDispose	__P((void));
#endif	/* USE_SOUND */

#endif	/* !_EMI_SOUND_H_ */
