/*
**
**	$Id: CascadeMenu.c,v 1.1.1.1 1997/01/12 08:41:40 masa-k Exp $
**
*/

/*
**  Copyright (C) 1994 Issei Numata  issei@jaist.ac.jp
**
**  NOTICE:
**
**  1) You may use, copy, distribute and sell verbatim copies of this 
**     Program's source code as you receive it with above copyright and
**     this notice.
**
**  2) You may modify your copy or copies of the Program or any portion
**     of it, and use, copy, distribute and sell such modifications with 
**     above copyright and this notice. But, you must specify that this 
**     program is modifyied from original.
*/

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#ifndef USE_XAW3D
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/SimpleMenP.h>
#include <X11/Xaw/XawInit.h>
#else   /* USE_XAW3D */
#include <X11/Xaw3d/Cardinals.h>
#include <X11/Xaw3d/SimpleMenP.h>
#include <X11/Xaw3d/XawInit.h>
#endif  /* !USE_XAW3D */
#include <X11/Xmu/Initer.h>
#include <X11/Xmu/CharSet.h>
#include "CascadeMenuP.h"

#ifdef USE_XAWI18N
#include <X11/Xaw/Xawi18n.h>
#endif

#ifndef ForAllChildren
#define ForAllChildren(x, childP) \
  for ( (childP) = (SmeObject *) (x)->composite.children ; \
        (childP) < (SmeObject *) ( (x)->composite.children + \
                               (x)->composite.num_children ) ; \
        (childP)++ )
#endif

#define offset(field) XtOffsetOf(CascadeMenuRec, cascade_menu.field)
/*
static XtResource resources[] = {
};
*/
#undef offset

static char defaultTranslations[] = 
  "<EnterWindow>:     highlight() cascade_enter()      \n\
   <LeaveWindow>:     unhighlight() cascade_leave()    \n\
   <BtnUp>:           unhighlight() cascade_select() MenuPopdown() \n\
   <BtnMotion>:       highlight()";

/*
 * Semi Public function definitions. 
 */

static void Redisplay(), Realize(), Resize(), ChangeManaged();
static void Initialize(), ClassInitialize(), ClassPartInitialize();
static Boolean SetValues(), SetValuesHook();
static XtGeometryResult GeometryManager();

/*
 * Action Routine Definitions
 */

static void CascadePopup(), CascadePopdown(), CascadeSelect();
static void CascadeEnter(), CascadeLeave();
  
/* 
 * Private Function Definitions.
 */

static void PushCascadeStack();
static Widget PopCascadeStack(),PeekCascadeStack();

static XtActionsRec actionsList[] =
{
  {"cascade_popup",	CascadePopup},
  {"cascade_popdown",	CascadePopdown},
  {"cascade_select",	CascadeSelect},
  {"cascade_enter",	CascadeEnter},
  {"cascade_leave",	CascadeLeave},
};
 
static CompositeClassExtensionRec extension_rec = {
    /* next_extension */  NULL,
    /* record_type */     NULLQUARK,
    /* version */         XtCompositeExtensionVersion,
    /* record_size */     sizeof(CompositeClassExtensionRec),
    /* accepts_objects */ TRUE,
};

#define superclass (&simpleMenuClassRec)
    
CascadeMenuClassRec cascadeMenuClassRec = {
  {
    /* superclass         */    (WidgetClass) superclass,
    /* class_name         */    "CascadeMenu",
    /* size               */    sizeof(CascadeMenuRec),
    /* class_initialize   */	ClassInitialize,
    /* class_part_initialize*/	ClassPartInitialize,
    /* Class init'ed      */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */	NULL,
    /* realize            */    Realize,
    /* actions            */    actionsList,
    /* num_actions        */    XtNumber(actionsList),
    /* resources          */    NULL,
    /* resource_count     */	0,
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE, 
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/ 	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    Resize,
    /* expose             */    Redisplay,
    /* set_values         */    SetValues,
    /* set_values_hook    */	SetValuesHook,
    /* set_values_almost  */	XtInheritSetValuesAlmost,  
    /* get_values_hook    */	NULL,			
    /* accept_focus       */    NULL,
    /* intrinsics version */	XtVersion,
    /* callback offsets   */    NULL,
    /* tm_table		  */    defaultTranslations,
    /* query_geometry	  */    NULL,
    /* display_accelerator*/    NULL,
    /* extension	  */    NULL
  },{
    /* geometry_manager   */    GeometryManager,
    /* change_managed     */    ChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension	  */    NULL
  },{
    /* Shell extension	  */    NULL
  },{
    /* Override extension */    NULL
  },{
    /* Simple Menu extension*/  NULL
  },{
    /* num_of_widget */ 0,
    /* widgets 	     */ NULL	
  }
};

WidgetClass cascadeMenuWidgetClass = (WidgetClass)&cascadeMenuClassRec;

/*
**	Smi Public Func.
*/

static void
ClassInitialize()
{
  XawInitializeWidgetSet();
/*
  XtAddConverter( XtRString, XtRBackingStore, XmuCvtStringToBackingStore,
                 (XtConvertArgList)NULL, (Cardinal)0 );
*/
  cascadeMenuClassRec.cascadeMenu_Class.widgets = 
    (Widget *)XtMalloc(sizeof(Widget)*10);
}

static void
ClassPartInitialize(wc)
WidgetClass wc;
{
  CascadeMenuWidgetClass cmwc = (CascadeMenuWidgetClass) wc;

  extension_rec.next_extension = cmwc->composite_class.extension;
  cmwc->composite_class.extension = (XtPointer) &extension_rec;
}

static void
Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal *num_args;
{
  CascadeMenuWidget cmw = (CascadeMenuWidget) new;

  cmw->cascade_menu.already_popuped = False;
}

static void
Redisplay(w, event, region)
Widget w;
XEvent * event;
Region region;
{
  CascadeMenuWidget cmw = (CascadeMenuWidget) w;

  (*superclass->core_class.expose)(w,event,region);

/*  fprintf(stderr,"%d\n",cmw->shell.popped_up);*/
  if(cmw->cascade_menu.already_popuped==False){
    PushCascadeStack(w);
    cmw->cascade_menu.pre_called_widget = (Widget)NULL;
    cmw->cascade_menu.already_popuped = True;
  }
}

static void
Realize(w, mask, attrs)
Widget w;
XtValueMask * mask;
XSetWindowAttributes * attrs;
{
  (*superclass->core_class.realize)(w,mask,attrs);
}

static void
Resize(w)
Widget w;
{
  (*superclass->core_class.resize)(w);
}

static Boolean
SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
{
  Boolean ret;
    
  ret = (*superclass->core_class.set_values)(current, request, new, args, num_args);
  return ret;
}

static Boolean
SetValuesHook(w, arglist, num_args)
Widget w;
ArgList arglist;
Cardinal *num_args;
{
  Boolean ret;

  ret = (*superclass->core_class.set_values_hook)(w,arglist,num_args);
  return ret;
}

static XtGeometryResult
GeometryManager(w, request, reply)
Widget w;
XtWidgetGeometry * request, * reply;
{
  XtGeometryResult ret;

  ret = (*superclass->composite_class.geometry_manager)(w,request,reply);
  return ret;
}

static void
ChangeManaged(w)
     Widget w;
{
  (*superclass->composite_class.change_managed)(w);
}

#define NW ((&cascadeMenuClassRec)->cascadeMenu_Class.num_of_widget)
#define W  ((&cascadeMenuClassRec)->cascadeMenu_Class.widgets)

static void
PushCascadeStack(w)
     Widget w;
{
  CascadeMenuWidget cmw = (CascadeMenuWidget) w;

  if(NW>10){
    fprintf(stderr,"Warning: too many cascade widget pupup!\n");
    return;
  }
  cmw->cascade_menu.cascade_level = NW;
/*  fprintf(stderr,"push %d %s\n",NW,XtName(w));*/
  W[NW++] = w;
}

static Widget
PopCascadeStack()
{
  if(NW<=0){
    return (Widget)NULL;
  }
  --NW;
/*  fprintf(stderr,"pop %d %s\n",NW-1,XtName(W[NW-1]));*/
  return W[NW];
}
static Widget
PeekCascadeStack()
{
  if(NW<=0){
    return (Widget)NULL;
  }
/*  fprintf(stderr,"peek %d %s\n",NW-1,XtName(W[NW-1]));*/
  return W[NW-1];
}

static void
CascadePopup(w, event, params, num_params)
     Widget w;
     XEvent * event;
     String * params;
     Cardinal * num_params;
{ 
  int x,y,obj_y;
  Dimension obj_h;
/*
  int obj_x;
  Dimension obj_w;
*/
  CascadeMenuWidget cmw = (CascadeMenuWidget) w;
  CascadeMenuWidget ww;
  SmeObject *entry,e;

  x = event->xmotion.x;
  y = event->xmotion.y;
  
  if(x < cmw->core.width && x>0)
    return;

  ForAllChildren(cmw,entry){
    if(!XtIsManaged((Widget)*entry))
      continue;
    obj_y = (*entry)->rectangle.y;
    obj_h = (*entry)->rectangle.height;
    if(y >= obj_y && y < obj_y + (int)obj_h){
      e = *entry;
      if(XtIsSubclass((Widget)e,smeBSBObjectClass) &&
	 ((SmeBSBObject)e)->sme_bsb.right_bitmap && e->sme.callbacks &&
	 cmw->cascade_menu.pre_called_widget != (Widget)e){
	while(cmw->cascade_menu.cascade_level+1 < NW &&
	      PeekCascadeStack()!=NULL ){ 
	  ww = (CascadeMenuWidget)PopCascadeStack();
	  XtPopdown((Widget)ww);
          ww->cascade_menu.already_popuped = False;
	}
	XtCallCallbacks((Widget)e, XtNcallback, NULL);
	cmw->cascade_menu.pre_called_widget = (Widget)e;
	return;
      }
    }
  } 
}
static void
CascadeSelect(w, event, params, num_params)
     Widget w;
     XEvent * event;
     String * params;
     Cardinal * num_params;
{ 
  int x,y,obj_y;
  Dimension obj_h;
  int obj_x;
  Dimension obj_w;
  CascadeMenuWidget cmw = (CascadeMenuWidget) w;
  CascadeMenuWidget ww;
  SmeObject *entry,e;

  x = event->xmotion.x;
  y = event->xmotion.y;

/*fprintf(stderr,"%s %s\n",XtName(w),XtName(W[0]));*/
  if(cmw->cascade_menu.pointer_in == True){
    ForAllChildren(cmw,entry){
      if(!XtIsManaged((Widget)*entry))
	continue;
      obj_x = (*entry)->rectangle.x;
      obj_y = (*entry)->rectangle.y;
      obj_w = (*entry)->rectangle.width;
      obj_h = (*entry)->rectangle.height;
/*
fprintf( stderr,"x=%d y=%d objx=%d objy=%d objw=%d objh=%d\n",x,y,obj_x,obj_y,obj_w,obj_h);*/
      if(y >= obj_y && y < obj_y + (int)obj_h &&
	 x >= obj_x && x < obj_x + (int)obj_w){
	e = *entry;
	if(XtIsSubclass((Widget)e,smeBSBObjectClass) &&
	   !((SmeBSBObject)e)->sme_bsb.right_bitmap && e->sme.callbacks){
	  if(PeekCascadeStack()!=NULL){
	    ww = (CascadeMenuWidget)PopCascadeStack();
	    XtPopdown((Widget)ww);
            ww->cascade_menu.already_popuped = False;
	  }
	  XtCallCallbacks((Widget)e, XtNcallback, NULL);
	  return;
	}
      }
    }
  }
  CascadePopdown(w, event, params, num_params);
} 
static void
CascadePopdown(w, event, params, num_params)
     Widget w;
     XEvent * event;
     String * params;
     Cardinal * num_params;
{ 
  Widget ww;

  while((ww=PopCascadeStack())!=NULL){
    XtPopdown(ww);
    ((CascadeMenuWidget)ww)->cascade_menu.already_popuped = False;
  }
} 
static void
CascadeEnter(w, event, params, num_params)
     Widget w;
     XEvent * event;
     String * params;
     Cardinal * num_params;
{
  CascadeMenuWidget cmw = (CascadeMenuWidget) w;

  CascadePopup(w,event,params,num_params);
  
/*  fprintf(stderr,"enter\n");*/
  cmw->cascade_menu.pointer_in = True;
}
static void
CascadeLeave(w, event, params, num_params)
     Widget w;
     XEvent * event;
     String * params;
     Cardinal * num_params;
{
  CascadeMenuWidget cmw = (CascadeMenuWidget) w;

  CascadePopup(w,event,params,num_params);
  
/*  fprintf(stderr,"leave\n");*/
  cmw->cascade_menu.pointer_in = False;
}

#undef W
#undef NW
