# Generated by default/object.tt
package Paws::AppMesh::GatewayRouteData;
  use Moose;
  has GatewayRouteName => (is => 'ro', isa => 'Str', request_name => 'gatewayRouteName', traits => ['NameInRequest'], required => 1);
  has MeshName => (is => 'ro', isa => 'Str', request_name => 'meshName', traits => ['NameInRequest'], required => 1);
  has Metadata => (is => 'ro', isa => 'Paws::AppMesh::ResourceMetadata', request_name => 'metadata', traits => ['NameInRequest'], required => 1);
  has Spec => (is => 'ro', isa => 'Paws::AppMesh::GatewayRouteSpec', request_name => 'spec', traits => ['NameInRequest'], required => 1);
  has Status => (is => 'ro', isa => 'Paws::AppMesh::GatewayRouteStatus', request_name => 'status', traits => ['NameInRequest'], required => 1);
  has VirtualGatewayName => (is => 'ro', isa => 'Str', request_name => 'virtualGatewayName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::GatewayRouteData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::GatewayRouteData object:

  $service_obj->Method(Att1 => { GatewayRouteName => $value, ..., VirtualGatewayName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::GatewayRouteData object:

  $result = $service_obj->Method(...);
  $result->Att1->GatewayRouteName

=head1 DESCRIPTION

An object that represents a gateway route returned by a describe
operation.

=head1 ATTRIBUTES


=head2 B<REQUIRED> GatewayRouteName => Str

The name of the gateway route.


=head2 B<REQUIRED> MeshName => Str

The name of the service mesh that the resource resides in.


=head2 B<REQUIRED> Metadata => L<Paws::AppMesh::ResourceMetadata>




=head2 B<REQUIRED> Spec => L<Paws::AppMesh::GatewayRouteSpec>

The specifications of the gateway route.


=head2 B<REQUIRED> Status => L<Paws::AppMesh::GatewayRouteStatus>

The status of the gateway route.


=head2 B<REQUIRED> VirtualGatewayName => Str

The virtual gateway that the gateway route is associated with.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

