/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess;

import gnu.getopt.Getopt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import opennlp.common.preprocess.POSTagger;
import opennlp.common.preprocess.Tokenizer;
import opennlp.grok.preprocess.postag.EnglishPOSTaggerME;
import opennlp.grok.preprocess.tokenize.EnglishTokenizerME;

class TokPosServer
extends Thread {
    private Socket socket;
    private POSTagger tagger = new EnglishPOSTaggerME();
    private Tokenizer tokenizer = new EnglishTokenizerME();
    private int responseCode = 619;

    public TokPosServer(Socket s, int c) {
        super("TokPosTaggerThread");
        this.responseCode = c;
        this.socket = s;
    }

    public static String getMessage(DataInputStream in) {
        int inLen = 0;
        boolean totalAmtRead = false;
        boolean RC = true;
        try {
            inLen = in.readInt();
            byte[] input = new byte[inLen];
            if (inLen < 100000) {
                in.readFully(input, 0, inLen);
                return new String(input);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
            DataOutputStream binaryOut = new DataOutputStream(this.socket.getOutputStream());
            DataInputStream in = new DataInputStream(this.socket.getInputStream());
            try {
                try {
                    String line;
                    block6: while ((line = TokPosServer.getMessage(in)) != null) {
                        void var4_5;
                        if (var4_5.length() == 0) continue;
                        line = var4_5.substring(4);
                        if (line.endsWith("?") || line.endsWith(".") || line.endsWith("!")) {
                            line = line.substring(0, line.length() - 1) + " " + line.substring(line.length() - 1);
                        }
                        String[] tokens = this.tokenizer.tokenize(line);
                        String[] tags = this.tagger.tag(tokens);
                        StringBuffer message = new StringBuffer();
                        message.append(tokens[0] + "_" + tags[0]);
                        int i = 1;
                        while (true) {
                            if (i >= tokens.length) {
                                String messageStr = this.responseCode + " " + message.toString();
                                binaryOut.writeInt(messageStr.length());
                                out.print(messageStr);
                                out.flush();
                                continue block6;
                            }
                            message.append(" " + tokens[i] + "_" + tags[i]);
                            ++i;
                        }
                    }
                }
                catch (Exception E) {
                    out.println("Error: " + E);
                    Object var11_13 = null;
                    System.out.println("Closing connection");
                    out.close();
                    in.close();
                    this.socket.close();
                    return;
                }
                Object var11_12 = null;
                System.out.println("Closing connection");
                out.close();
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                System.out.println("Closing connection");
                out.close();
                in.close();
                this.socket.close();
                throw throwable;
            }
            in.close();
            this.socket.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        int c;
        ServerSocket serverSocket = null;
        boolean listening = true;
        int port = 1059;
        int code = 619;
        Getopt g = new Getopt("PipeClient", args, "p:c:");
        while ((c = g.getopt()) != -1) {
            void var6_6;
            switch (var6_6) {
                case 112: {
                    port = Integer.parseInt(g.getOptarg());
                    break;
                }
                case 99: {
                    code = Integer.parseInt(g.getOptarg());
                }
            }
        }
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: " + port);
            System.exit(-1);
        }
        while (listening) {
            System.out.println("Waiting for Connection");
            new TokPosServer(serverSocket.accept(), code).start();
        }
        serverSocket.close();
    }
}

