/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDNumberTreeNode
implements COSObjectable {
    private COSDictionary node;
    private Class<?> valueType = null;

    public PDNumberTreeNode(Class<?> valueClass) {
        this.node = new COSDictionary();
        this.valueType = valueClass;
    }

    public PDNumberTreeNode(COSDictionary dict, Class<?> valueClass) {
        this.node = dict;
        this.valueType = valueClass;
    }

    @Override
    public COSBase getCOSObject() {
        return this.node;
    }

    public COSDictionary getCOSDictionary() {
        return this.node;
    }

    public List getKids() {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.node.getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<PDNumberTreeNode> pdObjects = new ArrayList<PDNumberTreeNode>();
            for (int i = 0; i < kids.size(); ++i) {
                pdObjects.add(this.createChildNode((COSDictionary)kids.getObject(i)));
            }
            retval = new COSArrayList(pdObjects, kids);
        }
        return retval;
    }

    public void setKids(List kids) {
        this.node.setItem(COSName.KIDS, (COSBase)COSArrayList.converterToCOSArray(kids));
    }

    public Object getValue(Integer index) throws IOException {
        Object retval = null;
        Map names = this.getNumbers();
        if (names != null) {
            retval = names.get(index);
        } else {
            List kids = this.getKids();
            for (int i = 0; i < kids.size() && retval == null; ++i) {
                PDNumberTreeNode childNode = (PDNumberTreeNode)kids.get(i);
                if (childNode.getLowerLimit().compareTo(index) > 0 || childNode.getUpperLimit().compareTo(index) < 0) continue;
                retval = childNode.getValue(index);
            }
        }
        return retval;
    }

    public Map getNumbers() throws IOException {
        Map<Integer, Object> indices = null;
        COSArray namesArray = (COSArray)this.node.getDictionaryObject(COSName.NUMS);
        if (namesArray != null) {
            indices = new HashMap();
            for (int i = 0; i < namesArray.size(); i += 2) {
                COSInteger key = (COSInteger)namesArray.getObject(i);
                COSBase cosValue = namesArray.getObject(i + 1);
                Object pdValue = this.convertCOSToPD(cosValue);
                indices.put(key.intValue(), pdValue);
            }
            indices = Collections.unmodifiableMap(indices);
        }
        return indices;
    }

    protected Object convertCOSToPD(COSBase base) throws IOException {
        Object retval = null;
        try {
            Constructor<?> ctor = this.valueType.getConstructor(base.getClass());
            retval = ctor.newInstance(base);
        }
        catch (Throwable t) {
            throw new IOException("Error while trying to create value in number tree:" + t.getMessage());
        }
        return retval;
    }

    protected PDNumberTreeNode createChildNode(COSDictionary dic) {
        return new PDNumberTreeNode(dic, this.valueType);
    }

    public void setNumbers(Map<Integer, Object> numbers) {
        if (numbers == null) {
            this.node.setItem(COSName.NUMS, (COSObjectable)null);
            this.node.setItem(COSName.LIMITS, (COSObjectable)null);
        } else {
            ArrayList<Integer> keys = new ArrayList<Integer>(numbers.keySet());
            Collections.sort(keys);
            COSArray array = new COSArray();
            for (int i = 0; i < keys.size(); ++i) {
                Integer key = (Integer)keys.get(i);
                array.add(COSInteger.get(key.intValue()));
                COSObjectable obj = (COSObjectable)numbers.get(key);
                array.add(obj);
            }
            Integer lower = null;
            Integer upper = null;
            if (keys.size() > 0) {
                lower = (Integer)keys.get(0);
                upper = (Integer)keys.get(keys.size() - 1);
            }
            this.setUpperLimit(upper);
            this.setLowerLimit(lower);
            this.node.setItem(COSName.NUMS, (COSBase)array);
        }
    }

    public Integer getUpperLimit() {
        Integer retval = null;
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr != null) {
            retval = arr.getInt(1);
        }
        return retval;
    }

    private void setUpperLimit(Integer upper) {
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr == null) {
            arr = new COSArray();
            arr.add(null);
            arr.add(null);
        }
        arr.setInt(1, upper);
    }

    public Integer getLowerLimit() {
        Integer retval = null;
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr != null) {
            retval = arr.getInt(0);
        }
        return retval;
    }

    private void setLowerLimit(Integer lower) {
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr == null) {
            arr = new COSArray();
            arr.add(null);
            arr.add(null);
        }
        arr.setInt(0, lower);
    }
}

