package Net::Amazon::EMR::ClusterStateChangeReason;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;

subtype 'Net::Amazon::EMR::Type::ClusterStateChangeReason::Code' => as 'Str' => where { m/^(?:INTERNAL_ERROR | VALIDATION_ERROR | INSTANCE_FAILURE | BOOTSTRAP_FAILURE | USER_REQUEST | STEP_FAILURE | ALL_STEPS_COMPLETED)$/x };

has 'Code' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::ClusterStateChangeReason::Code',
);

has 'Message' => ( is => 'ro', 
                   isa => 'Str' );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::ClusterStateChangeReason

=head1 DESCRIPTION

Implements the ClusterStateChangeReason data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_ClusterStateChangeReason.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
